/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.elements;

import blusunrize.immersiveengineering.client.ClientUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class GuiDataVariableList
extends GuiButton {
    private static final ResourceLocation TEXTURE_VARIABLES = new ResourceLocation("immersiveintelligence:textures/gui/data_input_machine.png");
    private final DataPacket packet;
    private int scroll;
    private int maxScroll;
    public boolean edit = false;
    public boolean delete = false;
    public boolean add = false;
    public int selectedOption = -1;

    public GuiDataVariableList(int id, int x, int y, int w, int h, DataPacket packet) {
        super(id, x, y, w, h, "");
        this.packet = packet;
        this.recalculateEntries();
        this.scroll = this.maxScroll;
    }

    public void recalculateEntries() {
        this.maxScroll = Math.max(this.packet.variables.size() - 4, 0) * 20;
        this.edit = false;
        this.delete = false;
    }

    public void setScrollPercent(float percent) {
        this.recalculateEntries();
        this.scroll = Math.round(MathHelper.func_76131_a((float)(percent * (float)this.maxScroll), (float)0.0f, (float)this.maxScroll));
    }

    public float getScrollPercent() {
        return (float)this.scroll / (float)this.maxScroll;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mx, int my, float partialTicks) {
        this.edit = false;
        this.delete = false;
        this.add = false;
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            this.delete = true;
        } else if (this.packet.variables.size() > 0 && Utils.isPointInRectangle(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + this.field_146121_g, mx, my)) {
            int mouseChange = Mouse.getDWheel();
            this.scroll -= Integer.signum(mouseChange) * 15;
            if (Mouse.isButtonDown((int)0) && Utils.isPointInRectangle(this.field_146128_h + this.field_146120_f - 11, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + 114, mx, my)) {
                float v = (float)(my - this.field_146129_i) / (float)this.field_146121_g;
                this.setScrollPercent(((float)(my - this.field_146129_i) + (v > 0.5f ? v / 20.0f : -v / 20.0f)) / 114.0f);
            }
            this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)this.maxScroll);
            this.selectedOption = (int)Math.floor((float)(my + this.scroll - this.field_146129_i) / 20.0f);
            if (this.selectedOption >= this.packet.variables.size()) {
                this.selectedOption = -1;
            } else {
                int localY = my + this.scroll - this.field_146129_i - this.selectedOption * 20;
                if (localY > 4 && localY < 16) {
                    int localX = mx - this.field_146128_h - 97;
                    this.edit = localX > 1 && localX < 13;
                    this.delete = localX > 14 && localX < 26;
                }
            }
        } else {
            this.selectedOption = -1;
        }
        GlStateManager.func_179094_E();
        Utils.bindTexture(TEXTURE_VARIABLES);
        this.func_73729_b(this.field_146128_h + this.field_146120_f - 10, this.field_146129_i + (int)(this.getScrollPercent() * 100.0f), 128, 222, 9, 14);
        this.scissor(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        int i = 0;
        for (char c : DataPacket.varCharacters) {
            if (!this.packet.variables.containsKey(Character.valueOf(c))) continue;
            IDataType data = this.packet.getPacketVariable(Character.valueOf(c));
            this.drawEntry(mc, this.field_146128_h, this.field_146129_i + i * 20 - this.scroll, i == this.selectedOption, data, c);
            ++i;
        }
        this.drawAddButton(mc.field_71466_p, mx, my);
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
    }

    private void drawAddButton(FontRenderer fr, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.bindTexture(TEXTURE_VARIABLES);
        GlStateManager.func_179094_E();
        int length = this.packet.variables.size() * 20 - this.scroll;
        this.func_73729_b(this.field_146128_h + 56, this.field_146129_i + length, 137, 222, 18, 18);
        this.add = Utils.isPointInRectangle(this.field_146128_h + 56, this.field_146129_i + length, this.field_146128_h + 56 + 18, this.field_146129_i + length + 18, mx, my);
        fr.func_175065_a("+", (float)(this.field_146128_h + 62), (float)(this.field_146129_i + 5 + length), this.add ? -557004 : 0xFFFFFF, true);
        GL11.glPopMatrix();
    }

    void drawEntry(Minecraft mc, int x, int y, boolean hovered, IDataType data, char c) {
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        Utils.bindTexture(TEXTURE_VARIABLES);
        this.func_73729_b(x, y, 0, 222, 128, 20);
        this.func_73729_b(x + 93 + 6, y + 4, hovered && this.edit ? 12 : 0, 242, 12, 12);
        this.func_73729_b(x + 93 + 14 + 5, y + 4, hovered && this.delete ? 36 : 24, 242, 12, 12);
        float[] rgb = Utils.rgbIntToRGB(data.getTypeColour());
        GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
        this.func_73729_b(x + 1, y, 155, 222, 12, 20);
        this.func_73729_b(x + 52 + 2, y, 166, 222, 22, 20);
        this.func_73729_b(x + 120 + 2, y, 191, 222, 8, 20);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture((String)String.format("immersiveintelligence:textures/gui/data_types/%s.png", data.getName()));
        ClientUtils.drawTexturedRect((float)(x + 26), (float)(y + 4), (float)12.0f, (float)12.0f, (double[])new double[]{0.0, 1.0, 0.0, 1.0});
        FontRenderer f = mc.field_71466_p;
        if (data instanceof DataTypeExpression) {
            f.func_175065_a(I18n.func_135052_a((String)("datasystem.immersiveintelligence.function." + ((DataTypeExpression)data).getOperation().name), (Object[])new Object[0]), (float)(x + 38), (float)(y + 7), MathHelper.func_180188_d((int)data.getTypeColour(), (int)0xCACACA), false);
        } else {
            f.func_175065_a(I18n.func_135052_a((String)("datasystem.immersiveintelligence.datatype." + data.getName()), (Object[])new Object[0]), (float)(x + 38), (float)(y + 7), MathHelper.func_180188_d((int)data.getTypeColour(), (int)0xCACACA), false);
        }
        f.func_175065_a(String.valueOf(c), (float)(x + 11), (float)(y + 5), -557004, true);
        GL11.glPopMatrix();
    }

    private void scissor(int x, int y, int xSize, int ySize) {
        GL11.glEnable((int)3089);
        ScaledResolution res = new ScaledResolution(ClientUtils.mc());
        y = ClientUtils.mc().field_71440_d - y * res.func_78325_e() - (ySize *= res.func_78325_e());
        GL11.glScissor((int)(x *= res.func_78325_e()), (int)y, (int)(xSize *= res.func_78325_e()), (int)ySize);
    }

    public boolean func_146116_c(Minecraft mc, int mx, int my) {
        return this.add || this.selectedOption != -1 && (this.delete || this.edit);
    }
}

