/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.fx;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import pl.pabilo8.immersiveintelligence.client.fx.IIParticle;

public class ParticleRenderer {
    public static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    private final Map<DrawingStages, Queue<IIParticle>> particles = new HashMap<DrawingStages, Queue<IIParticle>>();
    private static final int MAX_PARTICLES = 2000;
    private static final int MAX_DRAWN_PARTICLES = 1000;

    public void updateParticles() {
        int count = 0;
        for (Queue<IIParticle> particleQueue : this.particles.values()) {
            Iterator iterator = particleQueue.iterator();
            while (iterator.hasNext() && ++count <= 2000) {
                IIParticle particle = (IIParticle)((Object)iterator.next());
                particle.func_189213_a();
                if (particle.func_187113_k()) continue;
                iterator.remove();
            }
        }
    }

    public void renderParticles(float partialTicks) {
        float x = ActiveRenderInfo.func_178808_b();
        float z = ActiveRenderInfo.func_178803_d();
        float yz = ActiveRenderInfo.func_178805_e();
        float xy = ActiveRenderInfo.func_178807_f();
        float xz = ActiveRenderInfo.func_178809_c();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ParticleRenderer.updateParticleFields(partialTicks, (EntityPlayer)player);
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            block0: for (Map.Entry<DrawingStages, Queue<IIParticle>> particleStage : this.particles.entrySet()) {
                int particleCount = 0;
                particleStage.getKey().prepareRender(buffer);
                for (IIParticle particle : particleStage.getValue()) {
                    if (++particleCount > 1000) {
                        tess.func_78381_a();
                        particleStage.getKey().clear();
                        break block0;
                    }
                    particle.func_180434_a(buffer, (Entity)player, partialTicks, x, xz, z, yz, xy);
                }
                tess.func_78381_a();
                particleStage.getKey().clear();
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179121_F();
        }
    }

    private static void updateParticleFields(float partialTicks, EntityPlayer player) {
        Particle.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = player.func_70676_i(partialTicks);
    }

    public void addEffect(IIParticle p) {
        if (this.particles.values().stream().mapToInt(Collection::size).sum() < 2000) {
            this.particles.computeIfAbsent(p.getDrawStage(), i -> new ArrayDeque()).add(p);
        }
    }

    public static enum DrawingStages {
        NORMAL(GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, DefaultVertexFormats.field_181704_d, false, PARTICLE_TEXTURES),
        CUSTOM(GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, DefaultVertexFormats.field_181704_d, false, TextureMap.field_110575_b),
        CUSTOM_ADDITIVE(GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA, DefaultVertexFormats.field_181704_d, false, TextureMap.field_110575_b),
        TRACER(GlStateManager.DestFactor.ONE, DefaultVertexFormats.field_181706_f, false, null);

        final GlStateManager.DestFactor destFactor;
        final VertexFormat vertexFormat;
        final boolean renderThroughBlocks;
        final ResourceLocation textureRes;

        private DrawingStages(GlStateManager.DestFactor destFactor, @Nullable VertexFormat vertexFormat, boolean renderThroughBlocks, ResourceLocation textureRes) {
            this.destFactor = destFactor;
            this.vertexFormat = vertexFormat;
            this.renderThroughBlocks = renderThroughBlocks;
            this.textureRes = textureRes;
        }

        public void prepareRender(BufferBuilder buffer) {
            if (this.textureRes != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textureRes);
            } else {
                GlStateManager.func_179090_x();
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)this.destFactor);
            if (this.renderThroughBlocks) {
                GlStateManager.func_179097_i();
            }
            buffer.func_181668_a(7, this.vertexFormat);
        }

        public void clear() {
            if (this.renderThroughBlocks) {
                GlStateManager.func_179126_j();
            }
            if (this.textureRes == null) {
                GlStateManager.func_179098_w();
            }
        }
    }
}

