/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.client.animation.AMT;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationUtils;

public class IIModelHeader {
    private final HashMap<String, String> hierarchy;
    private final HashMap<String, Vec3d> offsets = new HashMap();

    public IIModelHeader(JsonObject json) {
        this.hierarchy = new HashMap();
        if (json.has("origins")) {
            JsonObject origins = json.getAsJsonObject("origins");
            for (Map.Entry entry : origins.entrySet()) {
                this.offsets.put((String)entry.getKey(), IIAnimationUtils.jsonToVec3d(((JsonElement)entry.getValue()).getAsJsonArray()).func_186678_a(0.0625));
            }
        }
        if (json.has("hierarchy")) {
            JsonObject hh = json.getAsJsonObject("hierarchy");
            for (Map.Entry entry : hh.entrySet()) {
                if (((JsonElement)entry.getValue()).getAsString().isEmpty()) continue;
                this.hierarchy.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
    }

    @Nonnull
    public Vec3d getOffset(String name) {
        return this.offsets.getOrDefault(name, Vec3d.field_186680_a);
    }

    public void applyHierarchy(Collection<AMT> amts) {
        for (AMT amt : amts) {
            AMT[] children = (AMT[])amts.stream().filter(child -> this.hierarchy.getOrDefault(child.name, "").equals(amt.name)).map(AMT::setChild).toArray(AMT[]::new);
            if (children.length <= 0) continue;
            amt.setChildren(children);
        }
    }
}

