/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.animation;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.client.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.animation.AMT;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.common.IIContent;

public class IIMachineUpgradeModel {
    private final MachineUpgrade upgrade;
    private final IIAnimationCompiledMap animation;
    private final IIAnimationCompiledMap alpha;
    private final AMT[] model;

    public IIMachineUpgradeModel(MachineUpgrade upgrade, ResourceLocation model, ResourceLocation animation) {
        this.upgrade = upgrade;
        this.model = IIAnimationUtils.getAMTFromRes(model, new ResourceLocation(model.func_110624_b(), model.func_110623_a().replace(".obj.ie", ".obj.amt")));
        IIAnimation anim = IIAnimationLoader.loadAnimation(animation);
        IIAnimation alpha = new IIAnimation(new ResourceLocation(""), (IIAnimation.IIAnimationGroup[])Arrays.stream(anim.groups).map(g -> new IIAnimation.IIAnimationGroup(g.groupName, null, null, null, null, null, this.vecToAlpha(g.position))).toArray(IIAnimation.IIAnimationGroup[]::new));
        this.animation = IIAnimationCompiledMap.create(this.model, anim);
        this.alpha = IIAnimationCompiledMap.create(this.model, alpha);
        upgrade.setRequiredSteps(this.model.length);
    }

    @Nullable
    private IIAnimation.IIFloatLine vecToAlpha(IIAnimation.IIVectorLine position) {
        if (position == null || ((Vec3d[])position.values).length < 2) {
            return null;
        }
        return new IIAnimation.IIFloatLine(new float[]{0.0f, position.timeframes[0], position.timeframes[position.timeframes.length - 1], 1.0f}, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)});
    }

    public boolean renderConstruction(IUpgradableMachine machine, Tessellator tes, BufferBuilder buf, float partialTicks) {
        if (machine.getCurrentlyInstalled() != this.upgrade) {
            return machine.hasUpgrade(this.upgrade);
        }
        int maxProgress = IIContent.UPGRADE_INSERTER.getProgressRequired();
        double maxClientProgress = Utils.getMaxClientProgress(machine.getInstallProgress(), maxProgress, this.model.length);
        double currentProgress = (int)Math.min((double)((float)machine.getClientInstallProgress() + partialTicks * ((float)Config.IIConfig.Tools.wrench_upgrade_progress * 0.5f)), maxClientProgress);
        float install = (float)MathHelper.func_151237_a((double)(currentProgress / (double)maxProgress), (double)0.0, (double)1.0);
        for (AMT mod : this.model) {
            mod.defaultize();
        }
        ShaderUtil.blueprint_static(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
        ShaderUtil.releaseShader();
        for (AMT mod : this.model) {
            mod.defaultize();
        }
        this.alpha.apply(install);
        this.animation.apply(install);
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
        return false;
    }

    public IIMachineUpgradeModel disposeOf() {
        IIAnimationUtils.disposeOf(this.model);
        return null;
    }

    public void defaultize() {
        for (AMT mod : this.model) {
            mod.defaultize();
        }
    }

    public void render(Tessellator tes, BufferBuilder buf) {
        for (AMT amt : this.model) {
            amt.render(tes, buf);
        }
    }

    @Nonnull
    public AMT getPart(String name) {
        return IIAnimationUtils.getPart(this.model, name);
    }
}

