/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.animation;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import blusunrize.immersiveengineering.client.models.obj.IEOBJModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.animation.IIModelHeader;

public class IIAnimationLoader {
    public static JsonObject readFileToJSON(@Nonnull ResourceLocation res) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(res);
            InputStream stream = resource.func_110527_b();
            JsonElement object = new JsonStreamParser((Reader)new InputStreamReader(stream)).next();
            return object.getAsJsonObject();
        }
        catch (Exception exception) {
            ImmersiveIntelligence.logger.error("[AMT] Couldn't load animation " + TextFormatting.GOLD + res.toString().replaceFirst("animations/", "").replaceFirst(".json", "") + TextFormatting.RESET + ", " + exception.getClass().getCanonicalName());
            return new JsonObject();
        }
    }

    public static IIAnimation loadAnimation(@Nonnull ResourceLocation res) {
        ResourceLocation fullRes = new ResourceLocation(res.func_110624_b(), "animations/" + res.func_110623_a() + ".json");
        return new IIAnimation(res, IIAnimationLoader.readFileToJSON(fullRes));
    }

    public static IIModelHeader loadHeader(@Nonnull IBakedModel model) {
        IEOBJModel ieobjModel = (IEOBJModel)((IESmartObjModel)model).getModel();
        ResourceLocation res = ieobjModel.getResourceLocation();
        ResourceLocation fullRes = new ResourceLocation(res.func_110624_b(), res.func_110623_a().replace(".obj.ie", ".obj.amt"));
        return IIAnimationLoader.loadHeader(fullRes);
    }

    public static IIModelHeader loadHeader(@Nonnull ResourceLocation res) {
        return new IIModelHeader(IIAnimationLoader.readFileToJSON(res));
    }

    public static void preloadTexturesFromMTL(@Nonnull ResourceLocation res) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(res);
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_110527_b()));
            reader.lines().filter(s -> s.startsWith("map_Kd")).map(s -> s.split(" ")[1]).forEach(s -> ApiUtils.getRegisterSprite((TextureMap)ClientUtils.mc().func_147117_R(), (String)(s + ".png")));
        }
        catch (IOException exception) {
            ImmersiveIntelligence.logger.error("[AMT] Couldn't load MTL file " + TextFormatting.GOLD + res.toString().replaceFirst("models/", "") + TextFormatting.RESET + ", " + exception.getClass().getCanonicalName());
        }
    }
}

