/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.animation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationUtils;

public class IIAnimation {
    public final ResourceLocation res;
    @Nonnull
    public final IIAnimationGroup[] groups;

    public IIAnimation(ResourceLocation res, @Nonnull IIAnimationGroup[] groups) {
        this.res = res;
        this.groups = groups;
    }

    public IIAnimation(ResourceLocation res, JsonObject json) {
        this.res = res;
        if (json.has("groups")) {
            JsonObject groups = json.getAsJsonObject("groups");
            this.groups = (IIAnimationGroup[])groups.entrySet().stream().map(e -> new IIAnimationGroup((String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonObject())).toArray(IIAnimationGroup[]::new);
        } else {
            this.groups = new IIAnimationGroup[0];
        }
    }

    public IIAnimationGroup getLeadingGroup() {
        return this.groups.length > 0 ? this.groups[0] : new IIAnimationGroup("missingno", new JsonObject());
    }

    public static class IIFloatLine
    extends IIAnimationLine<Float> {
        public IIFloatLine(float[] timeframes, Float[] values) {
            super(timeframes, values);
        }

        @Override
        public Float interpolate(Float t1, Float t2, float value) {
            return Float.valueOf((t1.floatValue() + t2.floatValue()) * 0.5f);
        }
    }

    public static class IIBooleanLine
    extends IIAnimationLine<Boolean> {
        public IIBooleanLine(float[] timeframes, Boolean[] values) {
            super(timeframes, values);
        }

        @Override
        public Boolean interpolate(Boolean t1, Boolean t2, float value) {
            return t1;
        }

        @Override
        public Boolean getForTime(float time) {
            for (int i = this.timeframes.length - 1; i >= 0; --i) {
                if (!(time >= this.timeframes[i])) continue;
                if (time == this.timeframes[i]) {
                    return ((Boolean[])this.values)[i];
                }
                if (i + 1 >= this.timeframes.length) continue;
                return ((Boolean[])this.values)[i];
            }
            return ((Boolean[])this.values)[0];
        }
    }

    public static class IIVectorLine
    extends IIAnimationLine<Vec3d> {
        public IIVectorLine(float[] timeframes, Vec3d[] values) {
            super(timeframes, values);
        }

        public IIVectorLine(float[] timeframes, Vec3d[] values, float scale) {
            this(timeframes, (Vec3d[])Arrays.stream(values).map(vec3d -> vec3d.func_186678_a((double)scale)).toArray(Vec3d[]::new));
        }

        @Override
        public Vec3d interpolate(Vec3d t1, Vec3d t2, float value) {
            return new Vec3d(MathHelper.func_151238_b((double)t1.field_72450_a, (double)t2.field_72450_a, (double)value), MathHelper.func_151238_b((double)t1.field_72448_b, (double)t2.field_72448_b, (double)value), MathHelper.func_151238_b((double)t1.field_72449_c, (double)t2.field_72449_c, (double)value));
        }
    }

    public static abstract class IIAnimationLine<T> {
        public final float[] timeframes;
        public final float[] durations;
        public final T[] values;

        public IIAnimationLine(float[] timeframes, T[] values) {
            this.timeframes = timeframes;
            if (timeframes.length == 1) {
                this.durations = new float[]{1.0f};
            } else {
                this.durations = new float[timeframes.length];
                for (int i = 0; i < timeframes.length - 1; ++i) {
                    this.durations[i] = timeframes[i + 1] - timeframes[i];
                }
                this.durations[this.durations.length - 1] = 1.0f;
            }
            this.values = values;
        }

        public abstract T interpolate(T var1, T var2, float var3);

        public T getForTime(float time) {
            for (int i = this.timeframes.length - 1; i >= 0; --i) {
                if (!(time >= this.timeframes[i])) continue;
                if (time == this.timeframes[i]) {
                    return this.values[i];
                }
                if (i + 1 >= this.timeframes.length) continue;
                return this.interpolate(this.values[i], this.values[i + 1], (time - this.timeframes[i]) / this.durations[i]);
            }
            return this.values[0];
        }
    }

    public static class IIAnimationGroup {
        final String groupName;
        @Nullable
        final IIVectorLine position;
        @Nullable
        final IIVectorLine scale;
        @Nullable
        final IIVectorLine rotation;
        @Nullable
        final IIBooleanLine visibility;
        @Nullable
        final IIFloatLine alpha;

        public IIAnimationGroup(String groupName, @Nullable IIVectorLine position, @Nullable IIVectorLine scale, @Nullable IIVectorLine color, @Nullable IIVectorLine rotation, @Nullable IIBooleanLine visibility, @Nullable IIFloatLine alpha) {
            this.groupName = groupName;
            this.position = position;
            this.scale = scale;
            this.rotation = rotation;
            this.visibility = visibility;
            this.alpha = alpha;
        }

        public IIAnimationGroup(String groupName, JsonObject json) {
            this.groupName = groupName;
            this.position = json.has("position") ? this.loadPositionLine(this.loadLine(json, "position")) : null;
            this.scale = json.has("scale") ? this.loadVectorLine(this.loadLine(json, "scale")) : null;
            this.rotation = json.has("rotation") ? this.loadVectorLine(this.loadLine(json, "rotation")) : null;
            this.alpha = json.has("alpha") ? this.loadFloatLine(json, "alpha") : null;
            this.visibility = json.has("visibility") ? this.loadBooleanLine(json, "visibility") : null;
        }

        private Tuple<ArrayList<Float>, ArrayList<Vec3d>> loadLine(JsonObject json, String id) {
            JsonArray array = json.getAsJsonArray(id);
            ArrayList<Float> timeframes = new ArrayList<Float>();
            ArrayList<Vec3d> vectors = new ArrayList<Vec3d>();
            if (array != null) {
                for (JsonElement jsonElement : array) {
                    JsonObject obj = jsonElement.getAsJsonObject();
                    timeframes.add(Float.valueOf(obj.get("time").getAsFloat()));
                    vectors.add(IIAnimationUtils.jsonToVec3d(obj.get("transform").getAsJsonArray()));
                }
            }
            return new Tuple(timeframes, vectors);
        }

        private IIVectorLine loadPositionLine(Tuple<ArrayList<Float>, ArrayList<Vec3d>> tuple) {
            float[] arr = new float[((ArrayList)tuple.func_76341_a()).size()];
            for (int i = 0; i < ((ArrayList)tuple.func_76341_a()).size(); ++i) {
                arr[i] = ((Float)((ArrayList)tuple.func_76341_a()).get(i)).floatValue();
            }
            return new IIVectorLine(arr, ((ArrayList)tuple.func_76340_b()).toArray(new Vec3d[0]), 0.0625f);
        }

        private IIVectorLine loadVectorLine(Tuple<ArrayList<Float>, ArrayList<Vec3d>> tuple) {
            float[] arr = new float[((ArrayList)tuple.func_76341_a()).size()];
            for (int i = 0; i < ((ArrayList)tuple.func_76341_a()).size(); ++i) {
                arr[i] = ((Float)((ArrayList)tuple.func_76341_a()).get(i)).floatValue();
            }
            return new IIVectorLine(arr, ((ArrayList)tuple.func_76340_b()).toArray(new Vec3d[0]));
        }

        private IIFloatLine loadFloatLine(JsonObject json, String id) {
            JsonArray array = json.getAsJsonArray(id);
            ArrayList<Float> timeframes = new ArrayList<Float>();
            ArrayList<Float> values = new ArrayList<Float>();
            if (array != null) {
                for (JsonElement jsonElement : array) {
                    JsonObject obj = jsonElement.getAsJsonObject();
                    timeframes.add(Float.valueOf(obj.get("time").getAsFloat()));
                    values.add(Float.valueOf(obj.get(id).getAsFloat()));
                }
            }
            float[] arr = new float[timeframes.size()];
            for (int i = 0; i < timeframes.size(); ++i) {
                arr[i] = ((Float)timeframes.get(i)).floatValue();
            }
            return new IIFloatLine(arr, values.toArray(new Float[0]));
        }

        private IIBooleanLine loadBooleanLine(JsonObject json, String id) {
            JsonArray array = json.getAsJsonArray(id);
            ArrayList<Float> timeframes = new ArrayList<Float>();
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            if (array != null) {
                for (JsonElement jsonElement : array) {
                    JsonObject obj = jsonElement.getAsJsonObject();
                    timeframes.add(Float.valueOf(obj.get("time").getAsFloat()));
                    values.add(obj.get(id).getAsBoolean());
                }
            }
            float[] arr = new float[timeframes.size()];
            for (int i = 0; i < timeframes.size(); ++i) {
                arr[i] = ((Float)timeframes.get(i)).floatValue();
            }
            return new IIBooleanLine(arr, values.toArray(new Boolean[0]));
        }
    }
}

