/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.animation;

import blusunrize.immersiveengineering.client.ClientUtils;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.client.animation.AMT;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;

public class AMTBullet
extends AMT {
    @Nullable
    private IBulletModel model;
    private BulletState state = BulletState.BULLET_UNUSED;
    BulletRegistry.EnumCoreTypes coreType = null;
    float gunpowderPercentage = 0.0f;
    int coreColour = 0xFFFFFF;
    int paintColour = -1;

    public AMTBullet(String name, Vec3d originPos, @Nullable IBulletModel model) {
        super(name, originPos);
        this.model = model;
    }

    @Override
    protected void preDraw() {
        GlStateManager.func_179137_b((double)this.originPos.field_72450_a, (double)this.originPos.field_72448_b, (double)this.originPos.field_72449_c);
        if (this.off != null) {
            GlStateManager.func_179137_b((double)(-this.off.field_72450_a), (double)this.off.field_72448_b, (double)this.off.field_72449_c);
        }
        if (this.rot != null) {
            GlStateManager.func_179114_b((float)((float)this.rot.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)this.rot.field_72449_c), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)((float)(-this.rot.field_72450_a)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    @Override
    protected void draw(Tessellator tes, BufferBuilder buf) {
        if (this.model != null) {
            switch (this.state) {
                case CASING: {
                    this.model.renderCasing(this.gunpowderPercentage, this.paintColour);
                    break;
                }
                case CORE: {
                    if (this.coreType == null) break;
                    this.model.renderCore(this.coreColour, this.coreType);
                    break;
                }
                case BULLET_USED: {
                    if (this.coreType == null) break;
                    this.model.renderBulletUsed(this.coreColour, this.coreType, this.paintColour);
                    break;
                }
                case BULLET_UNUSED: {
                    if (this.coreType == null) break;
                    this.model.renderBulletUnused(this.coreColour, this.coreType, this.paintColour);
                }
            }
            ClientUtils.bindAtlas();
        }
    }

    @Override
    public void disposeOf() {
    }

    public void setModel(@Nullable IBulletModel model) {
        this.model = model;
    }

    public AMTBullet withStack(ItemStack stack, BulletState state) {
        this.state = state;
        if (stack.func_77973_b() instanceof IBullet) {
            IBullet b = (IBullet)stack.func_77973_b();
            return this.withProperties(b.getCore(stack).getColour(), b.getCoreType(stack), b.getPaintColor(stack));
        }
        if (stack.func_190926_b()) {
            this.visible = false;
        }
        return this;
    }

    public AMTBullet withProperties(int coreColour, BulletRegistry.EnumCoreTypes coreType, int paintColour) {
        this.coreColour = coreColour;
        this.coreType = coreType;
        this.paintColour = paintColour;
        return this;
    }

    public AMTBullet withState(BulletState state) {
        this.state = state;
        return this;
    }

    public AMTBullet withGunpowderPercentage(float gunpowderPercentage) {
        this.state = BulletState.CASING;
        this.gunpowderPercentage = gunpowderPercentage;
        return this;
    }

    public BulletState getState() {
        return this.state;
    }

    public static enum BulletState {
        CASING,
        CORE,
        BULLET_USED,
        BULLET_UNUSED;

    }
}

