/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.animation;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.vector.Vector3f;
import pl.pabilo8.immersiveintelligence.client.ShaderUtil;

public abstract class AMT {
    public final String name;
    protected final Vec3d originPos;
    private AMT[] children;
    private boolean isChild = false;
    protected boolean visible;
    protected Vec3d off;
    protected Vec3d scale;
    protected Vector3f color;
    protected Vec3d rot;
    protected float alpha;

    public AMT(String name, Vec3d originPos) {
        this.name = name;
        this.originPos = originPos;
        this.defaultize();
    }

    public final void render(Tessellator tes, BufferBuilder buf) {
        if (!this.visible || this.alpha == 0.0f) {
            return;
        }
        GlStateManager.func_179094_E();
        this.preDraw();
        if (this.alpha != 1.0f) {
            ShaderUtil.alpha_static(this.alpha);
        }
        this.draw(tes, buf);
        if (this.children != null) {
            for (AMT child : this.children) {
                child.render(tes, buf);
            }
        }
        if (this.alpha != 1.0f) {
            ShaderUtil.releaseShader();
        }
        GlStateManager.func_179121_F();
    }

    protected void preDraw() {
        if (this.off != null) {
            GlStateManager.func_179137_b((double)(-this.off.field_72450_a), (double)this.off.field_72448_b, (double)this.off.field_72449_c);
        }
        GlStateManager.func_179137_b((double)this.originPos.field_72450_a, (double)this.originPos.field_72448_b, (double)this.originPos.field_72449_c);
        if (this.rot != null) {
            GlStateManager.func_179114_b((float)((float)this.rot.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)this.rot.field_72449_c), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)((float)(-this.rot.field_72450_a)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)(-this.originPos.field_72450_a), (double)(-this.originPos.field_72448_b), (double)(-this.originPos.field_72449_c));
        if (this.scale != null) {
            GlStateManager.func_179139_a((double)this.scale.field_72450_a, (double)this.scale.field_72448_b, (double)this.scale.field_72449_c);
        }
    }

    protected abstract void draw(Tessellator var1, BufferBuilder var2);

    public void defaultize() {
        this.visible = true;
        this.rot = null;
        this.scale = null;
        this.off = null;
        this.color = null;
        this.alpha = 1.0f;
    }

    public abstract void disposeOf();

    final void setChildren(AMT[] children) {
        this.children = children;
    }

    public final ArrayList<AMT> getChildrenRecursive() {
        return this.getChildrenRecursive(new ArrayList<AMT>());
    }

    private ArrayList<AMT> getChildrenRecursive(@Nonnull ArrayList<AMT> list) {
        list.add(this);
        if (this.children != null) {
            for (AMT child : this.children) {
                child.getChildrenRecursive(list);
            }
        }
        return list;
    }

    final AMT setChild() {
        this.isChild = true;
        return this;
    }

    final boolean isChild() {
        return this.isChild;
    }
}

