/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.utils.vehicles;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;

public interface IUpgradableMachine {
    public boolean addUpgrade(MachineUpgrade var1, boolean var2);

    public boolean hasUpgrade(MachineUpgrade var1);

    public boolean upgradeMatches(MachineUpgrade var1);

    public <T extends TileEntity> T getUpgradeMaster();

    public void saveUpgradesToNBT(NBTTagCompound var1);

    public void getUpgradesFromNBT(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public void renderWithUpgrades(MachineUpgrade ... var1);

    public List<MachineUpgrade> getUpgrades();

    @Nullable
    public MachineUpgrade getCurrentlyInstalled();

    public int getInstallProgress();

    @SideOnly(value=Side.CLIENT)
    public int getClientInstallProgress();

    public boolean addUpgradeInstallProgress(int var1);

    public boolean resetInstallProgress();

    public void startUpgrade(@Nonnull MachineUpgrade var1);

    public void removeUpgrade(MachineUpgrade var1);

    default public float getMaxClientProgress() {
        if (this.getCurrentlyInstalled() != null) {
            return Utils.getMaxClientProgress(this.getInstallProgress(), this.getCurrentlyInstalled().getProgressRequired(), this.getCurrentlyInstalled().getSteps());
        }
        return this.getInstallProgress();
    }
}

