/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.rotary;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import pl.pabilo8.immersiveintelligence.api.rotary.IModelMotorBelt;
import pl.pabilo8.immersiveintelligence.api.rotary.MotorBeltType;
import pl.pabilo8.immersiveintelligence.client.render.MechanicalConnectorRenderer;
import pl.pabilo8.immersiveintelligence.common.blocks.rotary.TileEntityMechanicalConnectable;

public class MotorBeltData {
    public final IModelMotorBelt model;
    public final Vec3d[] origins;
    public final float[] pitch;
    public final float[] yaw;
    public final float[] lengths;
    public final float[] radii;
    public final int[] sidePoints;
    public final int beltThickness;
    public final int beltWidth;
    public final ResourceLocation texture;

    public MotorBeltData(IModelMotorBelt model, Vec3d[] origins, float[] pitch, float[] yaw, float[] lengths, float[] radii, int[] sidePoints, ResourceLocation texture, int beltThickness, int beltWidth) {
        this.model = model;
        this.origins = origins;
        this.pitch = pitch;
        this.yaw = yaw;
        this.lengths = lengths;
        this.radii = radii;
        this.sidePoints = sidePoints;
        this.texture = texture;
        this.beltThickness = beltThickness;
        this.beltWidth = beltWidth;
    }

    @Nullable
    public static MotorBeltData createBeltData(Vec3d[] points, float[] radii, MotorBeltType belt) {
        if (points.length < 2) {
            return null;
        }
        int beltThickness = belt.getThickness();
        float[] angles = new float[points.length];
        float[] lengths = new float[points.length];
        float[] yaws = new float[points.length];
        int[] sidePoints = new int[points.length];
        for (int i = 0; i < points.length; ++i) {
            sidePoints[i] = (int)Math.ceil(Math.PI * 2 / (double)points.length * (double)radii[i] / (double)belt.getWidth());
            lengths[i] = (float)points[i].func_72438_d(points[(i + 1) % points.length]) * 16.0f;
            Vec3d vv = points[i].func_178788_d(points[(i + 1) % points.length]).func_72432_b();
            yaws[i] = (float)MathHelper.func_76138_g((double)(Math.atan2(vv.field_72450_a, vv.field_72449_c) * 180.0 / 3.1415927410125732));
            angles[i] = (float)MathHelper.func_76138_g((double)Math.toDegrees(Math.atan2(vv.field_72448_b, vv.func_72438_d(new Vec3d(0.0, vv.field_72448_b, 0.0)))));
        }
        return new MotorBeltData(belt.getModel(), points, angles, yaws, lengths, radii, sidePoints, new ResourceLocation(belt.getTexture() + ".png"), beltThickness, belt.getWidth());
    }

    @Nullable
    public static MotorBeltData createBeltData(ImmersiveNetHandler.Connection connection, TileEntityMechanicalConnectable start, TileEntityMechanicalConnectable end) {
        if (!(connection.cableType instanceof MotorBeltType) || start == null || end == null) {
            return null;
        }
        Vec3d v1 = Vec3d.field_186680_a;
        Vec3d v2 = new Vec3d((Vec3i)end.getConnectionPos()).func_178787_e(end.getConnectionOffset(connection)).func_178788_d(new Vec3d((Vec3i)start.getConnectionPos()).func_178787_e(start.getConnectionOffset(connection)));
        MotorBeltData data = MotorBeltData.createBeltData(new Vec3d[]{v1, v2}, new float[]{start.getRadius(), end.getRadius()}, (MotorBeltType)connection.cableType);
        MechanicalConnectorRenderer.cache.put(connection, data);
        MechanicalConnectorRenderer.cache.put(ImmersiveNetHandler.INSTANCE.getReverseConnection(start.func_145831_w().field_73011_w.getDimension(), connection), null);
        return data;
    }
}

