/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataTypeVector
implements IDataType {
    public float x;
    public float y;
    public float z;
    public boolean integerVector;

    public DataTypeVector(float x, float y, float z) {
        this.integerVector = false;
    }

    public DataTypeVector(int x, int y, int z) {
        this.integerVector = true;
    }

    public DataTypeVector() {
    }

    @Override
    @Nonnull
    public String getName() {
        return "vector";
    }

    @Override
    @Nonnull
    public String[][] getTypeInfoTable() {
        return new String[][]{{"ie.manual.entry.def_value", "[0.0, 0.0, 0.0]"}, {"ie.manual.entry.min_value", String.valueOf(Float.MIN_VALUE)}, {"ie.manual.entry.max_value", String.valueOf(Float.MAX_VALUE)}};
    }

    @Override
    @Nonnull
    public String valueToString() {
        return String.format("[%s,%s,%s]", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    @Override
    public void setDefaultValue() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    @Override
    public void valueFromNBT(NBTTagCompound n) {
        this.x = n.func_74760_g("X");
        this.y = n.func_74760_g("Y");
        this.z = n.func_74760_g("Z");
        this.integerVector = n.func_74767_n("IntegerVector");
    }

    @Override
    @Nonnull
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        nbt.func_74776_a("X", this.x);
        nbt.func_74776_a("Y", this.x);
        nbt.func_74776_a("Z", this.x);
        nbt.func_74757_a("IntegerVector", this.integerVector);
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 10324224;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataTypeVector)) {
            return false;
        }
        DataTypeVector other = (DataTypeVector)obj;
        return other.x == this.x && other.y == this.y && other.z == this.z;
    }
}

