/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataTypeEntity
implements IDataType {
    public int entityID = 0;
    public int dimensionID = 0;
    public String entityClass = "";
    public String customName = "";
    public Vec3d lastPos = Vec3d.field_186680_a;

    public DataTypeEntity(Entity entity) {
        this(entity, BlockPos.field_177992_a);
    }

    public DataTypeEntity(Entity entity, BlockPos seenFrom) {
        this.entityID = entity.func_145782_y();
        this.dimensionID = entity.field_71093_bK;
        this.customName = entity.func_95999_t();
        EntityEntry entry = EntityRegistry.getEntry(entity.getClass());
        if (entry != null) {
            this.entityClass = Optional.ofNullable(entry.getRegistryName()).orElse(new ResourceLocation("unknown")).toString();
        }
        this.lastPos = entity.func_174791_d().func_178786_a((double)seenFrom.func_177958_n(), (double)seenFrom.func_177956_o(), (double)seenFrom.func_177952_p());
    }

    public DataTypeEntity() {
    }

    @Override
    @Nonnull
    public String getName() {
        return "entity";
    }

    @Override
    @Nonnull
    public String[][] getTypeInfoTable() {
        return new String[][]{{"ie.manual.entry.def_value", "ie.manual.entry.empty"}};
    }

    @Override
    @Nonnull
    public String valueToString() {
        return this.actualValueToNBT(new NBTTagCompound()).toString();
    }

    @Override
    public void setDefaultValue() {
        this.entityID = 0;
        this.dimensionID = 0;
        this.entityClass = "";
        this.customName = "";
        this.lastPos = Vec3d.field_186680_a;
    }

    @Override
    public void valueFromNBT(NBTTagCompound n) {
        this.entityID = n.func_74762_e("entityID");
        this.dimensionID = n.func_74762_e("dimensionID");
        this.entityClass = n.func_74779_i("entityClass");
        this.customName = n.func_74779_i("customName");
        this.lastPos = new Vec3d(n.func_74769_h("last_x"), n.func_74769_h("last_y"), n.func_74769_h("last_z"));
    }

    @Override
    @Nonnull
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        this.actualValueToNBT(nbt);
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 4415046;
    }

    public NBTTagCompound actualValueToNBT(NBTTagCompound nbt) {
        if (this.entityID != 0) {
            nbt.func_74768_a("entityID", this.entityID);
        }
        if (this.dimensionID != 0) {
            nbt.func_74768_a("dimensionID", this.dimensionID);
        }
        if (!this.entityClass.isEmpty()) {
            nbt.func_74778_a("entityClass", this.entityClass);
        }
        if (!this.customName.isEmpty()) {
            nbt.func_74778_a("customName", this.customName);
        }
        if (this.lastPos != Vec3d.field_186680_a) {
            nbt.func_74780_a("last_x", this.lastPos.field_72450_a);
            nbt.func_74780_a("last_y", this.lastPos.field_72448_b);
            nbt.func_74780_a("last_z", this.lastPos.field_72449_c);
        }
        return nbt;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataTypeEntity)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DataTypeEntity casted = (DataTypeEntity)obj;
        return casted.entityID == this.entityID && casted.dimensionID == this.dimensionID;
    }
}

