/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeIterable;

public class DataTypeArray
implements IDataTypeIterable {
    public IDataType[] value;

    public DataTypeArray(IDataType ... i) {
        this.value = new IDataType[Math.min(i.length, 255)];
        System.arraycopy(i, 0, this.value, 0, 255);
    }

    public DataTypeArray() {
    }

    @Override
    @Nonnull
    public String getName() {
        return "array";
    }

    @Override
    @Nonnull
    public String[][] getTypeInfoTable() {
        return new String[][]{{"ie.manual.entry.def_value", "ie.manual.entry.empty"}, {"ie.manual.entry.min_index", "0"}, {"ie.manual.entry.max_index", "255"}};
    }

    @Override
    @Nonnull
    public String valueToString() {
        if (this.value == null || this.value.length == 0) {
            return "[]";
        }
        StringBuilder s = new StringBuilder("[");
        for (IDataType type : this.value) {
            s.append(type.valueToString()).append(", ");
        }
        return s.delete(s.length() - 2, s.length() - 1).append("]").toString();
    }

    @Override
    public void setDefaultValue() {
        this.value = new IDataType[0];
    }

    @Override
    public void valueFromNBT(NBTTagCompound n) {
        NBTTagList l = n.func_150295_c("Values", 10);
        ArrayList<IDataType> dataTypes = new ArrayList<IDataType>();
        for (NBTBase b : l) {
            NBTTagCompound c;
            if (!(b instanceof NBTTagCompound) || !(c = (NBTTagCompound)b).func_74764_b("Type")) continue;
            dataTypes.add(DataPacket.getVarFromNBT(c));
        }
        this.value = dataTypes.toArray(new IDataType[0]);
    }

    @Override
    @Nonnull
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        NBTTagList list = new NBTTagList();
        for (IDataType type : this.value) {
            list.func_74742_a((NBTBase)type.valueToNBT());
        }
        nbt.func_74782_a("Values", (NBTBase)list);
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 5377067;
    }
}

