/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.pol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;
import pl.pabilo8.immersiveintelligence.api.data.DataOperations;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLComputerMemory;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLKeywords;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLProcess;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLTerminal;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionCopy;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionEnd;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionExec;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionGoto;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionGroup;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionIf;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionMove;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionPage;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionSet;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionSwap;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionType;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionWait;
import pl.pabilo8.immersiveintelligence.api.data.pol.instructions.POLInstructionWipe;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeAccessor;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeFloat;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIFunctionalCircuit;

public class POLScript {
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    private final HashMap<String, Tuple<Integer, Integer>> markers;
    private final POLInstruction[] instructions;

    private POLScript(HashMap<String, Tuple<Integer, Integer>> markers, POLInstruction[] instructions) {
        this.markers = markers;
        this.instructions = instructions;
    }

    public static POLScript prepareScript(ArrayList<String> lines) {
        ArrayList<Tuple<POLKeywords, String>> text = POLScript.processText(lines);
        return POLScript.compile(text);
    }

    protected static ArrayList<Tuple<POLKeywords, String>> processText(ArrayList<String> text) {
        text = (ArrayList)text.stream().map(s -> SPECIAL_REGEX_CHARS.matcher((CharSequence)s).replaceAll("\\\\$0")).map(s -> s.replaceAll(";(?<=;).*$", "")).map(s -> s.replaceAll("\\\\", "")).map(s -> s.replaceAll("\\s+$", "")).map(s -> s.replaceAll(" {4}", "\t")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        int level = 0;
        ArrayList<Tuple<POLKeywords, String>> output = new ArrayList<Tuple<POLKeywords, String>>();
        for (String next : text) {
            int j;
            int indents = POLScript.countChars(next, '\t');
            next = next.replaceAll("\t", "");
            for (j = level - indents; j > 0; --j) {
                output.add((Tuple<POLKeywords, String>)new Tuple((Object)POLKeywords.END, (Object)""));
            }
            for (j = indents - level; j > 0; --j) {
                output.add((Tuple<POLKeywords, String>)new Tuple((Object)POLKeywords.BEGIN, (Object)""));
            }
            level = indents;
            String element = next.split(" ")[0];
            POLKeywords keyword = POLKeywords.v(element);
            if (element.length() == 0) {
                output.add((Tuple<POLKeywords, String>)new Tuple((Object)POLKeywords.SET, (Object)("generic " + next)));
                continue;
            }
            if (DataPacket.varTypes.containsKey(element)) {
                output.add((Tuple<POLKeywords, String>)new Tuple((Object)POLKeywords.SET, (Object)next));
                continue;
            }
            if (keyword == null) continue;
            output.add((Tuple<POLKeywords, String>)new Tuple((Object)keyword, (Object)(next.split(" ").length > 1 ? next.split(" ", 2)[1] : "")));
        }
        for (int i = 0; i < level; ++i) {
            output.add((Tuple<POLKeywords, String>)new Tuple((Object)POLKeywords.END, (Object)""));
        }
        return output;
    }

    protected static POLScript compile(ArrayList<Tuple<POLKeywords, String>> script) {
        ArrayList<DataOperation> operations = new ArrayList<DataOperation>();
        HashMap<String, Tuple<Integer, Integer>> markers = new HashMap<String, Tuple<Integer, Integer>>();
        ArrayList<POLInstruction> mainSet = new ArrayList<POLInstruction>();
        ArrayList<ArrayList<POLInstruction>> subSets = new ArrayList<ArrayList<POLInstruction>>();
        for (Tuple<POLKeywords, String> tuple : script) {
            POLKeywords keyword = (POLKeywords)((Object)tuple.func_76341_a());
            String rest = (String)tuple.func_76340_b();
            POLInstruction in = null;
            switch (keyword) {
                case USE: {
                    ItemIIFunctionalCircuit.Circuit circuit = Arrays.stream(ItemIIFunctionalCircuit.Circuit.values()).filter(e -> e.func_176610_l().equals(rest.toLowerCase())).findFirst().orElse(ItemIIFunctionalCircuit.Circuit.ARITHMETIC);
                    for (String function : circuit.getFunctions()) {
                        operations.add(DataOperations.getOperationInstance(function));
                    }
                    break;
                }
                case MARK: {
                    markers.put(rest, (Tuple<Integer, Integer>)new Tuple((Object)mainSet.size(), (Object)(subSets.stream().map(ArrayList::size).mapToInt(Integer::intValue).sum() - 1)));
                    break;
                }
                case BEGIN: {
                    subSets.add(new ArrayList());
                    break;
                }
                case GOTO: {
                    in = new POLInstructionGoto(POLScript.beginParseExpression(operations, rest));
                    break;
                }
                case EXEC: {
                    in = new POLInstructionExec(POLScript.beginParseExpression(operations, rest));
                    break;
                }
                case IF: {
                    in = new POLInstructionIf(POLScript.beginParseExpression(operations, rest));
                    break;
                }
                case WAIT: {
                    in = new POLInstructionWait(POLScript.beginParseExpression(operations, rest));
                    break;
                }
                case END: {
                    if (POLScript.finishInstructionGroup(subSets, mainSet)) break;
                    in = new POLInstructionEnd();
                    break;
                }
                case TYPE: {
                    in = new POLInstructionType(POLScript.beginParseExpression(operations, rest));
                    break;
                }
                case SWAP: {
                    String[] words = rest.split(" ", 4);
                    in = new POLInstructionSwap(words[0].charAt(0), words.length > 1 ? words[1].charAt(0) : words[0].charAt(0), words.length > 2 ? POLScript.beginParseExpression(operations, words[2]) : null);
                    break;
                }
                case MOVE: {
                    String[] words = rest.split(" ", 4);
                    in = new POLInstructionMove(words[0].charAt(0), words.length > 1 ? words[1].charAt(0) : words[0].charAt(0), words.length > 2 ? POLScript.beginParseExpression(operations, words[2]) : null);
                    break;
                }
                case COPY: {
                    String[] words = rest.split(" ", 4);
                    in = new POLInstructionCopy(words[0].charAt(0), words.length > 1 ? words[1].charAt(0) : words[0].charAt(0), words.length > 2 ? POLScript.beginParseExpression(operations, words[2]) : null);
                    break;
                }
                case SET: {
                    String[] words = rest.split(" ", 4);
                    Class<IDataType> type = DataPacket.varTypes.getOrDefault(words[0], IDataType.class);
                    char letter = words[1].charAt(0);
                    in = new POLInstructionSet(letter, POLScript.beginParseExpression(operations, words[3]), type);
                    break;
                }
                case PAGE: {
                    in = new POLInstructionPage(POLScript.beginParseExpression(operations, rest));
                    break;
                }
                case WIPE: {
                    in = new POLInstructionWipe(POLScript.beginParseExpression(operations, rest));
                }
            }
            if (in == null) continue;
            POLScript.addInstruction(subSets, mainSet, in);
        }
        return new POLScript(markers, mainSet.toArray(new POLInstruction[0]));
    }

    private static boolean finishInstructionGroup(ArrayList<ArrayList<POLInstruction>> subSets, ArrayList<POLInstruction> mainSet) {
        ArrayList<POLInstruction> group = null;
        if (subSets.size() > 0) {
            group = subSets.get(subSets.size() - 1);
        }
        if (group != null) {
            if (subSets.size() - 2 < 0) {
                mainSet.add(new POLInstructionGroup(group));
            } else {
                subSets.get(subSets.size() - 2).add(new POLInstructionGroup(group));
            }
            subSets.remove(subSets.size() - 1);
            return true;
        }
        return false;
    }

    private static void addInstruction(ArrayList<ArrayList<POLInstruction>> subSets, ArrayList<POLInstruction> mainSet, POLInstruction instruction) {
        ArrayList<POLInstruction> group = null;
        if (subSets.size() > 0) {
            group = subSets.get(subSets.size() - 1);
        }
        if (group != null) {
            group.add(instruction);
        } else {
            mainSet.add(instruction);
        }
    }

    private static IDataType beginParseExpression(ArrayList<DataOperation> operations, String text) {
        if (POLScript.countChars(text, '(') != POLScript.countChars(text, ')')) {
            return new DataTypeNull();
        }
        if ((POLScript.countChars(text, '\'') + POLScript.countChars(text, '\"')) % 2 != 0) {
            return new DataTypeNull();
        }
        return POLScript.parseExpression(operations, text);
    }

    private static IDataType parseExpression(ArrayList<DataOperation> operations, String text) {
        if (text.length() == 0) {
            return new DataTypeNull();
        }
        if (text.startsWith("(")) {
            return POLScript.parseExpression(operations, text.substring(1, Math.max(text.length() - 2, 1)));
        }
        DataOperation op = null;
        ArrayList<Object> arguments = new ArrayList<Object>();
        String keyword = text.split(" ")[0];
        for (DataOperation operation : operations) {
            if (!operation.name.equals(keyword)) continue;
            op = operation;
            break;
        }
        if (op == null) {
            for (DataOperation operation : operations) {
                if (operation.expression == null || !operation.expression.equals(keyword)) continue;
                op = operation;
                keyword = SPECIAL_REGEX_CHARS.matcher(keyword).replaceAll("\\\\$0");
                break;
            }
        }
        if (op != null) {
            String remaining = text.replaceFirst(keyword, "").trim();
            while (remaining.length() > 0) {
                Tuple tuple;
                if (remaining.startsWith("(")) {
                    String exp = POLScript.findFullBracket(remaining);
                    tuple = new Tuple((Object)POLScript.parseExpression(operations, exp), (Object)remaining.replaceFirst("\\(", "").replaceFirst(SPECIAL_REGEX_CHARS.matcher(exp).replaceAll("\\\\$0"), "").replaceFirst("\\)", ""));
                } else {
                    tuple = POLScript.parseValue(remaining);
                }
                arguments.add(tuple.func_76341_a());
                remaining = ((String)tuple.func_76340_b()).trim();
            }
            return new DataTypeExpression(arguments.toArray(new IDataType[0]), op, ' ');
        }
        return (IDataType)POLScript.parseValue(text).func_76341_a();
    }

    private static String findFullBracket(String remaining) {
        int c;
        int opening = 1;
        int closing = 0;
        int l = remaining.length();
        block4: for (c = 1; opening != closing && c < l; ++c) {
            switch (remaining.charAt(c)) {
                case '(': {
                    ++opening;
                    continue block4;
                }
                case ')': {
                    ++closing;
                    continue block4;
                }
            }
        }
        return remaining.substring(1, c - 1);
    }

    private static Tuple<IDataType, String> parseValue(String text) {
        IDataType data;
        if (text.charAt(0) == '\"') {
            data = new DataTypeString(text.substring(1, text.indexOf(34, 1)));
            text = text.replaceFirst("\".+\"", "");
        } else if (text.charAt(0) == '\'') {
            data = new DataTypeString(text.substring(1, text.indexOf(39, 1)));
            text = text.replaceFirst("'.+'", "");
        } else if (text.charAt(0) == '@') {
            data = new DataTypeAccessor(text.charAt(1));
            text = text.replaceFirst("@.", "");
        } else if (Character.isDigit(text.charAt(0))) {
            String num = text.split(" ")[0];
            try {
                data = POLScript.countChars(num, '.') > 0 ? new DataTypeFloat(Float.parseFloat(num)) : new DataTypeInteger(Integer.parseInt(num));
            }
            catch (Exception i) {
                try {
                    data = new DataTypeInteger(Integer.parseInt(num));
                }
                catch (Exception i2) {
                    data = new DataTypeInteger(0);
                }
            }
            text = text.replaceFirst(num, "");
        } else {
            if (text.split(" ")[0].equals("true")) {
                return new Tuple((Object)new DataTypeBoolean(true), (Object)text.replaceFirst("true", ""));
            }
            if (text.split(" ")[0].equals("false")) {
                return new Tuple((Object)new DataTypeBoolean(false), (Object)text.replaceFirst("false", ""));
            }
            if (text.split(" ")[0].equals("null")) {
                return new Tuple((Object)new DataTypeNull(), (Object)text.replaceFirst("null", ""));
            }
            data = new DataTypeNull();
            text = "";
        }
        return new Tuple((Object)data, (Object)text);
    }

    private static int countChars(String s, char c) {
        return (int)s.chars().filter(v -> v == c).count();
    }

    public POLInstruction[] getInstructions() {
        return this.instructions;
    }

    public HashMap<String, Tuple<Integer, Integer>> getMarkers() {
        return this.markers;
    }

    public static abstract class POLInstruction {
        private final int executionTime;

        public POLInstruction(int executionTime) {
            this.executionTime = executionTime;
        }

        public abstract void execute(POLComputerMemory var1, POLTerminal var2, POLProcess var3, int var4);

        public abstract POLKeywords getKeyword();

        public int getExecutionTime() {
            return this.executionTime;
        }
    }

    public static class DataTypeWrapper {
        final IDataType wrapped;

        public DataTypeWrapper(IDataType wrapped) {
            this.wrapped = wrapped;
        }

        public IDataType get(DataPacket packet) {
            if (this.wrapped instanceof DataTypeExpression) {
                return ((DataTypeExpression)this.wrapped).getValue(packet);
            }
            if (this.wrapped instanceof DataTypeAccessor) {
                return ((DataTypeAccessor)this.wrapped).getRealValue(packet);
            }
            return packet.getVarInType(IDataType.class, this.wrapped);
        }

        public String getString(DataPacket packet) {
            return this.get(packet).valueToString();
        }
    }
}

