/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.pol;

import java.util.Stack;
import net.minecraft.util.Tuple;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLComputerMemory;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLScript;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLTerminal;

public class POLProcess {
    private final POLScript script;
    private boolean running = true;
    private int lineID = 0;
    private int time = 0;
    private final Stack<Tuple<Integer, Integer>> returnStack = new Stack();

    public POLProcess(POLScript script) {
        this.script = script;
    }

    public void run(POLComputerMemory memory, POLTerminal terminal) {
        POLScript.POLInstruction instruction = this.script.getInstructions()[this.lineID];
        instruction.execute(memory, terminal, this, this.time);
        ++this.time;
        if (instruction.getExecutionTime() <= this.time) {
            ++this.lineID;
            this.time = 0;
        }
        if (this.lineID < 0 || this.lineID >= this.script.getInstructions().length) {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setLineID(Tuple<Integer, Integer> marker) {
        this.lineID = (Integer)marker.func_76341_a();
        this.time = (Integer)marker.func_76340_b();
    }

    public POLScript getScript() {
        return this.script;
    }

    public void setStack() {
        this.returnStack.push((Tuple<Integer, Integer>)new Tuple((Object)this.lineID, (Object)this.time));
    }

    public void returnStack() {
        if (this.returnStack.isEmpty()) {
            this.endProcess();
        } else {
            this.setLineID(this.returnStack.pop());
        }
    }

    private void endProcess() {
        this.running = false;
    }

    public void skip() {
        POLScript.POLInstruction instruction = this.script.getInstructions()[this.lineID];
        ++this.time;
        if (instruction.getExecutionTime() <= this.time) {
            ++this.lineID;
            this.time = 0;
        }
    }
}

