/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationCeil;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationCos;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationFloor;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationMax;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationMin;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationPower;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationRoot;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationRound;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationSign;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationSin;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic.DataOperationTan;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_logic.DataOperationNAND;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_logic.DataOperationNOR;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_logic.DataOperationXNOR;
import pl.pabilo8.immersiveintelligence.api.data.operations.advanced_logic.DataOperationXOR;
import pl.pabilo8.immersiveintelligence.api.data.operations.arithmetic.DataOperationAbs;
import pl.pabilo8.immersiveintelligence.api.data.operations.arithmetic.DataOperationAdd;
import pl.pabilo8.immersiveintelligence.api.data.operations.arithmetic.DataOperationDivide;
import pl.pabilo8.immersiveintelligence.api.data.operations.arithmetic.DataOperationModulo;
import pl.pabilo8.immersiveintelligence.api.data.operations.arithmetic.DataOperationMultiply;
import pl.pabilo8.immersiveintelligence.api.data.operations.arithmetic.DataOperationSubtract;
import pl.pabilo8.immersiveintelligence.api.data.operations.array.DataOperationArrayLength;
import pl.pabilo8.immersiveintelligence.api.data.operations.array.DataOperationGet;
import pl.pabilo8.immersiveintelligence.api.data.operations.array.DataOperationPop;
import pl.pabilo8.immersiveintelligence.api.data.operations.array.DataOperationPush;
import pl.pabilo8.immersiveintelligence.api.data.operations.array.DataOperationSet;
import pl.pabilo8.immersiveintelligence.api.data.operations.array.DataOperationSwap;
import pl.pabilo8.immersiveintelligence.api.data.operations.comparators.DataOperationEqual;
import pl.pabilo8.immersiveintelligence.api.data.operations.comparators.DataOperationGreater;
import pl.pabilo8.immersiveintelligence.api.data.operations.comparators.DataOperationGreaterOrEqual;
import pl.pabilo8.immersiveintelligence.api.data.operations.comparators.DataOperationLess;
import pl.pabilo8.immersiveintelligence.api.data.operations.comparators.DataOperationLessOrEqual;
import pl.pabilo8.immersiveintelligence.api.data.operations.document.DataOperationDocumentGetAuthor;
import pl.pabilo8.immersiveintelligence.api.data.operations.document.DataOperationDocumentGetTitle;
import pl.pabilo8.immersiveintelligence.api.data.operations.document.DataOperationDocumentReadAllPagesArray;
import pl.pabilo8.immersiveintelligence.api.data.operations.document.DataOperationDocumentReadAllPagesString;
import pl.pabilo8.immersiveintelligence.api.data.operations.document.DataOperationDocumentReadPage;
import pl.pabilo8.immersiveintelligence.api.data.operations.entity.DataOperationGetEntityDimensionID;
import pl.pabilo8.immersiveintelligence.api.data.operations.entity.DataOperationGetEntityID;
import pl.pabilo8.immersiveintelligence.api.data.operations.entity.DataOperationGetEntityName;
import pl.pabilo8.immersiveintelligence.api.data.operations.entity.DataOperationGetEntityPosX;
import pl.pabilo8.immersiveintelligence.api.data.operations.entity.DataOperationGetEntityPosY;
import pl.pabilo8.immersiveintelligence.api.data.operations.entity.DataOperationGetEntityPosZ;
import pl.pabilo8.immersiveintelligence.api.data.operations.entity.DataOperationGetEntityType;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationCanStackWith;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationGetDurability;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationGetItemID;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationGetItemStack;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationGetNBT;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationGetQuantity;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationIsStackEmpty;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationMatchesOreDictionary;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationSetDurability;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationSetNBT;
import pl.pabilo8.immersiveintelligence.api.data.operations.itemstack.DataOperationSetQuantity;
import pl.pabilo8.immersiveintelligence.api.data.operations.logic.DataOperationAND;
import pl.pabilo8.immersiveintelligence.api.data.operations.logic.DataOperationNOT;
import pl.pabilo8.immersiveintelligence.api.data.operations.logic.DataOperationOR;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringCamelCase;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringCharAt;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringContains;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringContainsCount;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringFormat;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringHexcol;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringJoin;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringLength;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringLowerCase;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringReplaceAll;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringReplaceFirst;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringReverse;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringSnakeCase;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringSplit;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringSubstring;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringTrim;
import pl.pabilo8.immersiveintelligence.api.data.operations.text.DataOperationStringUpperCase;
import pl.pabilo8.immersiveintelligence.api.data.operations.type_conversion.DataOperationIsNull;
import pl.pabilo8.immersiveintelligence.api.data.operations.type_conversion.DataOperationIsSameType;
import pl.pabilo8.immersiveintelligence.api.data.operations.type_conversion.DataOperationToBoolean;
import pl.pabilo8.immersiveintelligence.api.data.operations.type_conversion.DataOperationToFloat;
import pl.pabilo8.immersiveintelligence.api.data.operations.type_conversion.DataOperationToInteger;
import pl.pabilo8.immersiveintelligence.api.data.operations.type_conversion.DataOperationToNull;
import pl.pabilo8.immersiveintelligence.api.data.operations.type_conversion.DataOperationToString;

public class DataOperations {
    public static final Map<String, Class<? extends DataOperation>> operations = new HashMap<String, Class<? extends DataOperation>>();

    @Nonnull
    public static DataOperation getOperationInstance(String name) {
        Class<? extends DataOperation> c = operations.get(name);
        if (c != null) {
            try {
                return c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new DataOperationAdd();
    }

    static {
        operations.put("add", DataOperationAdd.class);
        operations.put("subtract", DataOperationSubtract.class);
        operations.put("multiply", DataOperationMultiply.class);
        operations.put("divide", DataOperationDivide.class);
        operations.put("modulo", DataOperationModulo.class);
        operations.put("abs", DataOperationAbs.class);
        operations.put("power", DataOperationPower.class);
        operations.put("root", DataOperationRoot.class);
        operations.put("max", DataOperationMax.class);
        operations.put("min", DataOperationMin.class);
        operations.put("sign", DataOperationSign.class);
        operations.put("ceil", DataOperationCeil.class);
        operations.put("round", DataOperationRound.class);
        operations.put("floor", DataOperationFloor.class);
        operations.put("sin", DataOperationSin.class);
        operations.put("cos", DataOperationCos.class);
        operations.put("tan", DataOperationTan.class);
        operations.put("greater", DataOperationGreater.class);
        operations.put("less", DataOperationLess.class);
        operations.put("greater_or_equal", DataOperationGreaterOrEqual.class);
        operations.put("less_or_equal", DataOperationLessOrEqual.class);
        operations.put("equal", DataOperationEqual.class);
        operations.put("and", DataOperationAND.class);
        operations.put("or", DataOperationOR.class);
        operations.put("not", DataOperationNOT.class);
        operations.put("nand", DataOperationNAND.class);
        operations.put("nor", DataOperationNOR.class);
        operations.put("xor", DataOperationXOR.class);
        operations.put("xnor", DataOperationXNOR.class);
        operations.put("string_join", DataOperationStringJoin.class);
        operations.put("string_split", DataOperationStringSplit.class);
        operations.put("string_length", DataOperationStringLength.class);
        operations.put("string_char_at", DataOperationStringCharAt.class);
        operations.put("string_substring", DataOperationStringSubstring.class);
        operations.put("string_trim", DataOperationStringTrim.class);
        operations.put("string_hexcol", DataOperationStringHexcol.class);
        operations.put("string_format", DataOperationStringFormat.class);
        operations.put("string_contains", DataOperationStringContains.class);
        operations.put("string_contains_count", DataOperationStringContainsCount.class);
        operations.put("string_replace_first", DataOperationStringReplaceFirst.class);
        operations.put("string_replace_all", DataOperationStringReplaceAll.class);
        operations.put("string_lowercase", DataOperationStringLowerCase.class);
        operations.put("string_uppercase", DataOperationStringUpperCase.class);
        operations.put("string_snake_case", DataOperationStringSnakeCase.class);
        operations.put("string_camel_case", DataOperationStringCamelCase.class);
        operations.put("string_reverse", DataOperationStringReverse.class);
        operations.put("get_quantity", DataOperationGetQuantity.class);
        operations.put("set_quantity", DataOperationSetQuantity.class);
        operations.put("get_durability", DataOperationGetDurability.class);
        operations.put("set_durability", DataOperationSetDurability.class);
        operations.put("get_nbt", DataOperationGetNBT.class);
        operations.put("set_nbt", DataOperationSetNBT.class);
        operations.put("get_item_id", DataOperationGetItemID.class);
        operations.put("get_itemstack", DataOperationGetItemStack.class);
        operations.put("is_stack_empty", DataOperationIsStackEmpty.class);
        operations.put("can_stack_with", DataOperationCanStackWith.class);
        operations.put("matches_oredict", DataOperationMatchesOreDictionary.class);
        operations.put("entity_get_id", DataOperationGetEntityID.class);
        operations.put("entity_get_type", DataOperationGetEntityType.class);
        operations.put("entity_get_name", DataOperationGetEntityName.class);
        operations.put("entity_get_dimension_id", DataOperationGetEntityDimensionID.class);
        operations.put("entity_get_x", DataOperationGetEntityPosX.class);
        operations.put("entity_get_y", DataOperationGetEntityPosY.class);
        operations.put("entity_get_z", DataOperationGetEntityPosZ.class);
        operations.put("array_get", DataOperationGet.class);
        operations.put("array_set", DataOperationSet.class);
        operations.put("array_pop", DataOperationPop.class);
        operations.put("array_push", DataOperationPush.class);
        operations.put("array_swap", DataOperationSwap.class);
        operations.put("array_length", DataOperationArrayLength.class);
        operations.put("document_read_page", DataOperationDocumentReadPage.class);
        operations.put("document_read_all_pages_array", DataOperationDocumentReadAllPagesArray.class);
        operations.put("document_read_all_pages_string", DataOperationDocumentReadAllPagesString.class);
        operations.put("document_get_author", DataOperationDocumentGetAuthor.class);
        operations.put("document_get_title", DataOperationDocumentGetTitle.class);
        operations.put("is_null", DataOperationIsNull.class);
        operations.put("is_same_type", DataOperationIsSameType.class);
        operations.put("to_integer", DataOperationToInteger.class);
        operations.put("to_float", DataOperationToFloat.class);
        operations.put("to_string", DataOperationToString.class);
        operations.put("to_boolean", DataOperationToBoolean.class);
        operations.put("to_null", DataOperationToNull.class);
    }
}

