/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.utils.ISawblade;

public class SawmillRecipe
extends MultiblockRecipe {
    private static final int DEFAULT_COLOR = Utils.rgb(0.22392157f, 0.21372549f, 0.1517647f);
    public static float torqueModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final IngredientStack itemInput;
    public final ItemStack itemOutput;
    public final ItemStack itemSecondaryOutput;
    public static HashMap<String, ISawblade> toolMap = new HashMap();
    public static ArrayList<SawmillRecipe> recipeList = new ArrayList();
    int totalProcessTime;
    final int torque;
    final int hardness;
    final float[] dustColor;

    public int getTorque() {
        return this.torque;
    }

    public int getHardness() {
        return this.hardness;
    }

    public SawmillRecipe(ItemStack itemOutput, Object itemInput, ItemStack itemSecondaryOutput, int torque, int time, int hardness, int dustColor) {
        this.itemOutput = itemOutput;
        this.itemSecondaryOutput = itemSecondaryOutput;
        this.itemInput = ApiUtils.createIngredientStack((Object)itemInput);
        this.torque = (int)Math.floor((float)torque * torqueModifier);
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.hardness = hardness;
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.itemInput});
        this.outputList = ListUtils.fromItems((ItemStack[])new ItemStack[]{this.itemOutput, this.itemSecondaryOutput});
        this.dustColor = Utils.rgbIntToRGB(dustColor);
    }

    public static SawmillRecipe addRecipe(ItemStack itemOutput, IngredientStack itemInput, ItemStack itemSecondaryOutput, int torque, int time, int hardness) {
        return SawmillRecipe.addRecipe(itemOutput, itemInput, itemSecondaryOutput, torque, time, hardness, DEFAULT_COLOR);
    }

    public static SawmillRecipe addRecipe(ItemStack itemOutput, IngredientStack itemInput, ItemStack itemSecondaryOutput, int torque, int time, int hardness, int dustColor) {
        SawmillRecipe r = new SawmillRecipe(itemOutput, itemInput, itemSecondaryOutput, torque, time, hardness, dustColor);
        recipeList.add(r);
        return r;
    }

    public static List<SawmillRecipe> removeRecipesForOutput(ItemStack stack) {
        ArrayList<SawmillRecipe> list = new ArrayList<SawmillRecipe>();
        Iterator<SawmillRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            SawmillRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.itemOutput, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static SawmillRecipe findRecipe(ItemStack item_input) {
        for (SawmillRecipe recipe : recipeList) {
            if (!recipe.itemInput.matchesItemStackIgnoringSize(item_input)) continue;
            return recipe;
        }
        return null;
    }

    public static void registerSawblade(String name, ISawblade blade) {
        toolMap.putIfAbsent(name, blade);
    }

    public static boolean isValidRecipeInput(ItemStack stack) {
        for (SawmillRecipe recipe : recipeList) {
            if (!recipe.itemInput.matchesItemStack(stack)) continue;
            return true;
        }
        return false;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("item_input", (NBTBase)this.itemInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static SawmillRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack item_input = IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("item_input"));
        return SawmillRecipe.findRecipe(item_input.stack);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessTorque() {
        return this.torque;
    }

    public float[] getDustColor() {
        return this.dustColor;
    }
}

