/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class ElectrolyzerRecipe
extends MultiblockRecipe {
    public final FluidStack fluidInput;
    public final FluidStack[] fluidOutputs = new FluidStack[2];
    public static ArrayList<ElectrolyzerRecipe> recipeList = new ArrayList();
    int totalProcessTime;
    int totalProcessEnergy;

    public ElectrolyzerRecipe(FluidStack fluidInput, FluidStack fluidOutput1, @Nullable FluidStack fluidOutput2, int energy, int time) {
        this.fluidOutputs[0] = fluidOutput1;
        this.fluidOutputs[1] = fluidOutput2;
        this.fluidInput = fluidInput;
        this.totalProcessEnergy = (int)Math.floor(energy);
        this.totalProcessTime = (int)Math.floor(time);
        this.fluidInputList = Collections.singletonList(this.fluidInput);
        this.fluidOutputList = Arrays.asList(this.fluidOutputs);
    }

    public static ElectrolyzerRecipe addRecipe(FluidStack fluidInput, FluidStack fluidOutput1, FluidStack fluidOutput2, int energy, int time) {
        ElectrolyzerRecipe r = new ElectrolyzerRecipe(fluidInput, fluidOutput1, fluidOutput2, energy, time);
        recipeList.add(r);
        return r;
    }

    public static List<ElectrolyzerRecipe> removeRecipesForInput(FluidStack fluidInput) {
        List recipes = recipeList.stream().filter(r -> r.fluidInput.isFluidEqual(fluidInput)).collect(Collectors.toList());
        for (ElectrolyzerRecipe recipe : recipes) {
            recipeList.remove((Object)recipe);
        }
        return recipeList;
    }

    public static ElectrolyzerRecipe findRecipe(FluidStack fluidInput) {
        for (ElectrolyzerRecipe recipe : recipeList) {
            if (recipe.fluidInput.getFluid() != fluidInput.getFluid() || fluidInput.amount < recipe.fluidInput.amount) continue;
            return recipe;
        }
        return null;
    }

    public static ElectrolyzerRecipe findIncompleteRecipe(FluidStack fluidInput) {
        for (ElectrolyzerRecipe recipe : recipeList) {
            if (recipe.fluidInput.getFluid() != fluidInput.getFluid()) continue;
            return recipe;
        }
        return null;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("fluid_input", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static ElectrolyzerRecipe loadFromNBT(NBTTagCompound nbt) {
        FluidStack fluid_input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid_input"));
        return ElectrolyzerRecipe.findRecipe(fluid_input);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }
}

