/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.bullets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCore;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;

public class BulletRegistry {
    public static BulletRegistry INSTANCE = new BulletRegistry();
    public LinkedHashMap<String, IBulletComponent> registeredComponents = new LinkedHashMap();
    public LinkedHashMap<String, IBulletCore> registeredBulletCores = new LinkedHashMap();
    public LinkedHashMap<String, IBullet> registeredBulletItems = new LinkedHashMap();
    public HashMap<String, IBulletModel> registeredModels = new HashMap();

    public boolean registerComponent(IBulletComponent component) {
        String name = component.getName();
        if (!this.registeredComponents.containsKey(name)) {
            this.registeredComponents.put(name, component);
            return true;
        }
        return false;
    }

    public boolean registerBulletCore(IBulletCore core) {
        String name = core.getName();
        if (!this.registeredBulletCores.containsKey(name)) {
            this.registeredBulletCores.put(name, core);
            return true;
        }
        return false;
    }

    public boolean registerBulletItem(IBullet casing) {
        String name = casing.getName();
        if (!this.registeredBulletItems.containsKey(name)) {
            this.registeredBulletItems.put(name, casing);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                try {
                    IBulletModel iBulletModel = casing.getModel().newInstance();
                    iBulletModel.subscribeToList(casing.getName());
                    this.registeredModels.put(casing.getName(), iBulletModel);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public IBulletComponent getComponent(String name) {
        return this.registeredComponents.get(name);
    }

    @Nullable
    public IBullet getBulletItem(String name) {
        return this.registeredBulletItems.get(name);
    }

    @Nullable
    public IBulletCore getCore(String name) {
        return this.registeredBulletCores.get(name);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IBulletModel getModel(IBullet bullet) {
        return this.registeredModels.get(bullet.getName());
    }

    public static enum PenMaterialTypes {
        METAL(true),
        GROUND(false),
        SOLID(true),
        FLESH(false),
        LIGHT(false);

        private final boolean ricochet;

        private PenMaterialTypes(boolean ricochet) {
            this.ricochet = ricochet;
        }

        public boolean canRicochetOff() {
            return this.ricochet;
        }

        public static PenMaterialTypes v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(PenMaterialTypes.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(METAL);
        }
    }

    public static enum EnumFuseTypes implements IStringSerializable
    {
        CONTACT,
        TIMED,
        PROXIMITY;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        @Nonnull
        public static EnumFuseTypes v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(EnumFuseTypes.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(CONTACT);
        }
    }

    public static enum EnumCoreTypes implements IStringSerializable
    {
        SOFTPOINT(2, 0.5f, 1.0f, 1.0f, EnumComponentRole.GENERAL_PURPOSE){

            @Override
            public float getDamageMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.FLESH ? 1.65f : 1.0f;
            }
        }
        ,
        SHAPED(3, 0.5f, 1.25f, 1.0f, EnumComponentRole.GENERAL_PURPOSE){

            @Override
            public float getPenMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.METAL ? 1.5f : 0.5f;
            }

            @Override
            public float getDamageMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.METAL ? 1.85f : 1.0f;
            }
        }
        ,
        PIERCING(1, 1.35f, 0.75f, 1.0f, EnumComponentRole.PIERCING),
        PIERCING_SABOT(0, 2.0f, 0.0f, 0.85f, EnumComponentRole.PIERCING){

            @Override
            public float getPenMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.GROUND || p == PenMaterialTypes.SOLID ? 1.15f : 2.0f;
            }
        }
        ,
        CANISTER(4, 0.125f, 1.25f, 0.125f, EnumComponentRole.GENERAL_PURPOSE){

            @Override
            public float getPenMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.LIGHT ? 1.0f : 0.125f;
            }
        };

        private final int componentSlots;
        private final float componentEffectivenessMod;
        private final Function<PenMaterialTypes, Float> getPenEffectiveness;
        private final Function<PenMaterialTypes, Float> getDamageMod;
        @Nullable
        private final EnumComponentRole role;

        private EnumCoreTypes(int componentSlots, float penHardnessMod, @Nullable float componentEffectivenessMod, float damageMod, EnumComponentRole role) {
            this.componentSlots = componentSlots;
            this.getPenEffectiveness = penMaterialTypes -> Float.valueOf(penHardnessMod);
            this.componentEffectivenessMod = componentEffectivenessMod;
            this.getDamageMod = penMaterialTypes -> Float.valueOf(damageMod);
            this.role = role;
        }

        public float getPenMod(PenMaterialTypes p) {
            return this.getPenEffectiveness.apply(p).floatValue();
        }

        public float getDamageMod(PenMaterialTypes p) {
            return this.getDamageMod.apply(p).floatValue();
        }

        public int getComponentSlots() {
            return this.componentSlots;
        }

        public float getComponentEffectivenessMod() {
            return this.componentEffectivenessMod;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        @Nullable
        public EnumComponentRole getRole() {
            return this.role;
        }

        @Nonnull
        public static EnumCoreTypes v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(EnumCoreTypes.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(SOFTPOINT);
        }
    }

    public static enum EnumComponentRole implements IStringSerializable
    {
        GENERAL_PURPOSE,
        SHRAPNEL,
        PIERCING,
        EXPLOSIVE,
        INCENDIARY,
        TRACER,
        FLARE,
        CHEMICAL,
        SPECIAL;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        @Nonnull
        public static EnumComponentRole v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(EnumComponentRole.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(GENERAL_PURPOSE);
        }
    }
}

