/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.IWrench;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.client.model.ModelIIBase;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.blocks.BlockIIBase;
import pl.pabilo8.immersiveintelligence.common.blocks.BlockIIMultiblock;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class Utils {
    public static final int COLOR_POWERBAR_1 = -4909824;
    public static final int COLOR_POWERBAR_2 = -10482944;
    public static final int COLOR_ARMORBAR_1 = -808464433;
    public static final int COLOR_ARMORBAR_2 = 0xCFCFCFC;
    public static final int COLOR_H1 = 657930;
    public static final int COLOR_H2 = 0x1A1A1A;

    public static double getDistanceBetweenPos(BlockPos pos1, BlockPos pos2, boolean center) {
        double deltaX = (double)pos1.func_177958_n() + (center ? 0.0 : 0.5) - ((double)pos2.func_177958_n() + (center ? 0.0 : 0.5));
        double deltaY = (double)pos1.func_177956_o() + (center ? 0.0 : 0.5) - ((double)pos2.func_177956_o() + (center ? 0.0 : 0.5));
        double deltaZ = (double)pos1.func_177952_p() + (center ? 0.0 : 0.5) - ((double)pos2.func_177952_p() + (center ? 0.0 : 0.5));
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    @Nullable
    public static IDataConnector findConnectorFacing(BlockPos pos, World world, EnumFacing facing) {
        IEBlockInterfaces.IDirectionalTile t;
        BlockPos newpos = pos.func_177972_a(facing);
        if (!world.func_175667_e(newpos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(newpos);
        if (te instanceof IDataConnector && te instanceof IEBlockInterfaces.IDirectionalTile && (t = (IEBlockInterfaces.IDirectionalTile)te).getFacing() == facing.func_176734_d()) {
            return (IDataConnector)te;
        }
        return null;
    }

    @Nullable
    public static IDataConnector findConnectorAround(BlockPos pos, World world) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IDataConnector conn = Utils.findConnectorFacing(pos, world, facing);
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    public static NetworkRegistry.TargetPoint targetPointFromPos(BlockPos pos, World world, int range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)range);
    }

    public static NetworkRegistry.TargetPoint targetPointFromPos(Vec3d pos, World world, int range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)range);
    }

    public static NetworkRegistry.TargetPoint targetPointFromEntity(Entity entity, int range) {
        return new NetworkRegistry.TargetPoint(entity.field_70170_p.field_73011_w.getDimension(), (double)entity.func_180425_c().func_177958_n(), (double)entity.func_180425_c().func_177956_o(), (double)entity.func_180425_c().func_177952_p(), (double)range);
    }

    public static NetworkRegistry.TargetPoint targetPointFromTile(TileEntity tile, int range) {
        return new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)range);
    }

    public static double root(double num, double root) {
        double d = Math.pow(num, 1.0 / root);
        long rounded = Math.round(d);
        return Math.abs((double)rounded - d) < 1.0E-14 ? (double)rounded : d;
    }

    public static int[] rgbToCmyk(int red, int green, int blue) {
        return new int[]{255 - red, 255 - green, 255 - blue, 255 - Math.min(red, Math.max(green, blue))};
    }

    public static float[] rgbToCmyk(float r, float g, float b) {
        int[] cmyk = Utils.rgbToCmyk((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
        return new float[]{(float)cmyk[0] / 255.0f, (float)cmyk[1] / 255.0f, (float)cmyk[2] / 255.0f, (float)cmyk[3] / 255.0f};
    }

    public static float[] rgbToCmyk(float[] rgb) {
        return Utils.rgbToCmyk(rgb[0], rgb[1], rgb[2]);
    }

    public static int[] cmykToRgb(int cyan, int magenta, int yellow, int black) {
        return new int[]{Math.min(255 - black, 255 - cyan), Math.min(255 - black, 255 - magenta), Math.min(255 - black, 255 - yellow)};
    }

    public static float[] cmykToRgb(float c, float m, float y, float b) {
        int[] dec = Utils.cmykToRgb((int)(c * 255.0f), (int)(m * 255.0f), (int)(y * 255.0f), (int)(b * 255.0f));
        return new float[]{(float)dec[0] / 255.0f, (float)dec[1] / 255.0f, (float)dec[2] / 255.0f};
    }

    public static float[] hsvToRgb(float hue, float saturation, float value) {
        float b;
        float g;
        float r;
        int i = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)i;
        float f1 = value * (1.0f - saturation);
        float f2 = value * (1.0f - f * saturation);
        float f3 = value * (1.0f - (1.0f - f) * saturation);
        switch (i) {
            case 0: {
                r = value;
                g = f3;
                b = f1;
                break;
            }
            case 1: {
                r = f2;
                g = value;
                b = f1;
                break;
            }
            case 2: {
                r = f1;
                g = value;
                b = f3;
                break;
            }
            case 3: {
                r = f1;
                g = f2;
                b = value;
                break;
            }
            case 4: {
                r = f3;
                g = f1;
                b = value;
                break;
            }
            case 5: {
                r = value;
                g = f1;
                b = f2;
                break;
            }
            default: {
                r = 0.0f;
                g = 0.0f;
                b = 0.0f;
            }
        }
        return new float[]{r, g, b};
    }

    public static float[] rgbToHsv(float r, float g, float b) {
        float s;
        float cMax = Math.max(Math.max(r, g), b);
        float cMin = Math.min(Math.min(r, g), b);
        float d = cMax - cMin;
        float f = s = cMax != 0.0f ? d / cMax : 0.0f;
        float h = d == 0.0f ? 0.0f : (cMax == r ? (g - b) / d % 6.0f / 6.0f : (cMax == g ? ((b - r) / d + 2.0f) / 6.0f : (cMax == b ? ((r - g) / d + 4.0f) / 6.0f : 0.0f)));
        if (h < 0.0f) {
            h = 1.0f + h;
        }
        return new float[]{h, s, cMax};
    }

    public static boolean isPointInRectangle(double x, double y, double xx, double yy, double px, double py) {
        return px >= x && px < xx && py >= y && py < yy;
    }

    public static boolean isPointInTriangle(int x, int y, int xx, int yy, int xxx, int yyy, int px, int py) {
        boolean s_ab;
        int as_x;
        int as_y;
        if ((xxx - x) * as_y - (yyy - y) * as_x > 0 == (s_ab = (xx - x) * (as_y = py - y) - (yy - y) * (as_x = px - x) > 0)) {
            return false;
        }
        return (xxx - xx) * (py - yy) - (yyy - yy) * (px - xx) > 0 == s_ab;
    }

    public static <T extends IFluidTank & IFluidHandler> boolean handleBucketTankInteraction(T[] tanks, NonNullList<ItemStack> inventory, int bucketInputSlot, int bucketOutputSlot, int tank, boolean fillBucket) {
        return Utils.handleBucketTankInteraction(tanks, inventory, (int)bucketInputSlot, (int)bucketOutputSlot, (int)tank, (boolean)fillBucket, (T fluidStack) -> true);
    }

    public static <T extends IFluidTank & IFluidHandler> boolean handleBucketTankInteraction(T[] tanks, NonNullList<ItemStack> inventory, int bucketInputSlot, int bucketOutputSlot, int tank, boolean fillBucket, Predicate<FluidStack> filter) {
        if (((ItemStack)inventory.get(bucketInputSlot)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            ItemStack emptyContainer;
            IFluidHandlerItem capability = (IFluidHandlerItem)((ItemStack)inventory.get(bucketInputSlot)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (!filter.test(capability.getTankProperties()[0].getContents())) {
                return false;
            }
            int amount_prev = tanks[tank].getFluidAmount();
            if (fillBucket) {
                if (((IFluidHandler)tanks[tank]).getTankProperties()[0].getContents() == null) {
                    return false;
                }
                emptyContainer = blusunrize.immersiveengineering.common.util.Utils.fillFluidContainer((IFluidHandler)((IFluidHandler)tanks[tank]), (ItemStack)((ItemStack)inventory.get(bucketInputSlot)), (ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), null);
            } else {
                if (capability.getTankProperties()[0].getContents() == null) {
                    return false;
                }
                emptyContainer = blusunrize.immersiveengineering.common.util.Utils.drainFluidContainer((IFluidHandler)((IFluidHandler)tanks[tank]), (ItemStack)((ItemStack)inventory.get(bucketInputSlot)), (ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), null);
            }
            if (amount_prev != tanks[tank].getFluidAmount()) {
                if (!((ItemStack)inventory.get(bucketOutputSlot)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), (ItemStack)emptyContainer, (boolean)true)) {
                    ((ItemStack)inventory.get(bucketOutputSlot)).func_190917_f(emptyContainer.func_190916_E());
                } else if (((ItemStack)inventory.get(bucketOutputSlot)).func_190926_b()) {
                    inventory.set(bucketOutputSlot, (Object)emptyContainer.func_77946_l());
                }
                ((ItemStack)inventory.get(bucketInputSlot)).func_190918_g(1);
                if (((ItemStack)inventory.get(bucketInputSlot)).func_190916_E() <= 0) {
                    inventory.set(bucketInputSlot, (Object)ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean outputFluidToTank(FluidTank tank, int amount, BlockPos pos, World world, EnumFacing side) {
        if (tank.getFluidAmount() > 0) {
            int accepted;
            FluidStack out = blusunrize.immersiveengineering.common.util.Utils.copyFluidStackWithAmount((FluidStack)tank.getFluid(), (int)Math.min(tank.getFluidAmount(), amount), (boolean)false);
            IFluidHandler output = FluidUtil.getFluidHandler((World)world, (BlockPos)pos.func_177972_a(side), (EnumFacing)side);
            if (output != null && (accepted = output.fill(out, false)) > 0) {
                int drained = output.fill(blusunrize.immersiveengineering.common.util.Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
                tank.drain(drained, true);
                return true;
            }
        }
        return false;
    }

    public static Vec3d offsetPosDirection(float offset, double yaw, double pitch) {
        double yy = MathHelper.func_76126_a((float)((float)pitch)) * offset;
        double true_offset = MathHelper.func_76134_b((float)((float)pitch)) * offset;
        double xx = (double)MathHelper.func_76126_a((float)((float)yaw)) * true_offset;
        double zz = (double)MathHelper.func_76134_b((float)((float)yaw)) * true_offset;
        return new Vec3d(xx, yy, zz);
    }

    public static float[] rgbIntToRGB(int rgb) {
        float r = (float)(rgb / 256 / 256 % 256) / 255.0f;
        float g = (float)(rgb / 256 % 256) / 255.0f;
        float b = (float)(rgb % 256) / 255.0f;
        return new float[]{r, g, b};
    }

    public static char cycleDataPacketChars(char current, boolean forward, boolean hasEmpty) {
        if (hasEmpty) {
            if (current == ' ') {
                current = forward ? DataPacket.varCharacters[0] : DataPacket.varCharacters[DataPacket.varCharacters.length - 1];
            } else {
                int current_char = ArrayUtils.indexOf((char[])DataPacket.varCharacters, (char)current);
                current = (current_char += forward ? 1 : -1) >= DataPacket.varCharacters.length || current_char < 0 ? (char)32 : DataPacket.varCharacters[current_char];
            }
        } else {
            int current_char = ArrayUtils.indexOf((char[])DataPacket.varCharacters, (char)current);
            current = (current_char += forward ? 1 : -1) >= DataPacket.varCharacters.length ? DataPacket.varCharacters[0] : (current_char < 0 ? DataPacket.varCharacters[DataPacket.varCharacters.length - 1] : DataPacket.varCharacters[current_char]);
        }
        return current;
    }

    public static char cyclePacketCharsAvoiding(char current, boolean forward, boolean hasEmpty, DataPacket packet) {
        int current_char = ArrayUtils.indexOf((char[])DataPacket.varCharacters, (char)current);
        int repeats = DataPacket.varCharacters.length + (hasEmpty ? 1 : 0);
        for (int i = 0; i < repeats; ++i) {
            char c;
            if ((current_char += forward ? 1 : -1) >= repeats) {
                current_char = 0;
            }
            if (current_char < 0) {
                current_char = repeats - 1;
            }
            char c2 = c = hasEmpty && current_char == DataPacket.varCharacters.length ? (char)' ' : DataPacket.varCharacters[current_char];
            if (packet.hasVariable(Character.valueOf(c))) continue;
            return c;
        }
        return current;
    }

    public static float clampedLerp3Par(float e1, float e2, float e3, float percent) {
        return (float)MathHelper.func_151238_b((double)MathHelper.func_151238_b((double)e1, (double)e2, (double)(percent * 2.0f)), (double)e3, (double)(Math.max(percent - 0.5f, 0.0f) * 2.0f));
    }

    public static float calculateBallisticAngle(double distance, double height, float force, double gravity, double drag, double anglePrecision) {
        double bestAngle = 0.0;
        double bestDistance = 3.4028234663852886E38;
        if (gravity == 0.0) {
            return 90.0f - (float)(Math.atan(height / distance) * 180.0 / Math.PI);
        }
        for (double i = Math.PI * anglePrecision; i < 1.5707963267948966; i += anglePrecision) {
            double motionX = MathHelper.func_76134_b((float)((float)i)) * force;
            double motionY = MathHelper.func_76126_a((float)((float)i)) * force;
            double posX = 0.0;
            for (double posY = 0.0; posY > height || motionY > 0.0; posY += (motionY -= gravity)) {
                motionY *= drag;
                posX += (motionX *= drag);
            }
            double distanceToTarget = Math.abs(distance - posX);
            if (!(distanceToTarget < bestDistance)) continue;
            bestDistance = distanceToTarget;
            bestAngle = i;
        }
        return 90.0f - (float)(bestAngle * 180.0 / Math.PI);
    }

    public static boolean isAdvancedHammer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_ADVANCED_HAMMER");
    }

    public static boolean isAABBContained(@Nonnull AxisAlignedBB compared, @Nonnull AxisAlignedBB comparedTo) {
        Vec3d c0 = new Vec3d(compared.field_72340_a, compared.field_72338_b, compared.field_72339_c);
        Vec3d c1 = new Vec3d(compared.field_72336_d, compared.field_72338_b, compared.field_72339_c);
        Vec3d c2 = new Vec3d(compared.field_72340_a, compared.field_72337_e, compared.field_72339_c);
        Vec3d c3 = new Vec3d(compared.field_72336_d, compared.field_72337_e, compared.field_72339_c);
        Vec3d c4 = new Vec3d(compared.field_72340_a, compared.field_72338_b, compared.field_72334_f);
        Vec3d c5 = new Vec3d(compared.field_72336_d, compared.field_72338_b, compared.field_72334_f);
        Vec3d c6 = new Vec3d(compared.field_72340_a, compared.field_72337_e, compared.field_72334_f);
        Vec3d c7 = new Vec3d(compared.field_72336_d, compared.field_72337_e, compared.field_72334_f);
        AxisAlignedBB comp2 = comparedTo.func_186662_g((double)0.1f);
        return comp2.func_72318_a(c0) && comp2.func_72318_a(c1) && comp2.func_72318_a(c2) && comp2.func_72318_a(c3) && comp2.func_72318_a(c4) && comp2.func_72318_a(c5) && comp2.func_72318_a(c6) && comp2.func_72318_a(c7);
    }

    public static String toCamelCase(String string, boolean startSmall) {
        String[] all;
        StringBuilder result = new StringBuilder();
        for (String s : all = string.split("_")) {
            result.append(Character.toUpperCase(s.charAt(0)));
            result.append(s.substring(1));
        }
        if (startSmall) {
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        }
        return result.toString();
    }

    public static void unlockIIAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            AdvancementManager manager = ((WorldServer)player.func_130014_f_()).func_191952_z();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("immersiveintelligence", name));
            if (advancement != null) {
                advancements.func_192750_a(advancement, "code_trigger");
            }
        }
    }

    public static boolean hasUnlockedIIAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            AdvancementManager manager = ((WorldServer)player.func_130014_f_()).func_191952_z();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("immersiveintelligence", name));
            if (advancement != null) {
                return advancements.func_192747_a(advancement).func_192105_a();
            }
        }
        return false;
    }

    public static boolean isWrench(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_WRENCH") && stack.func_77973_b() instanceof IWrench;
    }

    public static boolean isTachometer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("TOOL_TACHOMETER");
    }

    public static boolean isCrowbar(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_CROWBAR");
    }

    public static boolean isVoltmeter(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 2), (ItemStack)stack, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringCentered(FontRenderer fontRenderer, String string, int x, int y, int w, int h, int colour) {
        fontRenderer.func_78276_b(string, x + w / 2 - fontRenderer.func_78256_a(string) / 2, y + h, colour);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringCenteredScaled(FontRenderer fontRenderer, String string, int x, int y, int w, int h, float scale, int colour) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + ((float)(w / 2) - (float)fontRenderer.func_78256_a(string) * scale / 2.0f)), (float)(y + h), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_78276_b(string, 0, 0, colour);
        GlStateManager.func_179121_F();
    }

    public static int cycleInt(boolean forward, int current, int min, int max) {
        if ((current += forward ? 1 : -1) > max) {
            return min;
        }
        if (current < min) {
            return max;
        }
        return current;
    }

    public static int cycleIntAvoid(boolean forward, int current, int min, int max, int avoid) {
        int i = Utils.cycleInt(forward, current, min, max);
        if (i == avoid) {
            return Utils.cycleInt(forward, i, min, max);
        }
        return i;
    }

    public static <E extends Enum<E>> E cycleEnum(boolean forward, Class<E> enumType, E current) {
        return (E)((Enum[])enumType.getEnumConstants())[Utils.cycleInt(forward, current.ordinal(), 0, ((Enum[])enumType.getEnumConstants()).length - 1)];
    }

    public static boolean compareBlockstateOredict(IBlockState state, String oreName) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        return blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)stack, (String)oreName);
    }

    @SideOnly(value=Side.CLIENT)
    public static void tesselateBlockBreak(Tessellator tessellatorIn, WorldClient world, DamageBlockPos blockpos, float partialTicks) {
        Utils.tesselateBlockBreak(tessellatorIn, world, blockpos, Float.valueOf(blockpos.damage), partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public static void tesselateBlockBreak(Tessellator tessellatorIn, WorldClient world, DimensionBlockPos blockpos, Float value, float partialTicks) {
        IBlockState iblockstate;
        boolean hasBreak;
        BufferBuilder worldRendererIn = tessellatorIn.func_178180_c();
        EntityPlayerSP player = ClientUtils.mc().field_71439_g;
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        int progress = 9 - (int)MathHelper.func_76131_a((float)(value.floatValue() * 10.0f), (float)0.0f, (float)10.0f);
        if (progress < 0) {
            return;
        }
        renderEngine.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)1);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179141_d();
        worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        worldRendererIn.func_178969_c(-d0, -d1, -d2);
        Block block = world.func_180495_p((BlockPos)blockpos).func_177230_c();
        TileEntity te = world.func_175625_s((BlockPos)blockpos);
        boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull || block instanceof BlockIIMultiblock;
        if (!hasBreak) {
            boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
        }
        if (!hasBreak && (iblockstate = world.func_180495_p((BlockPos)blockpos)).func_185904_a() != Material.field_151579_a) {
            TextureAtlasSprite textureatlassprite = ClientUtils.destroyBlockIcons[progress];
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            blockrendererdispatcher.func_175020_a(iblockstate, (BlockPos)blockpos, textureatlassprite, (IBlockAccess)world);
        }
        tessellatorIn.func_78381_a();
        worldRendererIn.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179120_a((int)768, (int)774, (int)1, (int)1);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static ItemStack getStackWithMetaName(BlockIIBase<?> block, String name) {
        return new ItemStack(block, 1, block.getMetaBySubname(name));
    }

    public static ItemStack getStackWithMetaName(BlockIIBase<?> block, String name, int count) {
        ItemStack stack = Utils.getStackWithMetaName(block, name);
        stack.func_190920_e(count);
        return stack;
    }

    public static ItemStack getStackWithMetaName(ItemIIBase item, String name) {
        return new ItemStack((Item)item, 1, item.getMetaBySubname(name));
    }

    public static ItemStack getStackWithMetaName(ItemIIBase item, String name, int count) {
        ItemStack stack = Utils.getStackWithMetaName(item, name);
        stack.func_190920_e(count);
        return stack;
    }

    public static int RGBAToRGB(int color) {
        return color - (color >> 24 & 0xFF);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawItemProgress(ItemStack stack1, ItemStack stack2, float progress, ItemCameraTransforms.TransformType type, Tessellator tessellator, float scale) {
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        if (progress == 0.0f) {
            ClientUtils.mc().func_175599_af().func_181564_a(stack1, type);
        } else if (progress == 1.0f) {
            ClientUtils.mc().func_175599_af().func_181564_a(stack2, type);
        } else {
            float h0 = -0.5f;
            float h1 = h0 + progress;
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            GL11.glEnable((int)2960);
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GlStateManager.func_179132_a((boolean)false);
            GL11.glStencilFunc((int)512, (int)1, (int)255);
            GL11.glStencilOp((int)7681, (int)7680, (int)7680);
            GL11.glStencilMask((int)255);
            GlStateManager.func_179086_m((int)1024);
            GlStateManager.func_179114_b((float)(90.0f - ClientUtils.mc().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179090_x();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            ClientUtils.renderBox((BufferBuilder)worldrenderer, (double)-0.5, (double)h0, (double)-0.5, (double)0.5, (double)h1, (double)0.5);
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179114_b((float)(-(90.0f - ClientUtils.mc().func_175598_ae().field_78735_i)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179132_a((boolean)true);
            GL11.glStencilMask((int)0);
            GL11.glStencilFunc((int)514, (int)0, (int)255);
            ClientUtils.mc().func_175599_af().func_181564_a(stack1, type);
            GL11.glStencilFunc((int)514, (int)1, (int)255);
            ClientUtils.mc().func_175599_af().func_181564_a(stack2, type);
            GL11.glDisable((int)2960);
        }
        GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    static double colorDistance(int a, int b) {
        float[] f1 = Utils.rgbIntToRGB(a);
        float[] f2 = Utils.rgbIntToRGB(b);
        return Utils.colorDistance(f1, f2);
    }

    static double colorDistance(float[] f1, float[] f2) {
        int deltaR = (int)(f1[0] * 255.0f - f2[0] * 255.0f);
        int deltaG = (int)(f1[1] * 255.0f - f2[1] * 255.0f);
        int deltaB = (int)(f1[2] * 255.0f - f2[2] * 255.0f);
        return Math.abs((double)(deltaR * deltaR + deltaG * deltaG + deltaB * deltaB) / 3.0);
    }

    public static EnumDyeColor getRGBTextFormatting(int color) {
        float[] cc = Utils.rgbIntToRGB(color);
        Optional<EnumDyeColor> min = Arrays.stream(EnumDyeColor.values()).min(Comparator.comparingDouble(value -> Utils.colorDistance(value.func_193349_f(), cc)));
        return min.orElse(EnumDyeColor.BLACK);
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static float getMaxClientProgress(float current, float required, int parts) {
        return current - current % (required / (float)parts);
    }

    public static int rgb(float rIn, float gIn, float bIn) {
        return Utils.rgb(MathHelper.func_76141_d((float)(rIn * 255.0f)), MathHelper.func_76141_d((float)(gIn * 255.0f)), MathHelper.func_76141_d((float)(bIn * 255.0f)));
    }

    public static int rgb(int rIn, int gIn, int bIn) {
        int lvt_3_1_ = (rIn << 8) + gIn;
        lvt_3_1_ = (lvt_3_1_ << 8) + bIn;
        return lvt_3_1_;
    }

    public static float[] medColour(float[] colour1, float[] colour2, float proportion) {
        float rev = 1.0f - proportion;
        return new float[]{colour1[0] * rev + colour2[0] * proportion, colour1[1] * rev + colour2[1] * proportion, colour1[2] * rev + colour2[2] * proportion};
    }

    public static boolean inRange(int value, int maxValue, double min, double max) {
        double vv = (double)value / (double)maxValue;
        return vv >= min && vv <= max;
    }

    public static void drawArmorBar(int x, int y, int w, int h, float progress) {
        Utils.drawGradientBar(x, y, w, h, -808464433, 0xCFCFCFC, progress);
    }

    public static void drawPowerBar(int x, int y, int w, int h, float progress) {
        Utils.drawGradientBar(x, y, w, h, -4909824, -10482944, progress);
    }

    public static void drawGradientBar(int x, int y, int w, int h, int color1, int color2, float progress) {
        int stored = (int)((float)h * progress);
        ClientUtils.drawGradientRect((int)x, (int)(y + (h - stored)), (int)(x + w), (int)(y + h), (int)color1, (int)color2);
    }

    public static String getPowerLevelString(TileEntityMultiblockMetal tile) {
        return Utils.getPowerLevelString(tile.getEnergyStored(null), tile.getMaxEnergyStored(null));
    }

    public static String getPowerLevelString(int min, int max) {
        return String.format("%s/%s IF", min, max);
    }

    @SideOnly(value=Side.CLIENT)
    public static void bindTexture(ResourceLocation path) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(path);
    }

    public static float roundFloat(float number, int decimals) {
        int pow = 10;
        for (int i = 1; i < decimals; ++i) {
            pow *= 10;
        }
        float tmp = number * (float)pow;
        return (float)((int)(tmp - (float)((int)tmp) >= 0.5f ? tmp + 1.0f : tmp)) / (float)pow;
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelRendererTurbo[] createConstructionModel(@Nullable MachineUpgrade upgrade, ModelIIBase model) {
        int partCount = model.parts.values().stream().mapToInt(modelRendererTurbos -> ((ModelRendererTurbo[])modelRendererTurbos).length).sum();
        if (upgrade != null) {
            upgrade.setRequiredSteps(partCount);
        }
        ModelRendererTurbo[] output = new ModelRendererTurbo[partCount];
        int i = 0;
        for (ModelRendererTurbo[] value : model.parts.values()) {
            Arrays.sort(value, (o1, o2) -> (int)(o1.field_78797_d - o2.field_78797_d));
            ModelRendererTurbo[] modelRendererTurboArray = value;
            int n = modelRendererTurboArray.length;
            for (int j = 0; j < n; ++j) {
                ModelRendererTurbo mod;
                output[i] = mod = modelRendererTurboArray[j];
                ++i;
            }
        }
        return output;
    }

    public static String toSnakeCase(String value) {
        return value.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    public static float getDirectFireAngle(float initialForce, float mass, Vec3d toTarget) {
        float force = initialForce;
        double gravityMotionY = 0.0;
        double motionY = 0.0;
        double baseMotionY = toTarget.func_72432_b().field_72448_b;
        for (double dist = toTarget.func_72438_d(new Vec3d(0.0, toTarget.field_72448_b, 0.0)); dist > 0.0; dist -= (double)(EntityBullet.DEV_SLOMO * force)) {
            force -= 0.01f * force * EntityBullet.DEV_SLOMO;
            double baseMotionYC = baseMotionY * (double)(force / initialForce);
            motionY += (baseMotionYC + (gravityMotionY -= (double)(0.15f * mass * EntityBullet.DEV_SLOMO))) * (double)EntityBullet.DEV_SLOMO;
        }
        toTarget = toTarget.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
        return (float)Math.toDegrees(Math.atan2(toTarget.field_72448_b, toTarget.func_72438_d(new Vec3d(0.0, toTarget.field_72448_b, 0.0))));
    }

    public static float getIEDirectRailgunAngle(ItemStack ammo, Vec3d toTarget) {
        RailgunHandler.RailgunProjectileProperties p = RailgunHandler.getProjectileProperties((ItemStack)ammo);
        if (p != null) {
            double baseMotionY;
            float force = 20.0f;
            float gravity = (float)p.gravity;
            double gravityMotionY = 0.0;
            double motionY = 0.0;
            double baseMotionYC = baseMotionY = toTarget.func_72432_b().field_72448_b;
            double dist = toTarget.func_72438_d(new Vec3d(0.0, toTarget.field_72448_b, 0.0));
            while (dist > 0.0) {
                dist -= (double)force;
                force = (float)((double)force * 0.99);
                motionY += (baseMotionYC *= (double)0.99f) + (gravityMotionY -= (double)(gravity / force));
            }
            toTarget = toTarget.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
        }
        return (float)Math.toDegrees(Math.atan2(toTarget.field_72448_b, toTarget.func_72438_d(new Vec3d(0.0, toTarget.field_72448_b, 0.0))));
    }

    public static Vec3d getEntityCenter(Entity entity) {
        return entity.func_174791_d().func_72441_c((double)(-entity.field_70130_N / 2.0f), (double)(entity.field_70131_O / 2.0f), (double)(-entity.field_70130_N / 2.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawRope(BufferBuilder buff, double x, double y, double z, double xx, double yy, double zz, double xdiff, double zdiff) {
        buff.func_181662_b(x + xdiff, y, z - zdiff).func_187315_a(0.0, 0.0).func_181675_d();
        buff.func_181662_b(xx + xdiff, yy, zz - zdiff).func_187315_a(0.0, 1.0).func_181675_d();
        buff.func_181662_b(xx - xdiff, yy, zz + zdiff).func_187315_a(0.125, 1.0).func_181675_d();
        buff.func_181662_b(x - xdiff, y, z + zdiff).func_187315_a(0.125, 0.0).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFace(BufferBuilder buff, double x, double y, double z, double xx, double yy, double zz, double u, double uu, double v, double vv) {
        buff.func_181662_b(x, y, z).func_187315_a(u, v).func_181675_d();
        buff.func_181662_b(x, yy, z).func_187315_a(u, vv).func_181675_d();
        buff.func_181662_b(xx, yy, zz).func_187315_a(uu, vv).func_181675_d();
        buff.func_181662_b(xx, y, zz).func_187315_a(uu, v).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFluidBlock(@Nonnull FluidStack fs, boolean flowing, double x, double y, double z, double xx, double yy, double zz, boolean drawEnd) {
        Utils.bindTexture(TextureMap.field_110575_b);
        String tex = (flowing ? fs.getFluid().getFlowing(fs) : fs.getFluid().getStill(fs)).toString();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(tex);
        if (sprite != null) {
            int col = fs.getFluid().getColor(fs);
            double u = sprite.func_94209_e();
            double uu = sprite.func_94212_f();
            double v = sprite.func_94206_g();
            double vv = v + ((double)sprite.func_94210_h() - v) * Math.min(1.0, (yy - y) / (double)sprite.func_94216_b());
            double ux = u + (uu - u) * Math.min(1.0, (xx - x) / (double)sprite.func_94211_a());
            double uz = u + uu * Math.min(1.0, (zz - z) / (double)sprite.func_94211_a());
            GlStateManager.func_179131_c((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
            BufferBuilder buff = Tessellator.func_178181_a().func_178180_c();
            buff.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Utils.drawFace(buff, x, yy, z, xx, y, z, u, ux, v, vv);
            Utils.drawFace(buff, x, yy, zz, xx, y, zz, u, ux, v, vv);
            Utils.drawFace(buff, x, yy, z, x, y, zz, u, ux, v, vv);
            Utils.drawFace(buff, xx, yy, z, xx, y, zz, u, ux, v, vv);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Nonnull
    public static EnumFacing getFacingBetweenPos(@Nonnull BlockPos fromPos, @Nonnull BlockPos toPos) {
        Vec3d vv = new Vec3d((Vec3i)fromPos.func_177973_b((Vec3i)toPos)).func_72432_b();
        return EnumFacing.func_176737_a((float)((float)vv.field_72450_a), (float)((float)vv.field_72448_b), (float)((float)vv.field_72450_a));
    }

    public static IngredientStack ingredientFromData(IDataType dataType) {
        if (dataType instanceof DataTypeItemStack) {
            return new IngredientStack(((DataTypeItemStack)dataType).value.func_77946_l());
        }
        if (dataType instanceof DataTypeString) {
            return new IngredientStack(dataType.valueToString());
        }
        return new IngredientStack("*");
    }

    public static DataPacket getSimpleCallbackMessage(DataPacket packet, String parameter, IDataType value) {
        packet.setVariable(Character.valueOf('c'), new DataTypeString(parameter));
        packet.setVariable(Character.valueOf('g'), value);
        return packet;
    }

    public static void setEntityVelocity(Entity entity, double motionX, double motionY, double motionZ) {
        entity.field_70159_w = motionX;
        entity.field_70181_x = motionY;
        entity.field_70179_y = motionZ;
        entity.field_70133_I = true;
    }
}

