/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class MultipleRayTracer {
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public ArrayList<RayTraceResult> hits = new ArrayList();

    private MultipleRayTracer() {
    }

    public static MultipleRayTracer volumetricTrace(@Nonnull World world, @Nonnull Vec3d posStart, @Nonnull Vec3d posEnd, @Nonnull AxisAlignedBB aabb, boolean ignoreBlockWithoutBoundingBox, boolean stopOnLiquid, boolean allowEntities, @Nonnull List<Entity> entityFilter, @Nonnull List<BlockPos> blockFilter) {
        MultipleRayTracer rayTracer = new MultipleRayTracer();
        double precision = Math.abs(aabb.func_72320_b());
        double px = posStart.field_72450_a;
        double py = posStart.field_72448_b;
        double pz = posStart.field_72449_c;
        Vec3d pDiff = posEnd.func_178788_d(posStart).func_72432_b();
        double pxDiff = pDiff.field_72450_a * precision;
        double pyDiff = pDiff.field_72448_b * precision;
        double pzDiff = pDiff.field_72449_c * precision;
        Object lastPos = null;
        aabb = aabb.func_186662_g(0.25);
        double dist = posStart.func_72438_d(posEnd);
        for (double i = 0.0; i < dist; i += precision) {
            Vec3d bbEnd;
            px += pxDiff;
            py += pyDiff;
            pz += pzDiff;
            if (allowEntities) {
                MultipleRayTracer.traceEntities(world, rayTracer, aabb.func_72317_d(px, py, pz), entityFilter);
            }
            BlockPos pos = new BlockPos(px, py, pz);
            if (!blockFilter.stream().noneMatch(blockPos -> blockPos.equals((Object)pos))) continue;
            IBlockState state = world.func_180495_p(pos);
            if (stopOnLiquid && state.func_177230_c() instanceof IFluidBlock) break;
            if (state.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k) {
                if (ignoreBlockWithoutBoundingBox) continue;
                EnumFacing ff = EnumFacing.func_176737_a((float)((float)pxDiff), (float)((float)pyDiff), (float)((float)pzDiff));
                rayTracer.addResultToList(new RayTraceResult(new Vec3d(px, py, pz), ff));
                continue;
            }
            Vec3d bbStart = new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_72441_c(px, py, pz);
            RayTraceResult traceResult = state.func_185910_a(world, pos, bbStart, bbEnd = new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_72441_c(px, py, pz));
            if (traceResult == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) continue;
            rayTracer.addResultToList(traceResult);
        }
        return rayTracer;
    }

    private static void traceEntities(World world, MultipleRayTracer t, AxisAlignedBB aabb, List<Entity> filter) {
        if (aabb != null) {
            for (Entity entity : world.func_175674_a(null, aabb, input -> !filter.contains(input))) {
                if (!entity.func_70067_L() || entity.field_70145_X || !entity.func_174813_aQ().func_72326_a(aabb)) continue;
                t.addResultToList(new RayTraceResult(entity));
            }
        }
    }

    private void addResultToList(RayTraceResult traceResult) {
        if (traceResult != null && this.hits.stream().noneMatch(traceResult1 -> {
            if (traceResult.field_72313_a == traceResult1.field_72313_a) {
                switch (traceResult1.field_72313_a) {
                    case ENTITY: {
                        return traceResult.field_72308_g.equals((Object)traceResult1.field_72308_g);
                    }
                    case BLOCK: {
                        return traceResult.func_178782_a().equals((Object)traceResult1.func_178782_a());
                    }
                }
            }
            return false;
        })) {
            this.hits.add(traceResult);
        }
    }

    public String toString() {
        return Arrays.toString(this.hits.toArray(new RayTraceResult[0]));
    }

    public static class MultipleTracerBuilder {
        private final World world;
        private final Vec3d posStart;
        private final Vec3d posEnd;
        private AxisAlignedBB aabb;
        private boolean ignoreBlockWithoutBoundingBox = true;
        private boolean stopOnLiquid = false;
        private boolean allowEntities = true;
        private List<Entity> entityFilter;
        private List<BlockPos> blockFilter;

        private MultipleTracerBuilder(World world, Vec3d posStart, Vec3d posEnd) {
            this.world = world;
            this.posStart = posStart;
            this.posEnd = posEnd;
        }

        public static MultipleTracerBuilder setPos(World world, Vec3d posStart, Vec3d posEnd) {
            return new MultipleTracerBuilder(world, posStart, posEnd);
        }

        public MultipleTracerBuilder setAABB(AxisAlignedBB aabb) {
            this.aabb = aabb;
            return this;
        }

        public MultipleTracerBuilder setRules(boolean ignoreBlockWithoutBoundingBox, boolean stopOnLiquid, boolean allowEntities) {
            this.ignoreBlockWithoutBoundingBox = ignoreBlockWithoutBoundingBox;
            this.stopOnLiquid = stopOnLiquid;
            this.allowEntities = allowEntities;
            return this;
        }

        public MultipleTracerBuilder setEntityFilter(List<Entity> entityFilter) {
            this.entityFilter = entityFilter;
            return this;
        }

        public MultipleTracerBuilder setBlockFilter(List<BlockPos> blockFilter) {
            this.blockFilter = blockFilter;
            return this;
        }

        public MultipleTracerBuilder setFilters(List<Entity> entityFilter, List<BlockPos> blockFilter) {
            this.entityFilter = entityFilter;
            this.blockFilter = blockFilter;
            return this;
        }

        public MultipleRayTracer volumetricTrace() {
            if (this.entityFilter == null) {
                this.entityFilter = new ArrayList<Entity>();
            }
            if (this.blockFilter == null) {
                this.blockFilter = new ArrayList<BlockPos>();
            }
            if (this.aabb == null) {
                this.aabb = EMPTY_AABB;
            }
            return MultipleRayTracer.volumetricTrace(this.world, this.posStart, this.posEnd, this.aabb, this.ignoreBlockWithoutBoundingBox, this.stopOnLiquid, this.allowEntities, this.entityFilter, this.blockFilter);
        }
    }
}

