/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus.beta.noise;

import java.util.Random;

public class VoronoiNoiseGenerator {
    private static final double SQRT_2 = 1.4142135623730951;
    private static final double SQRT_3 = 1.7320508075688772;
    private boolean useDistance = false;
    private long seed;
    private short distanceMethod;

    public VoronoiNoiseGenerator(long seed, short distanceMethod) {
        this.seed = seed;
        this.distanceMethod = distanceMethod;
    }

    private double getDistance(double xDist, double zDist) {
        switch (this.distanceMethod) {
            case 0: {
                return Math.sqrt(xDist * xDist + zDist * zDist) / 1.4142135623730951;
            }
            case 1: {
                return xDist + zDist;
            }
        }
        return Double.NaN;
    }

    private double getDistance(double xDist, double yDist, double zDist) {
        switch (this.distanceMethod) {
            case 0: {
                return Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist) / 1.7320508075688772;
            }
            case 1: {
                return xDist + yDist + zDist;
            }
        }
        return Double.NaN;
    }

    public boolean isUseDistance() {
        return this.useDistance;
    }

    public void setUseDistance(boolean useDistance) {
        this.useDistance = useDistance;
    }

    public short getDistanceMethod() {
        return this.distanceMethod;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setDistanceMethod(short distanceMethod) {
        this.distanceMethod = distanceMethod;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public double noise(double x, double z, double frequency) {
        int xInt = x > 0.0 ? (int)x : (int)(x *= frequency) - 1;
        int zInt = z > 0.0 ? (int)z : (int)(z *= frequency) - 1;
        double minDist = 3.2E7;
        double xCandidate = 0.0;
        double zCandidate = 0.0;
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                double zPos;
                double zDist;
                double xPos = (double)xCur + VoronoiNoiseGenerator.valueNoise2D(xCur, zCur, this.seed);
                double xDist = xPos - x;
                double dist = xDist * xDist + (zDist = (zPos = (double)zCur + VoronoiNoiseGenerator.valueNoise2D(xCur, zCur, new Random(this.seed).nextLong())) - z) * zDist;
                if (!(dist < minDist)) continue;
                minDist = dist;
                xCandidate = xPos;
                zCandidate = zPos;
            }
        }
        if (this.useDistance) {
            double xDist = xCandidate - x;
            double zDist = zCandidate - z;
            return this.getDistance(xDist, zDist);
        }
        return VoronoiNoiseGenerator.valueNoise2D((int)Math.floor(xCandidate), (int)Math.floor(zCandidate), this.seed);
    }

    public double noise(double x, double y, double z, double frequency) {
        int xInt = x > 0.0 ? (int)x : (int)(x *= frequency) - 1;
        int yInt = y > 0.0 ? (int)y : (int)(y *= frequency) - 1;
        int zInt = z > 0.0 ? (int)z : (int)(z *= frequency) - 1;
        double minDist = 3.2E7;
        double xCandidate = 0.0;
        double yCandidate = 0.0;
        double zCandidate = 0.0;
        Random rand = new Random(this.seed);
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int yCur = yInt - 2; yCur <= yInt + 2; ++yCur) {
                for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                    double zPos;
                    double zDist;
                    double yPos;
                    double yDist;
                    double xPos = (double)xCur + VoronoiNoiseGenerator.valueNoise3D(xCur, yCur, zCur, this.seed);
                    double xDist = xPos - x;
                    double dist = xDist * xDist + (yDist = (yPos = (double)yCur + VoronoiNoiseGenerator.valueNoise3D(xCur, yCur, zCur, rand.nextLong())) - y) * yDist + (zDist = (zPos = (double)zCur + VoronoiNoiseGenerator.valueNoise3D(xCur, yCur, zCur, rand.nextLong())) - z) * zDist;
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    xCandidate = xPos;
                    yCandidate = yPos;
                    zCandidate = zPos;
                }
            }
        }
        if (this.useDistance) {
            double xDist = xCandidate - x;
            double yDist = yCandidate - y;
            double zDist = zCandidate - z;
            return this.getDistance(xDist, yDist, zDist);
        }
        return VoronoiNoiseGenerator.valueNoise3D((int)Math.floor(xCandidate), (int)Math.floor(yCandidate), (int)Math.floor(zCandidate), this.seed);
    }

    public static double valueNoise2D(int x, int z, long seed) {
        long n = (long)(1619 * x + 6971 * z) + 1013L * seed & Integer.MAX_VALUE;
        n = n >> 13 ^ n;
        return 1.0 - (double)(n * (n * n * 60493L + 19990303L) + 1376312589L & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public static double valueNoise3D(int x, int y, int z, long seed) {
        long n = (long)(1619 * x + 31337 * y + 6971 * z) + 1013L * seed & Integer.MAX_VALUE;
        n = n >> 13 ^ n;
        return 1.0 - (double)(n * (n * n * 60493L + 19990303L) + 1376312589L & Integer.MAX_VALUE) / 1.073741824E9;
    }
}

