/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus.beta.feature.structure;

import com.mrburgerUS.betaplus.beta.biome.BiomeGenBeta;
import com.mrburgerUS.betaplus.beta.feature.structure.FeatureBeta;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenSwampHut
extends MapGenStructure {
    private int maxDistanceBetweenPyramids;
    private String structureName = "Swamp_Hut";

    public WorldGenSwampHut(int distance) {
        MapGenStructureIO.func_143034_b(Start.class, (String)this.structureName);
        MapGenStructureIO.func_143031_a(SwampHut.class, (String)this.structureName);
        this.maxDistanceBetweenPyramids = distance;
    }

    public String func_143025_a() {
        return this.structureName;
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        return WorldGenSwampHut.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenPyramids, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenPyramids - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenPyramids - 1;
        }
        int k = chunkX / this.maxDistanceBetweenPyramids;
        int l = chunkZ / this.maxDistanceBetweenPyramids;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenPyramids;
        l *= this.maxDistanceBetweenPyramids;
        if (i == (k += random.nextInt(this.maxDistanceBetweenPyramids - 8)) && j == (l += random.nextInt(this.maxDistanceBetweenPyramids - 8))) {
            return this.field_75039_c.func_180494_b(new BlockPos(i * 16 + 8, 0, j * 16 + 8)) == BiomeGenBeta.swampland.handle;
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75038_b, chunkX, this.field_75039_c.func_189649_b(chunkX * 16, chunkZ * 16), chunkZ, this.field_75039_c.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
    }

    public static class SwampHut
    extends FeatureBeta {
        private boolean hasWitch;

        public SwampHut(Random random, int xPos, int zPos) {
            super(random, xPos, 64, zPos, 7, 7, 9);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Witch", this.hasWitch);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasWitch = tagCompound.func_74767_n("Witch");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            int k;
            int i1;
            int l;
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, 0)) {
                return false;
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 5, 1, 7, Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 2, 5, 4, 7, Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 4, 1, 0, Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 2, 2, 3, 3, 2, Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 3, 1, 3, 6, Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 2, 3, 5, 3, 6, Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 2, 7, 4, 3, 7, Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), Blocks.field_150344_f.func_176203_a(BlockPlanks.EnumType.SPRUCE.func_176839_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 2, 1, 3, 2, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 2, 5, 3, 2, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 7, 1, 3, 7, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 7, 5, 3, 7, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 2, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 3, 3, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150457_bL.func_176223_P().func_177226_a((IProperty)BlockFlowerPot.field_176443_b, (Comparable)BlockFlowerPot.EnumFlowerType.MUSHROOM_RED), 1, 3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 3, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150383_bp.func_176223_P(), 4, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 1, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 5, 2, 1, structureBoundingBoxIn);
            IBlockState iblockstate = Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            IBlockState iblockstate1 = Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate2 = Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            IBlockState iblockstate3 = Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 6, 4, 1, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 2, 0, 4, 7, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 4, 2, 6, 4, 7, iblockstate2, iblockstate2, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 8, 6, 4, 8, iblockstate3, iblockstate3, false);
            for (int i = 2; i <= 7; i += 5) {
                for (int j = 1; j <= 5; j += 4) {
                    this.func_175808_b(worldIn, Blocks.field_150364_r.func_176223_P(), j, -1, i, structureBoundingBoxIn);
                }
            }
            if (!this.hasWitch && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(l = this.func_74865_a(2, 5), i1 = this.func_74862_a(2), k = this.func_74873_b(2, 5)))) {
                this.hasWitch = true;
                EntityWitch entitywitch = new EntityWitch(worldIn);
                entitywitch.func_110163_bv();
                entitywitch.func_70012_b((double)l + 0.5, (double)i1, (double)k + 0.5, 0.0f, 0.0f);
                entitywitch.func_180482_a(worldIn.func_175649_E(new BlockPos(l, i1, k)), (IEntityLivingData)null);
                worldIn.func_72838_d((Entity)entitywitch);
            }
            return true;
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Random random, int chunkX, int yVal, int chunkZ, Biome biomeIn) {
            if (biomeIn == BiomeGenBeta.swampland.handle) {
                SwampHut swampPieces = new SwampHut(random, chunkX * 16, chunkZ * 16);
                this.field_75075_a.add(swampPieces);
                this.func_75072_c();
            }
        }
    }
}

