/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus.beta.feature.structure;

import com.mrburgerUS.betaplus.beta.biome.BiomeGenBeta;
import com.mrburgerUS.betaplus.beta.feature.structure.FeatureBeta;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenJunglePyramid
extends MapGenStructure {
    private int maxDistanceBetweenPyramids;
    private String structureName = "Jungle_Temple";

    public WorldGenJunglePyramid(int distance) {
        MapGenStructureIO.func_143034_b(Start.class, (String)this.structureName);
        MapGenStructureIO.func_143031_a(JunglePyramid.class, (String)this.structureName);
        this.maxDistanceBetweenPyramids = distance;
    }

    public String func_143025_a() {
        return this.structureName;
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        return WorldGenJunglePyramid.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenPyramids, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenPyramids - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenPyramids - 1;
        }
        int k = chunkX / this.maxDistanceBetweenPyramids;
        int l = chunkZ / this.maxDistanceBetweenPyramids;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenPyramids;
        l *= this.maxDistanceBetweenPyramids;
        if (i == (k += random.nextInt(this.maxDistanceBetweenPyramids - 8)) && j == (l += random.nextInt(this.maxDistanceBetweenPyramids - 8))) {
            return this.field_75039_c.func_180494_b(new BlockPos(i * 16 + 8, 0, j * 16 + 8)) == BiomeGenBeta.rainforest.handle;
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75038_b, chunkX, this.field_75039_c.func_189649_b(chunkX * 16, chunkZ * 16), chunkZ, this.field_75039_c.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
    }

    public static class JunglePyramid
    extends FeatureBeta {
        private boolean placedMainChest;
        private boolean placedHiddenChest;
        private boolean placedTrap1;
        private boolean placedTrap2;
        private static final Stones cobblestoneSelector = new Stones();

        public JunglePyramid(Random rand, int x, int y, int z) {
            super(rand, x, 64, z, 12, 10, 15);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("placedMainChest", this.placedMainChest);
            tagCompound.func_74757_a("placedHiddenChest", this.placedHiddenChest);
            tagCompound.func_74757_a("placedTrap1", this.placedTrap1);
            tagCompound.func_74757_a("placedTrap2", this.placedTrap2);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.placedMainChest = tagCompound.func_74767_n("placedMainChest");
            this.placedHiddenChest = tagCompound.func_74767_n("placedHiddenChest");
            this.placedTrap1 = tagCompound.func_74767_n("placedTrap1");
            this.placedTrap2 = tagCompound.func_74767_n("placedTrap2");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, 0)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, -4, 0, this.width - 1, 0, this.depth - 1, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 1, 2, 9, 2, 2, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 1, 12, 9, 2, 12, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 1, 3, 2, 2, 11, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, 1, 3, 9, 2, 11, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 3, 1, 10, 6, 1, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 3, 13, 10, 6, 13, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 3, 2, 1, 6, 12, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 10, 3, 2, 10, 6, 12, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 3, 2, 9, 3, 12, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 6, 2, 9, 6, 12, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 3, 7, 3, 8, 7, 11, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 8, 4, 7, 8, 10, false, randomIn, cobblestoneSelector);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 3, 1, 3, 8, 2, 11);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 4, 3, 6, 7, 3, 9);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 2, 4, 2, 9, 5, 12);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 4, 6, 5, 7, 6, 9);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 7, 6, 6, 7, 8);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 1, 2, 6, 2, 2);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 2, 12, 6, 2, 12);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 5, 1, 6, 5, 1);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 5, 13, 6, 5, 13);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 5, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, 5, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 5, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, 5, 9, structureBoundingBoxIn);
            for (int i = 0; i <= 14; i += 14) {
                this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 4, i, 2, 5, i, false, randomIn, cobblestoneSelector);
                this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 4, i, 4, 5, i, false, randomIn, cobblestoneSelector);
                this.func_74882_a(worldIn, structureBoundingBoxIn, 7, 4, i, 7, 5, i, false, randomIn, cobblestoneSelector);
                this.func_74882_a(worldIn, structureBoundingBoxIn, 9, 4, i, 9, 5, i, false, randomIn, cobblestoneSelector);
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 5, 6, 0, 6, 6, 0, false, randomIn, cobblestoneSelector);
            for (int l = 0; l <= 11; l += 11) {
                for (int j = 2; j <= 12; j += 2) {
                    this.func_74882_a(worldIn, structureBoundingBoxIn, l, 4, j, l, 5, j, false, randomIn, cobblestoneSelector);
                }
                this.func_74882_a(worldIn, structureBoundingBoxIn, l, 6, 5, l, 6, 5, false, randomIn, cobblestoneSelector);
                this.func_74882_a(worldIn, structureBoundingBoxIn, l, 6, 9, l, 6, 9, false, randomIn, cobblestoneSelector);
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 7, 2, 2, 9, 2, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, 7, 2, 9, 9, 2, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 7, 12, 2, 9, 12, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, 7, 12, 9, 9, 12, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 9, 4, 4, 9, 4, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 7, 9, 4, 7, 9, 4, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 9, 10, 4, 9, 10, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 7, 9, 10, 7, 9, 10, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 5, 9, 7, 6, 9, 7, false, randomIn, cobblestoneSelector);
            IBlockState iblockstate2 = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate3 = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            IBlockState iblockstate = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate1 = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            this.func_175811_a(worldIn, iblockstate1, 5, 9, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 9, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 5, 9, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 6, 9, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 5, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 7, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 3, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 7, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 7, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 7, 3, 10, structureBoundingBoxIn);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 9, 4, 1, 9, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 7, 1, 9, 7, 1, 9, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 10, 7, 2, 10, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 5, 4, 5, 6, 4, 5, false, randomIn, cobblestoneSelector);
            this.func_175811_a(worldIn, iblockstate2, 4, 4, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 7, 4, 5, structureBoundingBoxIn);
            for (int k = 0; k < 4; ++k) {
                this.func_175811_a(worldIn, iblockstate, 5, 0 - k, 6 + k, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 6, 0 - k, 6 + k, structureBoundingBoxIn);
                this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 0 - k, 7 + k, 6, 0 - k, 9 + k);
            }
            this.func_74878_a(worldIn, structureBoundingBoxIn, 1, -3, 12, 10, -1, 13);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 1, -3, 1, 3, -1, 13);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 1, -3, 1, 9, -1, 5);
            for (int i1 = 1; i1 <= 13; i1 += 2) {
                this.func_74882_a(worldIn, structureBoundingBoxIn, 1, -3, i1, 1, -2, i1, false, randomIn, cobblestoneSelector);
            }
            for (int j1 = 2; j1 <= 12; j1 += 2) {
                this.func_74882_a(worldIn, structureBoundingBoxIn, 1, -1, j1, 3, -1, j1, false, randomIn, cobblestoneSelector);
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, -2, 1, 5, -2, 1, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 7, -2, 1, 9, -2, 1, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 6, -3, 1, 6, -3, 1, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 6, -1, 1, 6, -1, 1, false, randomIn, cobblestoneSelector);
            this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.TRUE), 1, -3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.TRUE), 4, -3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.TRUE), 2, -3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.TRUE), 3, -3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 4, -3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 3, -3, 1, structureBoundingBoxIn);
            if (!this.placedTrap1) {
                this.placedTrap1 = this.func_189419_a(worldIn, structureBoundingBoxIn, randomIn, 3, -2, 1, EnumFacing.NORTH, LootTableList.field_189420_m);
            }
            this.func_175811_a(worldIn, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.TRUE), 3, -2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.TRUE), 7, -3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.TRUE), 7, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.TRUE), 7, -3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.TRUE), 7, -3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.TRUE), 7, -3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 8, -3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 9, -3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 9, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 9, -3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 9, -2, 4, structureBoundingBoxIn);
            if (!this.placedTrap2) {
                this.placedTrap2 = this.func_189419_a(worldIn, structureBoundingBoxIn, randomIn, 9, -2, 3, EnumFacing.WEST, LootTableList.field_189420_m);
            }
            this.func_175811_a(worldIn, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.TRUE), 8, -1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.TRUE), 8, -2, 3, structureBoundingBoxIn);
            if (!this.placedMainChest) {
                this.placedMainChest = this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 8, -3, 3, LootTableList.field_186430_l);
            }
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 9, -3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 8, -3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 4, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 5, -2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 5, -1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 6, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 7, -2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 7, -1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 8, -3, 5, structureBoundingBoxIn);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, -1, 1, 9, -1, 5, false, randomIn, cobblestoneSelector);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 8, -3, 8, 10, -1, 10);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176203_a(BlockStoneBrick.field_176252_O), 8, -2, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176203_a(BlockStoneBrick.field_176252_O), 9, -2, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176203_a(BlockStoneBrick.field_176252_O), 10, -2, 11, structureBoundingBoxIn);
            IBlockState iblockstate4 = Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH);
            this.func_175811_a(worldIn, iblockstate4, 8, -2, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 9, -2, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 10, -2, 12, structureBoundingBoxIn);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 8, -3, 8, 8, -3, 10, false, randomIn, cobblestoneSelector);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 10, -3, 8, 10, -3, 10, false, randomIn, cobblestoneSelector);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 10, -2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 8, -2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 8, -2, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 10, -1, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.UP), 9, -2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.WEST), 10, -2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.WEST), 10, -1, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150413_aR.func_176223_P().func_177226_a((IProperty)BlockRedstoneRepeater.field_185512_D, (Comparable)EnumFacing.NORTH), 10, -2, 10, structureBoundingBoxIn);
            if (!this.placedHiddenChest) {
                this.placedHiddenChest = this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 9, -3, 10, LootTableList.field_186430_l);
            }
            return true;
        }

        static class Stones
        extends StructureComponent.BlockSelector {
            private Stones() {
            }

            public void func_75062_a(Random rand, int x, int y, int z, boolean wall) {
                this.field_151562_a = rand.nextFloat() < 0.4f ? Blocks.field_150347_e.func_176223_P() : Blocks.field_150341_Y.func_176223_P();
            }
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Random random, int chunkX, int yVal, int chunkZ, Biome biomeIn) {
            if (biomeIn == BiomeGenBeta.rainforest.handle) {
                JunglePyramid junglePieces = new JunglePyramid(random, chunkX * 16, yVal, chunkZ * 16);
                this.field_75075_a.add(junglePieces);
                this.func_75072_c();
            }
        }
    }
}

