/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus.beta.feature.structure;

import com.mrburgerUS.betaplus.beta.biome.BiomeGenBeta;
import com.mrburgerUS.betaplus.beta.feature.structure.FeatureBeta;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenIgloo
extends MapGenStructure {
    private String structureName = "Igloo";
    private int maxDistanceBetweenPyramids;

    public WorldGenIgloo(int distance) {
        MapGenStructureIO.func_143034_b(Start.class, (String)this.structureName);
        MapGenStructureIO.func_143031_a(Igloo.class, (String)this.structureName);
        this.maxDistanceBetweenPyramids = distance;
    }

    public String func_143025_a() {
        return this.structureName;
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        return WorldGenIgloo.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenPyramids, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenPyramids - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenPyramids - 1;
        }
        int k = chunkX / this.maxDistanceBetweenPyramids;
        int l = chunkZ / this.maxDistanceBetweenPyramids;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenPyramids;
        l *= this.maxDistanceBetweenPyramids;
        if (i == (k += random.nextInt(this.maxDistanceBetweenPyramids - 8)) && j == (l += random.nextInt(this.maxDistanceBetweenPyramids - 8))) {
            return this.field_75039_c.func_180494_b(new BlockPos(i * 16 + 8, 0, j * 16 + 8)) == BiomeGenBeta.tundra.handle;
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75038_b, chunkX, chunkZ, this.field_75039_c.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
    }

    public static class Igloo
    extends FeatureBeta {
        private static final ResourceLocation IGLOO_TOP_ID = new ResourceLocation("igloo/igloo_top");
        private static final ResourceLocation IGLOO_MIDDLE_ID = new ResourceLocation("igloo/igloo_middle");
        private static final ResourceLocation IGLOO_BOTTOM_ID = new ResourceLocation("igloo/igloo_bottom");

        public Igloo(Random rand, int x, int z) {
            super(rand, x, 64, z, 7, 5, 8);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, -1)) {
                return false;
            }
            StructureBoundingBox structureboundingbox = this.func_74874_b();
            BlockPos blockpos = new BlockPos(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c);
            Rotation[] arotation = Rotation.values();
            MinecraftServer minecraftserver = worldIn.func_73046_m();
            TemplateManager templatemanager = worldIn.func_72860_G().func_186340_h();
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(arotation[randomIn.nextInt(arotation.length)]).func_186225_a(Blocks.field_189881_dj).func_186223_a(structureboundingbox);
            Template template = templatemanager.func_186237_a(minecraftserver, IGLOO_TOP_ID);
            template.func_186260_a(worldIn, blockpos, placementsettings);
            if (randomIn.nextDouble() < 0.5) {
                Template template1 = templatemanager.func_186237_a(minecraftserver, IGLOO_MIDDLE_ID);
                Template template2 = templatemanager.func_186237_a(minecraftserver, IGLOO_BOTTOM_ID);
                int i = randomIn.nextInt(8) + 4;
                for (int j = 0; j < i; ++j) {
                    BlockPos blockpos1 = template.func_186262_a(placementsettings, new BlockPos(3, -1 - j * 3, 5), placementsettings, new BlockPos(1, 2, 1));
                    template1.func_186260_a(worldIn, blockpos.func_177971_a((Vec3i)blockpos1), placementsettings);
                }
                BlockPos blockpos4 = blockpos.func_177971_a((Vec3i)template.func_186262_a(placementsettings, new BlockPos(3, -1 - i * 3, 5), placementsettings, new BlockPos(3, 5, 7)));
                template2.func_186260_a(worldIn, blockpos4, placementsettings);
                Map map = template2.func_186258_a(blockpos4, placementsettings);
                for (Map.Entry entry : map.entrySet()) {
                    if (!"chest".equals(entry.getValue())) continue;
                    BlockPos blockpos2 = (BlockPos)entry.getKey();
                    worldIn.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                    TileEntity tileentity = worldIn.func_175625_s(blockpos2.func_177977_b());
                    if (!(tileentity instanceof TileEntityChest)) continue;
                    ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186431_m, randomIn.nextLong());
                }
            } else {
                BlockPos blockpos3 = Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(3, 0, 5));
                worldIn.func_180501_a(blockpos.func_177971_a((Vec3i)blockpos3), Blocks.field_150433_aE.func_176223_P(), 3);
            }
            return true;
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Random random, int chunkX, int chunkZ, Biome biomeIn) {
            if (biomeIn == BiomeGenBeta.tundra.handle) {
                Igloo iglooPieces = new Igloo(random, chunkX * 16, chunkZ * 16);
                this.field_75075_a.add(iglooPieces);
                this.func_75072_c();
            }
        }
    }
}

