/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus.beta.feature.structure;

import com.mrburgerUS.betaplus.beta.biome.BiomeGenBeta;
import com.mrburgerUS.betaplus.beta.feature.structure.FeatureBeta;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenDesertPyramid
extends MapGenStructure {
    private String structureName = "Pyramid";
    private int maxDistanceBetweenPyramids;

    public WorldGenDesertPyramid(int distance) {
        MapGenStructureIO.func_143034_b(Start.class, (String)this.structureName);
        MapGenStructureIO.func_143031_a(DesertPyramid.class, (String)this.structureName);
        this.maxDistanceBetweenPyramids = distance;
    }

    public String func_143025_a() {
        return this.structureName;
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        return WorldGenDesertPyramid.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenPyramids, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenPyramids - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenPyramids - 1;
        }
        int k = chunkX / this.maxDistanceBetweenPyramids;
        int l = chunkZ / this.maxDistanceBetweenPyramids;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenPyramids;
        l *= this.maxDistanceBetweenPyramids;
        if (i == (k += random.nextInt(this.maxDistanceBetweenPyramids - 8)) && j == (l += random.nextInt(this.maxDistanceBetweenPyramids - 8))) {
            return this.field_75039_c.func_180494_b(new BlockPos(i * 16 + 8, 0, j * 16 + 8)) == BiomeGenBeta.desert.handle;
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75038_b, chunkX, 0, chunkZ, this.field_75039_c.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
    }

    public static class DesertPyramid
    extends FeatureBeta {
        private final boolean[] hasPlacedChest = new boolean[4];

        public DesertPyramid(Random random, int posX, int posY, int posZ) {
            super(random, posX, posY, posZ, 21, 15, 21);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("hasPlacedChest0", this.hasPlacedChest[0]);
            tagCompound.func_74757_a("hasPlacedChest1", this.hasPlacedChest[1]);
            tagCompound.func_74757_a("hasPlacedChest2", this.hasPlacedChest[2]);
            tagCompound.func_74757_a("hasPlacedChest3", this.hasPlacedChest[3]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
            super.func_143011_b(tagCompound, manager);
            this.hasPlacedChest[0] = tagCompound.func_74767_n("hasPlacedChest0");
            this.hasPlacedChest[1] = tagCompound.func_74767_n("hasPlacedChest1");
            this.hasPlacedChest[2] = tagCompound.func_74767_n("hasPlacedChest2");
            this.hasPlacedChest[3] = tagCompound.func_74767_n("hasPlacedChest3");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, 0)) {
                return false;
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, -4, 0, this.width - 1, 0, this.depth - 1, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            for (int i = 1; i <= 9; ++i) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, i, i, i, this.width - 1 - i, i, this.depth - 1 - i, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, i + 1, i, i + 1, this.width - 2 - i, i, this.depth - 2 - i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            for (int i2 = 0; i2 < this.width; ++i2) {
                for (int j = 0; j < this.depth; ++j) {
                    int k = -5;
                    this.func_175808_b(worldIn, Blocks.field_150322_A.func_176223_P(), i2, -5, j, structureBoundingBoxIn);
                }
            }
            IBlockState iblockstate1 = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            IBlockState iblockstate2 = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate3 = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            int orangeEnum = ~EnumDyeColor.ORANGE.func_176767_b() & 0xF;
            int blueEnum = ~EnumDyeColor.BLUE.func_176767_b() & 0xF;
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 9, 4, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 10, 1, 3, 10, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate1, 2, 10, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 2, 10, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 10, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 10, 2, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 5, 0, 0, this.width - 1, 9, 4, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 4, 10, 1, this.width - 2, 10, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate1, this.width - 3, 10, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, this.width - 3, 10, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, this.width - 5, 10, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, this.width - 1, 10, 2, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 12, 4, 4, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 0, 11, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 9, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 9, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 9, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 10, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 11, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 11, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 11, 1, 1, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 8, 3, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 2, 8, 2, 2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 1, 16, 3, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 2, 16, 2, 2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 4, 5, this.width - 6, 4, this.depth - 6, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 4, 9, 11, 4, 11, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 8, 8, 3, 8, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 8, 12, 3, 8, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 12, 8, 3, 12, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 12, 12, 3, 12, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 4, 4, 11, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 5, 1, 5, this.width - 2, 4, 11, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 7, 9, 6, 7, 11, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 7, 7, 9, this.width - 7, 7, 11, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 5, 9, 5, 7, 11, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 6, 5, 9, this.width - 6, 7, 11, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 6, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 6, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), this.width - 6, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), this.width - 6, 6, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), this.width - 7, 6, 10, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 4, 4, 2, 6, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 3, 4, 4, this.width - 3, 6, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate1, 2, 4, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, this.width - 3, 4, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, this.width - 3, 3, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 3, 2, 2, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 3, 1, 3, this.width - 2, 2, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P(), 1, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P(), this.width - 2, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.SAND.func_176624_a()), 1, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.SAND.func_176624_a()), this.width - 2, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, this.width - 3, 1, 2, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 3, 5, 4, 3, 18, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 5, 3, 5, this.width - 5, 3, 17, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 5, 4, 2, 16, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.width - 6, 1, 5, this.width - 5, 2, 16, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int j1 = 5; j1 <= 17; j1 += 2) {
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 4, 1, j1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), 4, 2, j1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), this.width - 5, 1, j1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), this.width - 5, 2, j1, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 10, 0, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 10, 0, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 9, 0, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 11, 0, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 8, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 12, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 7, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 13, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 9, 0, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 11, 0, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 10, 0, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 10, 0, 13, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(blueEnum), 10, 0, 10, structureBoundingBoxIn);
            for (int j2 = 0; j2 <= this.width - 1; j2 += this.width - 1) {
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 2, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 2, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 2, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 3, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 3, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 3, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 4, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), j2, 4, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 4, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 5, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 5, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 6, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), j2, 6, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 6, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 7, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 7, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), j2, 7, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 8, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 8, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), j2, 8, 3, structureBoundingBoxIn);
            }
            for (int k2 = 2; k2 <= this.width - 3; k2 += this.width - 3 - 2) {
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2 - 1, 2, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2, 2, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2 + 1, 2, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2 - 1, 3, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2, 3, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2 + 1, 3, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2 - 1, 4, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), k2, 4, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2 + 1, 4, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2 - 1, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2 + 1, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2 - 1, 6, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), k2, 6, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2 + 1, 6, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2 - 1, 7, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2, 7, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), k2 + 1, 7, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2 - 1, 8, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2, 8, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), k2 + 1, 8, 0, structureBoundingBoxIn);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 4, 0, 12, 6, 0, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 12, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 9, 5, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), 10, 5, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176203_a(orangeEnum), 11, 5, 0, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, -14, 8, 12, -11, 12, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, -10, 8, 12, -10, 12, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, -9, 8, 12, -9, 12, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, -8, 8, 12, -1, 12, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, -11, 9, 11, -1, 11, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150456_au.func_176223_P(), 10, -11, 10, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, -13, 9, 11, -13, 11, Blocks.field_150335_W.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, -11, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, -10, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), 7, -10, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 7, -11, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 12, -11, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 12, -10, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), 13, -10, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 13, -11, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, -11, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, -10, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), 10, -10, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 10, -11, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, -11, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, -10, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.CHISELED.func_176675_a()), 10, -10, 13, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a()), 10, -11, 13, structureBoundingBoxIn);
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                if (this.hasPlacedChest[enumfacing.func_176736_b()]) continue;
                int k1 = enumfacing.func_82601_c() * 2;
                int l1 = enumfacing.func_82599_e() * 2;
                this.hasPlacedChest[enumfacing.func_176736_b()] = this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 10 + k1, -11, 10 + l1, LootTableList.field_186429_k);
            }
            return true;
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Random random, int chunkX, int yVal, int chunkZ, Biome biomeIn) {
            if (biomeIn == BiomeGenBeta.desert.handle) {
                DesertPyramid desertPyramidPieces = new DesertPyramid(random, chunkX * 16, yVal, chunkZ * 16);
                this.field_75075_a.add(desertPyramidPieces);
                this.func_75072_c();
            }
        }
    }
}

