/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus.beta.biome;

import com.mrburgerUS.betaplus.beta.biome.BetaPlusBiome;
import com.mrburgerUS.betaplus.beta.biome.support.BiomeSelectBeta;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;

public enum BiomeGenBeta implements BetaPlusBiome
{
    rainforest(Biomes.field_76782_w),
    swampland(Biomes.field_76780_h),
    seasonalForest(Biomes.field_185444_T),
    forest(Biomes.field_76767_f),
    savanna(Biomes.field_150588_X),
    shrubland(Biomes.field_76772_c),
    taiga(Biomes.field_150584_S),
    desert(Biomes.field_76769_d, (Block)Blocks.field_150354_m, (Block)Blocks.field_150354_m),
    plains(Biomes.field_76772_c),
    tundra(Biomes.field_76774_n),
    ocean(Biomes.field_76771_b),
    deepOcean(Biomes.field_150575_M),
    beach(Biomes.field_76787_r),
    roofForest(Biomes.field_150585_R),
    mountain(Biomes.field_76770_e),
    iceSpikes(Biomes.field_185445_W),
    megaTaiga(Biomes.field_150578_U),
    mesa(Biomes.field_150589_Z, (Block)Blocks.field_150354_m, Blocks.field_150405_ch),
    birchForest(Biomes.field_150583_P),
    flowerPlains(Biomes.field_185441_Q);

    public Biome handle;
    public final Block topBlock;
    public final Block fillerBlock;
    private static final Biome[] biomeLookupTable;

    @Override
    public Biome getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(Biome biomeHandle) {
        this.handle = biomeHandle;
    }

    private BiomeGenBeta(Biome handle) {
        this(handle, (Block)Blocks.field_150349_c, Blocks.field_150346_d);
    }

    private BiomeGenBeta(Biome biomeHandle, Block top, Block filler) {
        this.handle = biomeHandle;
        this.topBlock = top;
        this.fillerBlock = filler;
    }

    public static void generateBiomeLookup() {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                BiomeGenBeta.biomeLookupTable[i + j * 64] = BiomeSelectBeta.getBiome((float)i / 63.0f, (float)j / 63.0f);
            }
        }
    }

    public static Biome getBiomeFromLookup(double temperature, double humidity) {
        int i = (int)(temperature * 63.0);
        int j = (int)(humidity * 63.0);
        return biomeLookupTable[i + j * 64];
    }

    static {
        biomeLookupTable = new Biome[4096];
        BiomeGenBeta.generateBiomeLookup();
    }
}

