/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus.beta;

import com.mrburgerUS.betaplus.BetaPlusSettings;
import com.mrburgerUS.betaplus.beta.BiomeProviderBeta;
import com.mrburgerUS.betaplus.beta.biome.MesaBetaHelper;
import com.mrburgerUS.betaplus.beta.feature.decoration.WorldGenSnowLayerBeta;
import com.mrburgerUS.betaplus.beta.feature.structure.WorldGenDesertPyramid;
import com.mrburgerUS.betaplus.beta.feature.structure.WorldGenDungeons;
import com.mrburgerUS.betaplus.beta.feature.structure.WorldGenIgloo;
import com.mrburgerUS.betaplus.beta.feature.structure.WorldGenJunglePyramid;
import com.mrburgerUS.betaplus.beta.feature.structure.WorldGenSwampHut;
import com.mrburgerUS.betaplus.beta.feature.structure.WorldGenVillage;
import com.mrburgerUS.betaplus.beta.feature.terrain.MapGenCaves;
import com.mrburgerUS.betaplus.beta.noise.NoiseGeneratorOctavesBeta;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;

public class ChunkGeneratorBeta
implements IChunkGenerator {
    private final BiomeProviderBeta biomeProvider;
    private Random rand;
    public World worldObj;
    public static Biome[] biomesForGeneration;
    public static final int seaLevel = 64;
    public static final int highAltitude = 116;
    private NoiseGeneratorOctavesBeta octaves1;
    private NoiseGeneratorOctavesBeta octaves2;
    private NoiseGeneratorOctavesBeta octaves3;
    private NoiseGeneratorOctavesBeta octaves4;
    private NoiseGeneratorOctavesBeta octaves5;
    private NoiseGeneratorOctavesBeta octaves6;
    private NoiseGeneratorOctavesBeta octaves7;
    private NoiseGeneratorPerlin surfaceNoise;
    private double[] octaveArr1;
    private double[] octaveArr2;
    private double[] octaveArr3;
    private double[] octaveArr4;
    private double[] octaveArr5;
    private double[] heightNoise;
    private double[] sandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] stoneNoise = new double[256];
    private double[] generatedTemperatures;
    private MapGenBase caveGenerator = new net.minecraft.world.gen.MapGenCaves();
    private MapGenRavine ravineGenerator = new MapGenRavine();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private WorldGenDesertPyramid desertPyramidGenerator;
    private WorldGenJunglePyramid junglePyramidGenerator;
    private WorldGenIgloo iglooGenerator;
    private WorldGenSwampHut swampHutGenerator;
    private WorldGenVillage villageGenerator;
    public static BetaPlusSettings settings;

    public ChunkGeneratorBeta(World world, long seed, String generationOptions) {
        if (generationOptions != null) {
            settings = BetaPlusSettings.Factory.jsonToSettings(generationOptions).build();
        }
        this.worldObj = world;
        this.worldObj.func_181544_b(64);
        this.rand = new Random(seed);
        this.octaves1 = new NoiseGeneratorOctavesBeta(this.rand, 16);
        this.octaves2 = new NoiseGeneratorOctavesBeta(this.rand, 16);
        this.octaves3 = new NoiseGeneratorOctavesBeta(this.rand, 8);
        this.octaves4 = new NoiseGeneratorOctavesBeta(this.rand, 4);
        this.octaves5 = new NoiseGeneratorOctavesBeta(this.rand, 4);
        this.octaves6 = new NoiseGeneratorOctavesBeta(this.rand, 10);
        this.octaves7 = new NoiseGeneratorOctavesBeta(this.rand, 16);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.biomeProvider = new BiomeProviderBeta(world, ChunkGeneratorBeta.settings.generatorType);
        this.desertPyramidGenerator = new WorldGenDesertPyramid(ChunkGeneratorBeta.settings.maxDistanceBetweenPyramids);
        this.junglePyramidGenerator = new WorldGenJunglePyramid(ChunkGeneratorBeta.settings.maxDistanceBetweenPyramids);
        this.iglooGenerator = new WorldGenIgloo(ChunkGeneratorBeta.settings.maxDistanceBetweenPyramids);
        this.swampHutGenerator = new WorldGenSwampHut(ChunkGeneratorBeta.settings.maxDistanceBetweenPyramids);
        this.villageGenerator = new WorldGenVillage(48);
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        biomesForGeneration = this.biomeProvider.func_76933_b(biomesForGeneration, x * 16, z * 16, 16, 16);
        ChunkPrimer primer = new ChunkPrimer();
        this.generateTerrain(x, z, primer);
        this.replaceBiomes(primer);
        this.replaceBlocksForBiomeOlder(x, z, primer, biomesForGeneration);
        if (ChunkGeneratorBeta.settings.useOldCaves) {
            new MapGenCaves().generate(this.worldObj, x, z, primer);
        } else {
            this.caveGenerator.func_186125_a(this.worldObj, x, z, primer);
        }
        if (ChunkGeneratorBeta.settings.useRavines) {
            this.ravineGenerator.func_186125_a(this.worldObj, x, z, primer);
        }
        Chunk chunk = new Chunk(this.worldObj, primer, x, z);
        byte[] biomes = chunk.func_76605_m();
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i] = (byte)Biome.func_185362_a((Biome)biomesForGeneration[(i & 0xF) << 4 | i >> 4 & 0xF]);
        }
        if (ChunkGeneratorBeta.settings.useMineShafts) {
            this.mineshaftGenerator.func_186125_a(this.worldObj, x, z, primer);
        }
        if (ChunkGeneratorBeta.settings.useStrongholds) {
            this.strongholdGenerator.func_186125_a(this.worldObj, x, z, primer);
        }
        if (ChunkGeneratorBeta.settings.useTemples) {
            this.desertPyramidGenerator.func_186125_a(this.worldObj, x, z, primer);
            this.junglePyramidGenerator.func_186125_a(this.worldObj, x, z, primer);
            this.iglooGenerator.func_186125_a(this.worldObj, x, z, primer);
            this.swampHutGenerator.func_186125_a(this.worldObj, x, z, primer);
        }
        if (ChunkGeneratorBeta.settings.useVillages) {
            this.villageGenerator.func_186125_a(this.worldObj, x, z, primer);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        int addY;
        int posX = x * 16;
        int posZ = z * 16;
        BlockPos blockPos = new BlockPos(posX, 0, posZ);
        Biome biomeAtPos = this.worldObj.func_180494_b(blockPos.func_177982_a(16, 0, 16));
        ChunkPos cPos = new ChunkPos(x, z);
        biomeAtPos.func_180624_a(this.worldObj, this.rand, blockPos);
        WorldGenSnowLayerBeta.generateSnow(this.worldObj, cPos);
        if (ChunkGeneratorBeta.settings.useDungeons) {
            WorldGenDungeons.generateDungeons(this.worldObj, this.rand, blockPos);
        }
        if (ChunkGeneratorBeta.settings.useMineShafts) {
            this.mineshaftGenerator.func_175794_a(this.worldObj, this.rand, cPos);
        }
        if (ChunkGeneratorBeta.settings.useStrongholds) {
            this.strongholdGenerator.func_175794_a(this.worldObj, this.rand, cPos);
        }
        if (ChunkGeneratorBeta.settings.useTemples) {
            this.desertPyramidGenerator.func_175794_a(this.worldObj, this.rand, cPos);
            this.junglePyramidGenerator.func_175794_a(this.worldObj, this.rand, cPos);
            this.iglooGenerator.func_175794_a(this.worldObj, this.rand, cPos);
            this.swampHutGenerator.func_175794_a(this.worldObj, this.rand, cPos);
        }
        if (ChunkGeneratorBeta.settings.useVillages) {
            this.villageGenerator.func_175794_a(this.worldObj, this.rand, cPos);
        }
        if (biomeAtPos != Biomes.field_76769_d && biomeAtPos != Biomes.field_76786_s && this.rand.nextInt(ChunkGeneratorBeta.settings.waterLakeChance) == 0 && ChunkGeneratorBeta.settings.useWaterLakes) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.rand, blockPos.func_177982_a(i1, j1, k1));
        }
        if ((addY = this.rand.nextInt(this.rand.nextInt(248) + 8)) < this.worldObj.func_181545_F() - 2 || this.rand.nextInt(ChunkGeneratorBeta.settings.lavaLakeChance) == 0 && ChunkGeneratorBeta.settings.useLavaLakes) {
            int addX = this.rand.nextInt(16) + 8;
            int addZ = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, blockPos.func_177982_a(addX, addY, addZ));
        }
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biomeAtPos, (int)(posX + 8), (int)(posZ + 8), (int)16, (int)16, (Random)this.rand);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.worldObj.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null && ChunkGeneratorBeta.settings.useStrongholds) {
            return this.strongholdGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Pyramid".equals(structureName) && this.desertPyramidGenerator != null && ChunkGeneratorBeta.settings.useTemples) {
            return this.desertPyramidGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Jungle_Temple".equals(structureName) && this.junglePyramidGenerator != null && ChunkGeneratorBeta.settings.useTemples) {
            return this.junglePyramidGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Igloo".equals(structureName) && this.iglooGenerator != null && ChunkGeneratorBeta.settings.useTemples) {
            return this.iglooGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Swamp_Hut".equals(structureName) && this.swampHutGenerator != null && ChunkGeneratorBeta.settings.useTemples) {
            return this.swampHutGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null && ChunkGeneratorBeta.settings.useVillages) {
            return this.villageGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer chunk) {
        int four = 4;
        int var8 = four + 1;
        int seventeen = 17;
        int fiver = four + 1;
        this.heightNoise = this.octaveGenerator(this.heightNoise, chunkX * four, chunkZ * four, var8, seventeen, fiver);
        for (int i = 0; i < four; ++i) {
            for (int j = 0; j < four; ++j) {
                for (int k = 0; k < 16; ++k) {
                    double var14 = 0.125;
                    double var16 = this.heightNoise[(i * fiver + j) * seventeen + k];
                    double var18 = this.heightNoise[(i * fiver + j + 1) * seventeen + k];
                    double var20 = this.heightNoise[((i + 1) * fiver + j) * seventeen + k];
                    double var22 = this.heightNoise[((i + 1) * fiver + j + 1) * seventeen + k];
                    double var24 = (this.heightNoise[(i * fiver + j) * seventeen + k + 1] - var16) * var14;
                    double var26 = (this.heightNoise[(i * fiver + j + 1) * seventeen + k + 1] - var18) * var14;
                    double var28 = (this.heightNoise[((i + 1) * fiver + j) * seventeen + k + 1] - var20) * var14;
                    double var30 = (this.heightNoise[((i + 1) * fiver + j + 1) * seventeen + k + 1] - var22) * var14;
                    for (int l = 0; l < 8; ++l) {
                        double quarter = 0.25;
                        double var35 = var16;
                        double var37 = var18;
                        double var39 = (var20 - var16) * quarter;
                        double var41 = (var22 - var18) * quarter;
                        for (int m = 0; m < 4; ++m) {
                            int x = m + i * 4;
                            int y = k * 8 + l;
                            int z = j * 4;
                            double var46 = 0.25;
                            double var48 = var35;
                            double var50 = (var37 - var35) * var46;
                            for (int n = 0; n < 4; ++n) {
                                BlockStaticLiquid block = null;
                                if (k * 8 + l < 64) {
                                    block = Blocks.field_150355_j;
                                }
                                if (var48 > 0.0) {
                                    block = Blocks.field_150348_b;
                                }
                                if (block != null) {
                                    chunk.func_177855_a(x, y, z, block.func_176223_P());
                                }
                                ++z;
                                var48 += var50;
                            }
                            var35 += var39;
                            var37 += var41;
                        }
                        var16 += var24;
                        var18 += var26;
                        var20 += var28;
                        var22 += var30;
                    }
                }
            }
        }
    }

    private double[] octaveGenerator(double[] values, int var2, int var4, int var5, int var6, int var7) {
        if (values == null) {
            values = new double[var5 * var6 * var7];
        }
        double noiseFactor = 684.412;
        double[] temps = this.biomeProvider.temperatures;
        double[] humidities = this.biomeProvider.humidities;
        this.octaveArr4 = this.octaves6.generateNoiseOctaves(this.octaveArr4, var2, var4, var5, var7, 1.121, 1.121, 0.5);
        this.octaveArr5 = this.octaves7.generateNoiseOctaves(this.octaveArr5, var2, var4, var5, var7, 200.0, 200.0, 0.5);
        this.octaveArr1 = this.octaves3.generateNoiseOctaves(this.octaveArr1, var2, 0.0, var4, var5, var6, var7, noiseFactor / 80.0, noiseFactor / 160.0, noiseFactor / 80.0);
        this.octaveArr2 = this.octaves1.generateNoiseOctaves(this.octaveArr2, var2, 0.0, var4, var5, var6, var7, noiseFactor, noiseFactor, noiseFactor);
        this.octaveArr3 = this.octaves2.generateNoiseOctaves(this.octaveArr3, var2, 0.0, var4, var5, var6, var7, noiseFactor, noiseFactor, noiseFactor);
        int incrementer1 = 0;
        int incrementer2 = 0;
        int var16 = 16 / var5;
        for (int i = 0; i < var5; ++i) {
            int var18 = i * var16 + var16 / 2;
            for (int j = 0; j < var7; ++j) {
                double d;
                double d2;
                double d3;
                int var20 = j * var16 + var16 / 2;
                double var21 = temps[var18 * 16 + var20];
                double var23 = humidities[var18 * 16 + var20] * var21;
                double var25 = 1.0 - var23;
                var25 *= var25;
                var25 *= var25;
                var25 = 1.0 - var25;
                double var27 = (this.octaveArr4[incrementer2] + 256.0) / 512.0;
                var27 *= var25;
                if (d3 > 1.0) {
                    var27 = 1.0;
                }
                double var29 = this.octaveArr5[incrementer2] / 8000.0;
                if (d2 < 0.0) {
                    var29 = -var29 * 0.3;
                }
                var29 = var29 * 3.0 - 2.0;
                if (d < 0.0) {
                    double d4;
                    var29 /= 2.0;
                    if (d4 < -1.0) {
                        var29 = -1.0;
                    }
                    var29 /= 1.4;
                    var29 /= 2.0;
                    var27 = 0.0;
                } else {
                    if (var29 > 1.0) {
                        var29 = 1.0;
                    }
                    var29 /= 8.0;
                }
                if (var27 < 0.0) {
                    var27 = 0.0;
                }
                var27 += 0.5;
                var29 = var29 * (double)var6 / 16.0;
                double var31 = (double)var6 / 2.0 + var29 * 4.0;
                ++incrementer2;
                for (int k = 0; k < var6; ++k) {
                    double var36 = ((double)k - var31) * 12.0 / var27;
                    if (var36 < 0.0) {
                        var36 *= 4.0;
                    }
                    double var38 = this.octaveArr2[incrementer1] / 512.0;
                    double var40 = this.octaveArr3[incrementer1] / 512.0;
                    double var42 = (this.octaveArr1[incrementer1] / 10.0 + 1.0) / 2.0;
                    double var34 = var42 < 0.0 ? var38 : (var42 > 1.0 ? var40 : var38 + (var40 - var38) * var42);
                    var34 -= var36;
                    if (k > var6 - 4) {
                        double var44 = (float)(k - (var6 - 4)) / 3.0f;
                        var34 = var34 * (1.0 - var44) + -10.0 * var44;
                    }
                    values[incrementer1] = var34;
                    ++incrementer1;
                }
            }
        }
        return values;
    }

    public void replaceBlocksForBiomeOlder(int chunkX, int chunkZ, ChunkPrimer chunkPrimer, Biome[] biomes) {
        double thirtySecond = 0.03125;
        this.sandNoise = this.octaves4.generateNoiseOctaves(this.sandNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, thirtySecond, thirtySecond, 1.0);
        this.gravelNoise = this.octaves4.generateNoiseOctaves(this.gravelNoise, chunkX * 16, 109.0134, chunkZ * 16, 16, 1, 16, thirtySecond, 1.0, thirtySecond);
        this.stoneNoise = this.octaves5.generateNoiseOctaves(this.stoneNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, thirtySecond * 2.0, thirtySecond * 2.0, thirtySecond * 2.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Biome biome = biomes[z + x * 16];
                boolean sandN = this.sandNoise[z + x * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean gravelN = this.gravelNoise[z + x * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int stoneN = (int)(this.stoneNoise[z + x * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int checkVal = -1;
                IBlockState topBlock = biome.field_76752_A;
                IBlockState fillerBlock = biome.field_76753_B;
                for (int y = 127; y >= 0; --y) {
                    if (y <= this.rand.nextInt(5)) {
                        chunkPrimer.func_177855_a(x, y, z, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    Block block = chunkPrimer.func_177856_a(x, y, z).func_177230_c();
                    if (block == Blocks.field_150350_a) {
                        checkVal = -1;
                        continue;
                    }
                    if (block != Blocks.field_150348_b) continue;
                    if (checkVal == -1) {
                        if (stoneN <= 0) {
                            topBlock = Blocks.field_150350_a.func_176223_P();
                            fillerBlock = Blocks.field_150348_b.func_176223_P();
                        } else if (y >= 60 && y <= 65) {
                            topBlock = biome.field_76752_A;
                            fillerBlock = biome.field_76753_B;
                            if (gravelN) {
                                topBlock = Blocks.field_150350_a.func_176223_P();
                            }
                            if (gravelN) {
                                fillerBlock = Blocks.field_150351_n.func_176223_P();
                            }
                            if (sandN) {
                                topBlock = Blocks.field_150354_m.func_176223_P();
                            }
                            if (sandN) {
                                fillerBlock = Blocks.field_150354_m.func_176223_P();
                            }
                        }
                        if (y < 64 && topBlock == Blocks.field_150350_a.func_176223_P()) {
                            topBlock = Blocks.field_150355_j.func_176223_P();
                        }
                        if (y < 65 && y > 61 && (topBlock == Blocks.field_150354_m.func_176223_P() || fillerBlock == Blocks.field_150351_n.func_176223_P()) && biomesForGeneration[x << 4 | z] != Biomes.field_76769_d && biomesForGeneration[x << 4 | z] != Biomes.field_76780_h) {
                            ChunkGeneratorBeta.biomesForGeneration[x << 4 | z] = Biomes.field_76787_r;
                        }
                        checkVal = stoneN;
                        if (y >= 63) {
                            if (biome == Biomes.field_150589_Z) {
                                if (y > 65) {
                                    topBlock = MesaBetaHelper.getBand(x, y, z, this.worldObj.func_72905_C());
                                } else {
                                    topBlock = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
                                    fillerBlock = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
                                }
                            }
                            chunkPrimer.func_177855_a(x, y, z, topBlock);
                            continue;
                        }
                        chunkPrimer.func_177855_a(x, y, z, fillerBlock);
                        continue;
                    }
                    if (biome == Biomes.field_150589_Z) {
                        fillerBlock = MesaBetaHelper.getBand(x, y + 1, z, this.worldObj.func_72905_C());
                    }
                    if (checkVal <= 0) continue;
                    chunkPrimer.func_177855_a(x, y, z, fillerBlock);
                    if (--checkVal != 0 || fillerBlock != Blocks.field_150354_m) continue;
                    checkVal = this.rand.nextInt(4);
                    fillerBlock = Blocks.field_150322_A.func_176223_P();
                }
            }
        }
    }

    private void replaceBiomes(ChunkPrimer primer) {
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int yVal = ChunkGeneratorBeta.getSolidHeightY(x, z, primer);
                if (yVal > 116) {
                    ChunkGeneratorBeta.biomesForGeneration[x << 4 | z] = Biomes.field_150580_W;
                    continue;
                }
                if (yVal >= 62) continue;
                ChunkGeneratorBeta.biomesForGeneration[x << 4 | z] = yVal < 64 - ChunkGeneratorBeta.settings.seaDepth ? Biomes.field_150575_M : Biomes.field_76771_b;
            }
        }
    }

    private static int getSolidHeightY(int x, int z, ChunkPrimer primer) {
        for (int y = 130; y >= 0; --y) {
            Block block = primer.func_177856_a(x, y, z).func_177230_c();
            if (block == Blocks.field_150350_a || !block.func_176223_P().func_185914_p()) continue;
            return y;
        }
        return 0;
    }
}

