/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus.beta;

import com.mrburgerUS.betaplus.beta.biome.BiomeGenBeta;
import com.mrburgerUS.betaplus.beta.biome.support.SupportBiome;
import com.mrburgerUS.betaplus.beta.noise.NoiseGeneratorOctavesOld;
import com.mrburgerUS.betaplus.beta.noise.PerlinNoise;
import com.mrburgerUS.betaplus.beta.noise.VoronoiNoiseGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public class BiomeProviderBeta
extends BiomeProvider {
    private NoiseGeneratorOctavesOld octave1;
    private NoiseGeneratorOctavesOld octave2;
    private NoiseGeneratorOctavesOld octave3;
    public double[] temperatures;
    public double[] humidities;
    public double[] noise;
    public Biome[] biomeBaseArray;
    public final int biomeSetting;
    public static ArrayList<Biome> snowBiomesList = new ArrayList();
    public static ArrayList<Biome> coldBiomesList = new ArrayList();
    public static ArrayList<Biome> hotBiomesList = new ArrayList();
    public static ArrayList<Biome> wetBiomesList = new ArrayList();
    public static ArrayList<Biome> smallBiomesList = new ArrayList();
    PerlinNoise perlinNoise;
    VoronoiNoiseGenerator voronoiNoise;

    public BiomeProviderBeta(World world, int biomeType) {
        this.octave1 = new NoiseGeneratorOctavesOld(new Random(world.func_72905_C() * 9871L), 4);
        this.octave2 = new NoiseGeneratorOctavesOld(new Random(world.func_72905_C() * 39811L), 4);
        this.octave3 = new NoiseGeneratorOctavesOld(new Random(world.func_72905_C() * 543321L), 2);
        this.biomeSetting = biomeType;
        this.perlinNoise = new PerlinNoise(world.func_72905_C());
        this.voronoiNoise = new VoronoiNoiseGenerator(world.func_72905_C(), 0);
        if (this.biomeSetting == 1) {
            snowBiomesList.addAll(SupportBiome.snowBiomes);
            coldBiomesList.addAll(SupportBiome.coldBiomes);
            hotBiomesList.addAll(SupportBiome.hotBiomes);
            wetBiomesList.addAll(SupportBiome.wetBiomes);
        }
    }

    public Biome[] findBiomeArray(int xPos, int zPos, int width, int depth) {
        this.biomeBaseArray = this.func_76937_a(this.biomeBaseArray, xPos, zPos, width, depth);
        return this.biomeBaseArray;
    }

    public List<Biome> func_76932_a() {
        return null;
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.findBiomeArray(pos.func_177958_n(), pos.func_177952_p(), 1, 1)[0];
    }

    public Biome[] func_76937_a(Biome[] biomeBases, int xChunk, int zChunk, int width, int height) {
        if (biomeBases == null || biomeBases.length < width * height) {
            biomeBases = new Biome[width * height];
        }
        this.temperatures = this.octave1.generateOctaves(this.temperatures, xChunk, zChunk, width, width, 0.025f, 0.025f, 0.25);
        this.humidities = this.octave2.generateOctaves(this.humidities, xChunk, zChunk, width, width, 0.05f, 0.05f, 0.3333333333333333);
        this.noise = this.octave3.generateOctaves(this.noise, xChunk, zChunk, width, width, 0.25, 0.25, 0.5882352941176471);
        int counter = 0;
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                double var9 = this.noise[counter] * 1.1 + 0.5;
                double oneHundredth = 0.01;
                double point99 = 1.0 - oneHundredth;
                double temperatureVal = (this.temperatures[counter] * 0.15 + 0.7) * point99 + var9 * oneHundredth;
                oneHundredth = 0.002;
                point99 = 1.0 - oneHundredth;
                double humidityVal = (this.humidities[counter] * 0.15 + 0.5) * point99 + var9 * oneHundredth;
                temperatureVal = 1.0 - (1.0 - temperatureVal) * (1.0 - temperatureVal);
                temperatureVal = MathHelper.func_151237_a((double)temperatureVal, (double)0.0, (double)1.0);
                humidityVal = MathHelper.func_151237_a((double)humidityVal, (double)0.0, (double)1.0);
                this.temperatures[counter] = temperatureVal;
                this.humidities[counter] = humidityVal;
                biomeBases[counter++] = BiomeGenBeta.getBiomeFromLookup(temperatureVal, humidityVal);
            }
        }
        if (this.biomeSetting == 1) {
            float scaleFactor = 30.0f;
            int counter2 = 0;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    float offsetX = this.perlinNoise.noise2((float)(xChunk + x) / scaleFactor, (float)(zChunk + z) / scaleFactor) * 80.0f + this.perlinNoise.noise2((xChunk + x) / 7, (zChunk + z) / 7) * 20.0f;
                    float offsetZ = this.perlinNoise.noise2((float)(xChunk + x) / scaleFactor, (float)(zChunk + z) / scaleFactor) * 80.0f + this.perlinNoise.noise2((xChunk + x - 1000) / 7, (xChunk + x) / 7) * 20.0f;
                    double vNoise = this.voronoiNoise.noise((double)((float)(xChunk + x) + offsetX + 1000.0f) / 1000.0, (double)((float)(zChunk + z) - offsetZ) / 1000.0, 1.0) * 0.5 + 0.5;
                    double randomSelect = this.voronoiNoise.noise(((float)(xChunk + x) + offsetX + 2000.0f) / 180.0f, ((float)(zChunk + z) - offsetZ) / 180.0f, 1.0) * 0.5 + 0.5;
                    randomSelect = MathHelper.func_151237_a((double)randomSelect, (double)0.0, (double)0.9999999);
                    biomeBases[counter2++] = vNoise < 0.25 ? snowBiomesList.get((int)(randomSelect *= (double)snowBiomesList.size())) : (vNoise < 0.5 ? coldBiomesList.get((int)(randomSelect *= (double)coldBiomesList.size())) : (vNoise < 0.75 ? hotBiomesList.get((int)(randomSelect *= (double)hotBiomesList.size())) : wetBiomesList.get((int)(randomSelect *= (double)wetBiomesList.size()))));
                }
            }
        }
        return biomeBases;
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        return this.findBiomeArray(x, z, width, length);
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        return false;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        return null;
    }

    public boolean func_190944_c() {
        return false;
    }

    public int getGrassColor(BlockPos blockPos) {
        this.findBiomeArray(blockPos.func_177958_n(), blockPos.func_177952_p(), 1, 1);
        double temperature = this.temperatures[0];
        double humidity = this.humidities[0];
        if (temperature > 1.0) {
            temperature = 1.0;
        } else if (temperature < 0.0) {
            temperature = 0.0;
        }
        if (humidity > 1.0) {
            humidity = 1.0;
        } else if (humidity < 0.0) {
            humidity = 0.0;
        }
        return ColorizerGrass.func_77480_a((double)temperature, (double)humidity);
    }

    public int getGrassColor2(BlockPos pos) {
        this.noise = this.octave3.generateOctaves(this.noise, pos.func_177958_n(), pos.func_177952_p(), 1, 1, 0.025, 0.025, 0.5882352941176471);
        double d1 = this.noise[0] * 1.1 + 0.5;
        this.noise = this.octave1.generateOctaves(this.noise, pos.func_177958_n(), pos.func_177952_p(), 1, 1, 0.025, 0.025, 0.25);
        double d2 = 0.01;
        double d3 = 1.0 - d2;
        double temperature = (this.noise[0] * 0.15 + 0.7) * d3 + d1 * d2;
        this.noise = this.octave2.generateOctaves(this.noise, pos.func_177958_n(), pos.func_177952_p(), 1, 1, 0.05, 0.05, 0.3333333333333333);
        d2 = 0.002;
        d3 = 1.0 - d2;
        double humidity = (this.noise[0] * 0.15 + 0.5) * d3 + d1 * d2;
        temperature = 1.0 - (1.0 - temperature) * (1.0 - temperature);
        temperature = MathHelper.func_151237_a((double)temperature, (double)0.0, (double)1.0);
        humidity = MathHelper.func_151237_a((double)humidity, (double)0.0, (double)1.0);
        return ColorizerGrass.func_77480_a((double)temperature, (double)humidity);
    }
}

