/*
 * Decompiled with CFR 0.152.
 */
package com.mrburgerUS.betaplus;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.util.JsonUtils;

public class BetaPlusSettings {
    public final boolean useDungeons;
    public final int dungeonChance;
    public final boolean useMineShafts;
    public final boolean useStrongholds;
    public final boolean useVillages;
    public final boolean useTemples;
    public final int maxDistanceBetweenPyramids;
    public final boolean useRavines;
    public final boolean useWaterLakes;
    public final int waterLakeChance;
    public final boolean useLavaLakes;
    public final int lavaLakeChance;
    public final int seaDepth;
    public final boolean useOldCaves;
    public final int generatorType;

    private BetaPlusSettings(Factory settingsFactory) {
        this.useDungeons = settingsFactory.useDungeons;
        this.dungeonChance = settingsFactory.dungeonChance;
        this.useMineShafts = settingsFactory.useMineShafts;
        this.useStrongholds = settingsFactory.useStrongholds;
        this.useTemples = settingsFactory.useTemples;
        this.maxDistanceBetweenPyramids = settingsFactory.maxDistanceBetweenPyramids;
        this.useRavines = settingsFactory.useRavines;
        this.useWaterLakes = settingsFactory.useWaterLakes;
        this.waterLakeChance = settingsFactory.waterLakeChance;
        this.useLavaLakes = settingsFactory.useLavaLakes;
        this.lavaLakeChance = settingsFactory.lavaLakeChance;
        this.seaDepth = settingsFactory.seaDepth;
        this.useVillages = settingsFactory.useVillages;
        this.useOldCaves = settingsFactory.useOldCaves;
        this.generatorType = settingsFactory.generatorType;
    }

    public static class SerializerBeta
    implements JsonDeserializer<Factory>,
    JsonSerializer<Factory> {
        public Factory deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = jsonElement.getAsJsonObject();
            Factory betaPlusFactory = new Factory();
            try {
                betaPlusFactory.useOldCaves = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"useOldCaves", (boolean)betaPlusFactory.useOldCaves);
                betaPlusFactory.useDungeons = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"useDungeons", (boolean)betaPlusFactory.useDungeons);
                betaPlusFactory.dungeonChance = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"dungeonChance", (int)betaPlusFactory.dungeonChance);
                betaPlusFactory.useStrongholds = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"useStrongholds", (boolean)betaPlusFactory.useStrongholds);
                betaPlusFactory.useMineShafts = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"useMineShafts", (boolean)betaPlusFactory.useMineShafts);
                betaPlusFactory.useTemples = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"useTemples", (boolean)betaPlusFactory.useTemples);
                betaPlusFactory.useRavines = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"useRavines", (boolean)betaPlusFactory.useRavines);
                betaPlusFactory.useWaterLakes = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"useWaterLakes", (boolean)betaPlusFactory.useWaterLakes);
                betaPlusFactory.waterLakeChance = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"waterLakeChance", (int)betaPlusFactory.waterLakeChance);
                betaPlusFactory.useLavaLakes = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"useLavaLakes", (boolean)betaPlusFactory.useLavaLakes);
                betaPlusFactory.lavaLakeChance = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"lavaLakeChance", (int)betaPlusFactory.lavaLakeChance);
                betaPlusFactory.generatorType = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"generatorType", (int)betaPlusFactory.generatorType);
            }
            catch (Exception e) {
                System.out.println("ERROR Parsing");
            }
            return betaPlusFactory;
        }

        public JsonElement serialize(Factory factory, Type type, JsonSerializationContext co) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("useOldCaves", Boolean.valueOf(factory.useOldCaves));
            jsonobject.addProperty("generatorType", (Number)factory.generatorType);
            jsonobject.addProperty("useDungeons", Boolean.valueOf(factory.useDungeons));
            jsonobject.addProperty("dungeonChance", (Number)factory.dungeonChance);
            jsonobject.addProperty("useStrongholds", Boolean.valueOf(factory.useStrongholds));
            jsonobject.addProperty("useMineShafts", Boolean.valueOf(factory.useMineShafts));
            jsonobject.addProperty("useTemples", Boolean.valueOf(factory.useTemples));
            jsonobject.addProperty("useRavines", Boolean.valueOf(factory.useRavines));
            jsonobject.addProperty("useWaterLakes", Boolean.valueOf(factory.useWaterLakes));
            jsonobject.addProperty("waterLakeChance", (Number)factory.waterLakeChance);
            jsonobject.addProperty("useLavaLakes", Boolean.valueOf(factory.useLavaLakes));
            jsonobject.addProperty("lavaLakeChance", (Number)factory.lavaLakeChance);
            return jsonobject;
        }
    }

    public static class Factory {
        @VisibleForTesting
        static final Gson JSON_ADAPTER = new GsonBuilder().registerTypeAdapter(Factory.class, (Object)new SerializerBeta()).create();
        public boolean useDungeons = true;
        public int dungeonChance = 8;
        public boolean useMineShafts = true;
        public boolean useStrongholds = true;
        public boolean useTemples = true;
        public int maxDistanceBetweenPyramids = 20;
        public boolean useRavines = true;
        public boolean useWaterLakes = true;
        public int waterLakeChance = 20;
        public boolean useLavaLakes = true;
        public int lavaLakeChance = 256;
        public int seaDepth = 7;
        public boolean useVillages = true;
        public boolean useOldCaves = false;
        public int generatorType = 0;

        public Factory() {
            this.setDefaults();
        }

        public static Factory jsonToSettings(String options) {
            if (options.isEmpty()) {
                return new Factory();
            }
            try {
                return (Factory)JsonUtils.func_188178_a((Gson)JSON_ADAPTER, (String)options, Factory.class);
            }
            catch (Exception e) {
                System.out.println("EXCEPTION WITH WORLD OPTIONS");
                return new Factory();
            }
        }

        public void setDefaults() {
            this.useDungeons = true;
            this.dungeonChance = 8;
            this.useMineShafts = true;
            this.useStrongholds = true;
            this.useTemples = true;
            this.maxDistanceBetweenPyramids = 24;
            this.useRavines = true;
            this.useWaterLakes = true;
            this.waterLakeChance = 20;
            this.useLavaLakes = true;
            this.lavaLakeChance = 256;
            this.seaDepth = 7;
            this.useVillages = true;
            this.useOldCaves = false;
            this.generatorType = 0;
        }

        public String toString() {
            return JSON_ADAPTER.toJson((Object)this);
        }

        public BetaPlusSettings build() {
            return new BetaPlusSettings(this);
        }
    }
}

