/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.mapgen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class MistRavineGen
extends MapGenBase {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final float[] multipliers = new float[1024];

    protected void addTunnel(long caveSeed, int chunkX, int chunkZ, ChunkPrimer chunkPrimer, double randX, double randY, double randZ, float caveSize, float randPI, float angleToGenerate, int loopOne, int loopEnd, double yScale, double width) {
        Random random = new Random(caveSeed);
        Random randomErosion = new Random(1234L);
        double centerX = chunkX * 16 + 8;
        double centerZ = chunkZ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        if (loopEnd <= 0) {
            int i = this.field_75040_a * 16 - 16;
            loopEnd = i - random.nextInt(i / 4);
        }
        boolean shouldStop = false;
        if (loopOne == -1) {
            loopOne = loopEnd / 2;
            shouldStop = true;
        }
        float f2 = 1.0f;
        for (int j = 0; j < 256; ++j) {
            if (j == 0 || random.nextInt(3) == 0) {
                f2 = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.multipliers[j] = f2 * f2;
        }
        while (loopOne < loopEnd) {
            double sizeXZ = width + (double)(MathHelper.func_76126_a((float)((float)loopOne * (float)Math.PI / (float)loopEnd)) * caveSize);
            double sizeY = sizeXZ * yScale;
            sizeXZ *= (double)random.nextFloat() * 0.25 + 0.75;
            sizeY *= (double)random.nextFloat() * 0.25 + 0.75;
            float cosAngle = MathHelper.func_76134_b((float)angleToGenerate);
            float sinAngle = MathHelper.func_76126_a((float)angleToGenerate);
            randY += (double)sinAngle;
            boolean isUp = this.field_75039_c.func_180494_b(new BlockPos(randX += (double)(MathHelper.func_76134_b((float)randPI) * cosAngle), 0.0, randZ += (double)(MathHelper.func_76126_a((float)randPI) * cosAngle))) instanceof BiomeMistUp;
            if (!isUp && randY - sizeY < 31.0) {
                randY = 26.0 + sizeY + 4.0 + (double)randomErosion.nextInt(3);
            }
            angleToGenerate *= 0.7f;
            angleToGenerate += f1 * 0.05f;
            randPI += f * 0.05f;
            f1 *= 0.8f;
            f *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (shouldStop || random.nextInt(4) != 0) {
                double distX = randX - centerX;
                double distZ = randZ - centerZ;
                double d5 = loopEnd - loopOne;
                double sizeSixteen = caveSize + 2.0f + 16.0f;
                if (distX * distX + distZ * distZ - d5 * d5 > sizeSixteen * sizeSixteen) {
                    return;
                }
                if (randX >= centerX - 16.0 - sizeXZ * 2.0 && randZ >= centerZ - 16.0 - sizeXZ * 2.0 && randX <= centerX + 16.0 + sizeXZ * 2.0 && randZ <= centerZ + 16.0 + sizeXZ * 2.0) {
                    int genX;
                    int minX = MathHelper.func_76128_c((double)(randX - sizeXZ)) - chunkX * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(randX + sizeXZ)) - chunkX * 16 + 1;
                    int minY = MathHelper.func_76128_c((double)(randY - sizeY)) - 1;
                    int maxY = MathHelper.func_76128_c((double)(randY + sizeY)) + 1;
                    int minZ = MathHelper.func_76128_c((double)(randZ - sizeXZ)) - chunkZ * 16 - 1;
                    int maxZ = MathHelper.func_76128_c((double)(randZ + sizeXZ)) - chunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < 26 + (isUp ? 1 : 5)) {
                        minY = 26 + (isUp ? 1 : 5);
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    boolean hasHitWater = false;
                    for (genX = minX; !hasHitWater && genX < maxX; ++genX) {
                        for (int genZ = minZ; !hasHitWater && genZ < maxZ; ++genZ) {
                            for (int genY = maxY + 1; !hasHitWater && genY >= minY - 1; --genY) {
                                if (genY < 0 || genY >= 256) continue;
                                if (this.isOceanBlock(chunkPrimer, genX, genY, genZ, chunkX, chunkZ)) {
                                    hasHitWater = true;
                                }
                                if (genY == minY - 1 || genX == minX || genX == maxX - 1 || genZ == minZ || genZ == maxZ - 1) continue;
                                genY = minY;
                            }
                        }
                    }
                    if (!hasHitWater) {
                        for (genX = minX; genX < maxX; ++genX) {
                            double d10 = ((double)(genX + chunkX * 16) + 0.5 - randX) / sizeXZ;
                            for (int genZ = minZ; genZ < maxZ; ++genZ) {
                                double d7 = ((double)(genZ + chunkZ * 16) + 0.5 - randZ) / sizeXZ;
                                boolean hitGrass = false;
                                if (!(d10 * d10 + d7 * d7 < 1.0)) continue;
                                for (int genY = maxY; genY > minY; --genY) {
                                    double d8 = ((double)(genY - 1) + 0.5 - randY) / sizeY;
                                    if (!((d10 * d10 + d7 * d7) * (double)this.multipliers[genY - 1] + d8 * d8 / 6.0 < 1.0)) continue;
                                    if (this.isTopBlock(chunkPrimer, genX, genY, genZ, chunkX, chunkZ)) {
                                        hitGrass = true;
                                    }
                                    this.digBlock(chunkPrimer, genX, genY, genZ, chunkX, chunkZ, hitGrass, randomErosion, isUp);
                                }
                            }
                        }
                        if (shouldStop) break;
                    }
                }
            }
            ++loopOne;
        }
    }

    protected void func_180701_a(World world, int genX, int genZ, int chunkX, int chunkZ, ChunkPrimer chunkPrimer) {
        if (this.field_75038_b.nextInt(50) == 0) {
            Biome biome = world.func_180494_b(new BlockPos(genX + chunkX * 16, 0, genZ + chunkZ * 16));
            double randX = genX * 16 + this.field_75038_b.nextInt(16);
            double randY = this.field_75038_b.nextInt(this.field_75038_b.nextInt(120) + 8) + 30;
            double randZ = genZ * 16 + this.field_75038_b.nextInt(16);
            double width = 1.0;
            if (biome instanceof BiomeMistUp) {
                width = 1.5;
            }
            int numberOfNormalNodes = 1;
            for (int j = 0; j < numberOfNormalNodes; ++j) {
                float randPi = this.field_75038_b.nextFloat() * ((float)Math.PI * 2);
                float angleToGenerate = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float caveSize = (this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat()) * 2.0f;
                this.addTunnel(this.field_75038_b.nextLong(), chunkX, chunkZ, chunkPrimer, randX, randY, randZ, caveSize, randPi, angleToGenerate, 0, 0, 3.0, width);
            }
        }
    }

    protected boolean isOceanBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        IBlockState state = data.func_177856_a(x, y, z);
        return (state == MistWorld.waterBlockUpper || state == MistWorld.waterBlockLower) && y != 28;
    }

    private boolean isExceptionBiome(Biome biome) {
        return false;
    }

    private boolean isTopBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState state = data.func_177856_a(x, y, z);
        return state == biome.field_76752_A;
    }

    protected boolean canReplaceBlock(IBlockState state) {
        return state == MistWorld.worldStone || state == MistWorld.stoneBlockUpper || state.func_177230_c() instanceof IWettable || state.func_177230_c() == Blocks.field_150431_aC || state == MistWorld.gravelBlock;
    }

    protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, Random rand, boolean isUp) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState state = data.func_177856_a(x, y, z);
        IBlockState top = biome.field_76752_A;
        IBlockState filler = biome.field_76753_B;
        if (!(!this.canReplaceBlock(state) && state != top && state != filler || y <= 112 && data.func_177856_a(x, y + 1, z) == MistWorld.gravelBlock)) {
            if (y == 28) {
                data.func_177855_a(x, y, z, MistWorld.waterBlockLower);
                if (data.func_177856_a(x, y - 1, z) == MistWorld.worldStone) {
                    data.func_177855_a(x, y - 1, z, MistWorld.gravelBlock);
                }
            } else {
                data.func_177855_a(x, y, z, AIR);
                if (y > 28 && rand.nextInt(2) == 0) {
                    if (!isUp && data.func_177856_a(x, y - 1, z) == MistWorld.gravelBlock) {
                        data.func_177855_a(x, y - 1, z, AIR);
                    }
                    if (rand.nextInt(4) == 0) {
                        if (data.func_177856_a(x, y - 1, z) == MistWorld.worldStone && y - 1 != 28) {
                            data.func_177855_a(x, y - 1, z, AIR);
                        }
                        if (!this.isOceanBlock(data, x, y + 1, z, chunkX, chunkZ)) {
                            data.func_177855_a(x, y + 1, z, AIR);
                        }
                    } else {
                        if (data.func_177856_a(x, y - 1, z) == MistWorld.worldStone) {
                            data.func_177855_a(x, y - 1, z, MistWorld.gravelBlock);
                        }
                        if (data.func_177856_a(x, y + 1, z) == MistWorld.worldStone) {
                            data.func_177855_a(x, y + 1, z, MistWorld.gravelBlock);
                        }
                    }
                }
                if (foundTop && data.func_177856_a(x, y - 1, z).func_177230_c() == filler.func_177230_c()) {
                    data.func_177855_a(x, y - 1, z, top.func_177230_c().func_176223_P());
                }
            }
        }
    }
}

