/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.mapgen;

import com.google.common.base.MoreObjects;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class MistCavesGen
extends MapGenBase {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();

    protected void addRoom(long caveSeed, int chunkX, int chunkZ, ChunkPrimer chunkPrimer, double randX, double randY, double randZ) {
        this.addTunnel(caveSeed, chunkX, chunkZ, chunkPrimer, randX, randY, randZ, 1.0f + this.field_75038_b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5, 2.5);
    }

    protected void addTunnel(long caveSeed, int chunkX, int chunkZ, ChunkPrimer chunkPrimer, double randX, double randY, double randZ, float caveSize, float randPI, float angleToGenerate, int loopOne, int loopEnd, double yScale, double width) {
        boolean flag;
        double centerX = chunkX * 16 + 8;
        double centerZ = chunkZ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(caveSeed);
        Random randomErosion = new Random(1234L);
        if (loopEnd <= 0) {
            int i = this.field_75040_a * 16 - 16;
            loopEnd = i - random.nextInt(i / 4);
        }
        boolean shouldStop = false;
        if (loopOne == -1) {
            loopOne = loopEnd / 2;
            shouldStop = true;
        }
        int j = random.nextInt(loopEnd / 2) + loopEnd / 4;
        boolean bl = flag = random.nextInt(6) == 0;
        while (loopOne < loopEnd) {
            double sizeXZ = width + (double)(MathHelper.func_76126_a((float)((float)loopOne * (float)Math.PI / (float)loopEnd)) * caveSize);
            double sizeY = sizeXZ * yScale;
            float cosAngle = MathHelper.func_76134_b((float)angleToGenerate);
            float sinAngle = MathHelper.func_76126_a((float)angleToGenerate);
            randY += (double)sinAngle;
            boolean isUp = this.field_75039_c.func_180494_b(new BlockPos(randX += (double)(MathHelper.func_76134_b((float)randPI) * cosAngle), 0.0, randZ += (double)(MathHelper.func_76126_a((float)randPI) * cosAngle))) instanceof BiomeMistUp;
            if (!isUp && randY - sizeY < 31.0) {
                randY = 26.0 + sizeY + 4.0 + (double)randomErosion.nextInt(3);
            }
            angleToGenerate = flag ? (angleToGenerate *= 0.92f) : (angleToGenerate *= 0.7f);
            angleToGenerate += f1 * 0.1f;
            randPI += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!shouldStop && loopOne == j && caveSize > 1.0f && loopEnd > 0) {
                this.addTunnel(random.nextLong(), chunkX, chunkZ, chunkPrimer, randX, randY, randZ, random.nextFloat() * 0.5f + 0.5f, randPI - 1.5707964f, angleToGenerate / 3.0f, loopOne, loopEnd, 1.0, width);
                this.addTunnel(random.nextLong(), chunkX, chunkZ, chunkPrimer, randX, randY, randZ, random.nextFloat() * 0.5f + 0.5f, randPI + 1.5707964f, angleToGenerate / 3.0f, loopOne, loopEnd, 1.0, width);
                return;
            }
            if (shouldStop || random.nextInt(4) != 0) {
                double distX = randX - centerX;
                double distZ = randZ - centerZ;
                double d6 = loopEnd - loopOne;
                double sizeSixteen = caveSize + 2.0f + 16.0f;
                if (distX * distX + distZ * distZ - d6 * d6 > sizeSixteen * sizeSixteen) {
                    return;
                }
                if (randX >= centerX - 16.0 - sizeXZ * 2.0 && randZ >= centerZ - 16.0 - sizeXZ * 2.0 && randX <= centerX + 16.0 + sizeXZ * 2.0 && randZ <= centerZ + 16.0 + sizeXZ * 2.0) {
                    int minX = MathHelper.func_76128_c((double)(randX - sizeXZ)) - chunkX * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(randX + sizeXZ)) - chunkX * 16 + 1;
                    int minY = MathHelper.func_76128_c((double)(randY - sizeY)) - 1;
                    int maxY = MathHelper.func_76128_c((double)(randY + sizeY)) + 1;
                    int minZ = MathHelper.func_76128_c((double)(randZ - sizeXZ)) - chunkZ * 16 - 1;
                    int maxZ = MathHelper.func_76128_c((double)(randZ + sizeXZ)) - chunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < 26 + (isUp ? 1 : 5)) {
                        minY = 26 + (isUp ? 1 : 5);
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    boolean hasHitWater = false;
                    for (int genX = minX; !hasHitWater && genX < maxX; ++genX) {
                        for (int genZ = minZ; !hasHitWater && genZ < maxZ; ++genZ) {
                            for (int genY = maxY + 1; !hasHitWater && genY >= minY - 1; --genY) {
                                if (genY < 0 || genY >= 256) continue;
                                if (this.isOceanBlock(chunkPrimer, genX, genY, genZ, chunkX, chunkZ)) {
                                    hasHitWater = true;
                                }
                                if (genY == minY - 1 || genX == minX || genX == maxX - 1 || genZ == minZ || genZ == maxZ - 1) continue;
                                genY = minY;
                            }
                        }
                    }
                    if (!hasHitWater) {
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                        for (int genX = minX; genX < maxX; ++genX) {
                            double d10 = ((double)(genX + chunkX * 16) + 0.5 - randX) / sizeXZ;
                            for (int genZ = minZ; genZ < maxZ; ++genZ) {
                                double d8 = ((double)(genZ + chunkZ * 16) + 0.5 - randZ) / sizeXZ;
                                boolean hitGrass = false;
                                if (!(d10 * d10 + d8 * d8 < 1.0)) continue;
                                for (int genY = maxY; genY > minY; --genY) {
                                    double d9 = ((double)(genY - 1) + 0.5 - randY) / sizeY;
                                    if (!(d9 > -0.7) || !(d10 * d10 + d9 * d9 + d8 * d8 < 1.0)) continue;
                                    IBlockState iblockstate1 = chunkPrimer.func_177856_a(genX, genY, genZ);
                                    IBlockState iblockstate2 = (IBlockState)MoreObjects.firstNonNull((Object)chunkPrimer.func_177856_a(genX, genY + 1, genZ), (Object)AIR);
                                    if (this.isTopBlock(chunkPrimer, genX, genY, genZ, chunkX, chunkZ)) {
                                        hitGrass = true;
                                    }
                                    this.digBlock(chunkPrimer, genX, genY, genZ, chunkX, chunkZ, hitGrass, iblockstate1, iblockstate2, randomErosion, isUp);
                                }
                            }
                        }
                        if (shouldStop) break;
                    }
                }
            }
            ++loopOne;
        }
    }

    protected boolean canReplaceBlock(IBlockState state, IBlockState stateUp) {
        return state == MistWorld.worldStone || state == MistWorld.stoneBlockUpper || state.func_177230_c() instanceof IWettable || state.func_177230_c() == Blocks.field_150431_aC || state == MistWorld.gravelBlock;
    }

    protected void func_180701_a(World worldIn, int genX, int genZ, int chunkX, int chunkZ, ChunkPrimer chunkPrimerIn) {
        int numberOfCaves = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(15) + 1) + 1);
        int caveChance = 16;
        if (this.field_75038_b.nextInt(caveChance) != 0) {
            numberOfCaves = 0;
        }
        for (int j = 0; j < numberOfCaves; ++j) {
            double randX = genX * 16 + this.field_75038_b.nextInt(16);
            double randY = this.field_75038_b.nextInt(this.field_75038_b.nextInt(120) + 36);
            double randZ = genZ * 16 + this.field_75038_b.nextInt(16);
            int numberOfNormalNodes = 1;
            double width = randY < 46.0 ? 1.8 : (randY < 67.0 ? 2.0 : (randY < 86.0 ? 1.8 : 1.5));
            if (this.field_75038_b.nextInt(16) == 0) {
                width += 0.8;
            }
            if (this.field_75038_b.nextInt(4) == 0) {
                this.addRoom(this.field_75038_b.nextLong(), chunkX, chunkZ, chunkPrimerIn, randX, randY, randZ);
                numberOfNormalNodes += this.field_75038_b.nextInt(4);
            }
            for (int l = 0; l < numberOfNormalNodes; ++l) {
                float randPi = this.field_75038_b.nextFloat() * ((float)Math.PI * 2);
                float angleToGenerate = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float caveSize = this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    caveSize *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.0f + 1.0f;
                }
                this.addTunnel(this.field_75038_b.nextLong(), chunkX, chunkZ, chunkPrimerIn, randX, randY, randZ, caveSize, randPi, angleToGenerate, 0, 0, 1.0, width);
            }
        }
    }

    protected boolean isOceanBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        IBlockState state = data.func_177856_a(x, y, z);
        return (state == MistWorld.waterBlockUpper || state == MistWorld.waterBlockLower) && y != 28;
    }

    private boolean isExceptionBiome(Biome biome) {
        return false;
    }

    private boolean isTopBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState state = data.func_177856_a(x, y, z);
        return state == biome.field_76752_A;
    }

    protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, IBlockState state, IBlockState up, Random rand, boolean isUp) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState top = biome.field_76752_A;
        IBlockState filler = biome.field_76753_B;
        if (!(!this.canReplaceBlock(state, up) && state != top && state != filler || up == MistWorld.waterBlockUpper || up == MistWorld.waterBlockLower || y <= 112 && up == MistWorld.gravelBlock)) {
            if (y == 28) {
                data.func_177855_a(x, y, z, MistWorld.waterBlockLower);
                if (data.func_177856_a(x, y - 1, z) == MistWorld.worldStone) {
                    data.func_177855_a(x, y - 1, z, MistWorld.gravelBlock);
                }
            } else if (state != MistWorld.gravelBlock || state == MistWorld.gravelBlock && (data.func_177856_a(x, y - 1, z) != MistWorld.gravelBlock || data.func_177856_a(x, y - 1, z) == MistWorld.gravelBlock && rand.nextInt(3) == 0)) {
                data.func_177855_a(x, y, z, AIR);
                if (y > 28 && rand.nextInt(2) == 0) {
                    if (!isUp && data.func_177856_a(x, y - 1, z) == MistWorld.gravelBlock) {
                        data.func_177855_a(x, y - 1, z, AIR);
                    }
                    if (rand.nextInt(4) == 0) {
                        if (data.func_177856_a(x, y - 1, z) == MistWorld.worldStone && y - 1 != 28) {
                            data.func_177855_a(x, y - 1, z, AIR);
                        }
                        if (!this.isOceanBlock(data, x, y + 1, z, chunkX, chunkZ)) {
                            data.func_177855_a(x, y + 1, z, AIR);
                        }
                    } else {
                        if (data.func_177856_a(x, y - 1, z) == MistWorld.worldStone) {
                            data.func_177855_a(x, y - 1, z, MistWorld.gravelBlock);
                        }
                        if (data.func_177856_a(x, y + 1, z) == MistWorld.worldStone) {
                            data.func_177855_a(x, y + 1, z, MistWorld.gravelBlock);
                        }
                    }
                }
                if (foundTop && data.func_177856_a(x, y - 1, z).func_177230_c() == filler.func_177230_c()) {
                    data.func_177855_a(x, y - 1, z, top.func_177230_c().func_176223_P());
                }
            }
        }
    }
}

