/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.layer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.init.ModBiomesIds;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.layer.GenLayerBordersCenter;
import ru.liahim.mist.world.layer.GenLayerBordersFinal;
import ru.liahim.mist.world.layer.GenLayerBordersUp;
import ru.liahim.mist.world.layer.GenLayerDiversify;
import ru.liahim.mist.world.layer.GenLayerDiversifyMin;
import ru.liahim.mist.world.layer.GenLayerDoCanyons;
import ru.liahim.mist.world.layer.GenLayerDownSwampBorder;
import ru.liahim.mist.world.layer.GenLayerDunesBorders;
import ru.liahim.mist.world.layer.GenLayerFuzzyZoomMist;
import ru.liahim.mist.world.layer.GenLayerMistBiomes;
import ru.liahim.mist.world.layer.GenLayerSeparator;
import ru.liahim.mist.world.layer.GenLayerSmoothMist;
import ru.liahim.mist.world.layer.GenLayerUpSwampBorders;
import ru.liahim.mist.world.layer.GenLayerZoomMist;

public class GenLayerMist {
    private static boolean shouldDraw = false;

    public static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType worldType, String options) {
        ModBiomesIds.assignBiomeIds();
        int deltaX = (int)(seed >> 8 & 0xFL);
        int deltaZ = (int)(seed >> 16 & 0xFL);
        GenLayer biomes = new GenLayerMistBiomes(1L, deltaX, deltaZ);
        biomes = new GenLayerZoomMist(1000L, biomes, true);
        GenLayerMist.drawImage(512, biomes, "0zoom");
        biomes = new GenLayerSmoothMist(700L, biomes);
        biomes = new GenLayerSmoothMist(701L, biomes);
        biomes = new GenLayerSmoothMist(702L, biomes);
        GenLayerMist.drawImage(512, biomes, "1smooth");
        biomes = new GenLayerDiversify(1000L, biomes, true, deltaX, deltaZ);
        GenLayerMist.drawImage(512, biomes, "2diverse");
        biomes = new GenLayerZoomMist(1001L, biomes, true);
        biomes = new GenLayerSmoothMist(703L, biomes);
        GenLayerMist.drawImage(512, biomes, "3zoom_smooth");
        biomes = new GenLayerZoomMist(1002L, biomes, false);
        biomes = new GenLayerSmoothMist(704L, biomes);
        GenLayerMist.drawImage(512, biomes, "4zoom_smooth");
        biomes = new GenLayerBordersCenter(1000L, biomes);
        GenLayerMist.drawImage(512, biomes, "5down_center");
        biomes = new GenLayerDiversify(1001L, biomes);
        GenLayerMist.drawImage(512, biomes, "6diverse");
        biomes = new GenLayerFuzzyZoomMist(1000L, biomes);
        GenLayerMist.drawImage(512, biomes, "7fuzzy_zoom");
        biomes = new GenLayerDoCanyons(1000L, biomes);
        GenLayerMist.drawImage(512, biomes, "8canyons");
        biomes = new GenLayerSmoothMist(705L, biomes);
        GenLayerMist.drawImage(512, biomes, "9smooth");
        biomes = new GenLayerBordersUp(1000L, biomes);
        biomes = new GenLayerDiversifyMin(1000L, biomes);
        GenLayerMist.drawImage(512, biomes, "10border_diverse");
        biomes = new GenLayerDownSwampBorder(1001L, biomes);
        GenLayerMist.drawImage(512, biomes, "11border_swamp");
        biomes = new GenLayerFuzzyZoomMist(1001L, biomes);
        biomes = new GenLayerSmoothMist(706L, biomes);
        GenLayerMist.drawImage(512, biomes, "12zoom_smooth");
        biomes = new GenLayerBordersFinal(1000L, biomes, true);
        biomes = new GenLayerDunesBorders(1005L, biomes);
        biomes = new GenLayerUpSwampBorders(1006L, biomes);
        GenLayerMist.drawImage(512, biomes, "13borderUp");
        biomes = new GenLayerFuzzyZoomMist(1002L, biomes);
        biomes = new GenLayerBordersFinal(1001L, biomes, false);
        biomes = new GenLayerZoomMist(1003L, biomes, false);
        biomes = new GenLayerZoomMist(1004L, biomes, false);
        biomes = new GenLayerSeparator(1004L, biomes);
        GenLayerMist.drawImage(2048, biomes, "14zoom");
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, biomes);
        biomes.func_75905_a(seed);
        genlayervoronoizoom.func_75905_a(seed);
        return new GenLayer[]{biomes, genlayervoronoizoom};
    }

    public static void drawImage(int size, GenLayer biomes, String name) {
        if (!shouldDraw) {
            return;
        }
        try {
            File outFile = new File(name + ".bmp");
            if (outFile.exists()) {
                return;
            }
            int[] ints = biomes.func_75904_a(0, 0, size, size);
            BufferedImage outBitmap = new BufferedImage(size, size, 1);
            Graphics2D graphics = (Graphics2D)outBitmap.getGraphics();
            graphics.clearRect(0, 0, size, size);
            Mist.logger.info(name + ".bmp start draw");
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    if (ints[x * size + z] == -1 || !(Biome.func_150568_d((int)ints[x * size + z]) instanceof BiomeMist)) continue;
                    graphics.setColor(Color.getColor("", ((BiomeMist)Biome.func_150568_d((int)ints[x * size + z])).getBiomeColor()));
                    graphics.drawRect(x, z, 1, 1);
                }
            }
            Mist.logger.info(name + ".bmp save");
            ImageIO.write((RenderedImage)outBitmap, "BMP", outFile);
        }
        catch (Exception e) {
            Mist.logger.catching((Throwable)e);
        }
    }
}

