/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.layer;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.init.ModBiomesIds;
import ru.liahim.mist.world.biome.BiomeMist;

public class GenLayerDiversify
extends GenLayer {
    private final int deltaX;
    private final int deltaZ;
    private final boolean needCenters;
    private final int point = ModBiomesIds.BORDER_DOWN;
    private final int border = ModBiomesIds.DOWN_CENTER;
    private final int[] forestBiomes = new int[]{ModBiomesIds.UP_FOREST, ModBiomesIds.UP_FOREST, ModBiomesIds.UP_DENSE_FOREST, ModBiomesIds.UP_DENSE_FOREST, ModBiomesIds.UP_MEADOW};
    private final int[] desertBiomes = new int[]{ModBiomesIds.UP_SAVANNA, ModBiomesIds.UP_SAVANNA, ModBiomesIds.UP_SAVANNA, ModBiomesIds.UP_DESERT, ModBiomesIds.UP_DESERT, ModBiomesIds.UP_DUNES};
    private final int[] coldBiomes = new int[]{ModBiomesIds.UP_SNOWFIELDS, ModBiomesIds.UP_TAIGA, ModBiomesIds.UP_HILLY_TAIGA};
    private final int[] swampBiomes = new int[]{ModBiomesIds.UP_SWAMP, ModBiomesIds.UP_SWAMP, ModBiomesIds.UP_SWAMPY_FOREST, ModBiomesIds.UP_SWAMPY_FOREST, ModBiomesIds.UP_SWAMPY_MEADOW};
    private final int[] jungleBiomes = new int[]{ModBiomesIds.UP_JUNGLE, ModBiomesIds.UP_JUNGLE, ModBiomesIds.UP_JUNGLE_HILLS, ModBiomesIds.UP_JUNGLE_HILLS, ModBiomesIds.UP_JUNGLE_EDGE};
    private final int[] downBiomes = new int[]{ModBiomesIds.BORDER_DOWN};

    public GenLayerDiversify(long seed, GenLayer genlayer, boolean needCenters, int deltaX, int deltaZ) {
        super(seed);
        this.field_75909_a = genlayer;
        this.needCenters = needCenters;
        this.deltaX = deltaX * 2 + 4 & 7;
        this.deltaZ = deltaZ * 2 + 4 & 7;
    }

    public GenLayerDiversify(long seed, GenLayer genlayer) {
        this(seed, genlayer, false, 0, 0);
    }

    public int[] func_75904_a(int x, int z, int width, int height) {
        if (this.needCenters) {
            return this.diversifyMax(x, z, width, height);
        }
        return this.diversifyMed(x, z, width, height);
    }

    private int[] diversifyMed(int x, int z, int width, int height) {
        int[] input = this.field_75909_a.func_75904_a(x, z, width, height);
        int[] output = IntCache.func_76445_a((int)(width * height));
        for (int zOut = 0; zOut < height; ++zOut) {
            for (int xOut = 0; xOut < width; ++xOut) {
                int i = xOut + zOut * width;
                int center = input[i];
                this.func_75903_a(xOut + x, zOut + z);
                if (this.func_75902_a(5) == 0) {
                    if (Biome.func_150568_d((int)center) instanceof BiomeMist) {
                        EnumBiomeType type = ((BiomeMist)Biome.func_150568_d((int)center)).getBiomeType();
                        if (type == EnumBiomeType.Forest) {
                            output[i] = this.forestBiomes[this.func_75902_a(this.forestBiomes.length)];
                            continue;
                        }
                        if (type == EnumBiomeType.Desert) {
                            output[i] = this.desertBiomes[this.func_75902_a(this.desertBiomes.length)];
                            continue;
                        }
                        if (type == EnumBiomeType.Cold) {
                            output[i] = this.coldBiomes[this.func_75902_a(this.coldBiomes.length)];
                            continue;
                        }
                        if (type == EnumBiomeType.Swamp) {
                            output[i] = this.swampBiomes[this.func_75902_a(this.swampBiomes.length)];
                            continue;
                        }
                        if (type == EnumBiomeType.Jungle) {
                            output[i] = this.jungleBiomes[this.func_75902_a(this.jungleBiomes.length)];
                            continue;
                        }
                        output[i] = center;
                        continue;
                    }
                    output[i] = this.forestBiomes[this.func_75902_a(this.forestBiomes.length)];
                    continue;
                }
                output[i] = center;
            }
        }
        return output;
    }

    private int[] diversifyMax(int x, int z, int width, int height) {
        int x0 = x - 1;
        int z0 = z - 1;
        int widthOut = width + 2;
        int heightOut = height + 2;
        int[] input = this.field_75909_a.func_75904_a(x0, z0, widthOut, heightOut);
        int[] output = IntCache.func_76445_a((int)(width * height));
        for (int zOut = 0; zOut < height; ++zOut) {
            for (int xOut = 0; xOut < width; ++xOut) {
                int right = input[xOut + 0 + (zOut + 1) * widthOut];
                int left = input[xOut + 2 + (zOut + 1) * widthOut];
                int up = input[xOut + 1 + (zOut + 0) * widthOut];
                int down = input[xOut + 1 + (zOut + 2) * widthOut];
                int center = input[xOut + 1 + (zOut + 1) * widthOut];
                int ur = input[xOut + 0 + (zOut + 0) * widthOut];
                int ul = input[xOut + 2 + (zOut + 0) * widthOut];
                int dr = input[xOut + 0 + (zOut + 2) * widthOut];
                int dl = input[xOut + 2 + (zOut + 2) * widthOut];
                this.func_75903_a(xOut + x, zOut + z);
                if (Biome.func_150568_d((int)center) != null && Biome.func_150568_d((int)center) instanceof BiomeMist) {
                    EnumBiomeType type = ((BiomeMist)Biome.func_150568_d((int)center)).getBiomeType();
                    if (type == EnumBiomeType.Forest) {
                        output[xOut + zOut * width] = this.forestBiomes[this.func_75902_a(this.forestBiomes.length)];
                    } else if (type == EnumBiomeType.Desert) {
                        output[xOut + zOut * width] = this.desertBiomes[this.func_75902_a(this.desertBiomes.length)];
                    } else if (type == EnumBiomeType.Cold) {
                        output[xOut + zOut * width] = this.coldBiomes[this.func_75902_a(this.coldBiomes.length)];
                    } else if (type == EnumBiomeType.Swamp) {
                        output[xOut + zOut * width] = this.swampBiomes[this.func_75902_a(this.swampBiomes.length)];
                    } else if (type == EnumBiomeType.Jungle) {
                        output[xOut + zOut * width] = this.jungleBiomes[this.func_75902_a(this.jungleBiomes.length)];
                    } else if (type == EnumBiomeType.Down || type == EnumBiomeType.Border) {
                        output[xOut + zOut * width] = center;
                    }
                } else {
                    output[xOut + zOut * width] = Biome.func_185362_a((Biome)MistBiomes.upMeadow);
                }
                if ((xOut + x >> 3 << 3 | this.deltaX) != xOut + x || (zOut + z >> 3 << 3 | this.deltaZ) != zOut + z) continue;
                int n = this.downBiomes[this.func_75902_a(this.downBiomes.length)];
                input[xOut + 1 + (zOut + 1) * widthOut] = n;
                output[xOut + zOut * width] = n;
            }
        }
        return output;
    }
}

