/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.layer;

import java.util.ArrayList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.init.ModBiomesIds;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.layer.GenLayerBorders;

public class GenLayerBordersFinal
extends GenLayerBorders {
    private boolean isUp;

    public GenLayerBordersFinal(long seed, GenLayer genlayer, boolean isUp) {
        super(seed, genlayer);
        this.isUp = isUp;
    }

    @Override
    protected int getBorder(int center, int up, int upLeft, int left) {
        return this.isUp ? this.getUpBorder(center, up, upLeft, left) : ModBiomesIds.BORDER_DOWN;
    }

    @Override
    protected boolean getBool(int center) {
        return this.isUpBiome(center) == this.isUp;
    }

    private int getUpBorder(int center, int up, int upLeft, int left) {
        if (Biome.func_150568_d((int)center) instanceof BiomeMist) {
            EnumBiomeType type = ((BiomeMist)Biome.func_150568_d((int)center)).getBiomeType();
            if (type == EnumBiomeType.Cold) {
                return ModBiomesIds.BORDER_UP_COLD;
            }
            if (type == EnumBiomeType.Desert) {
                return ModBiomesIds.BORDER_UP_DESERT;
            }
            if (type == EnumBiomeType.Swamp) {
                return ModBiomesIds.BORDER_UP_SWAMP;
            }
            if (type == EnumBiomeType.Jungle) {
                return ModBiomesIds.BORDER_UP_JUNGLE;
            }
            if (type == EnumBiomeType.Down) {
                ArrayList<Integer> biomes = new ArrayList<Integer>();
                if (this.isUpBiome(up)) {
                    biomes.add(up);
                }
                if (this.isUpBiome(upLeft)) {
                    biomes.add(upLeft);
                }
                if (this.isUpBiome(left)) {
                    biomes.add(left);
                }
                if (biomes.size() > 0) {
                    return this.getUpBorder((Integer)biomes.get(this.func_75902_a(biomes.size())), up, upLeft, left);
                }
                return ModBiomesIds.BORDER_UP_PLAINS;
            }
        }
        return ModBiomesIds.BORDER_UP_PLAINS;
    }
}

