/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.layer;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import ru.liahim.mist.world.biome.BiomeMist;

public abstract class GenLayerBorders
extends GenLayer {
    public GenLayerBorders(long seed, GenLayer genlayer) {
        super(seed);
        this.field_75909_a = genlayer;
    }

    public int[] func_75904_a(int x, int z, int width, int height) {
        int widthOut = width + 2;
        int heightOut = height + 2;
        int[] input = this.field_75909_a.func_75904_a(x - 1, z - 1, widthOut, heightOut);
        int[] output = IntCache.func_76445_a((int)(width * height));
        for (int zOut = 0; zOut < height + 1; ++zOut) {
            int up = input[(zOut + 1) * widthOut];
            int upLeft = input[(zOut + 0) * widthOut];
            boolean u = this.getBool(up);
            boolean ul = this.getBool(upLeft);
            for (int xOut = 0; xOut < width + 1; ++xOut) {
                int center = input[xOut + 1 + (zOut + 1) * widthOut];
                int left = input[xOut + 1 + (zOut + 0) * widthOut];
                this.func_75903_a(xOut + x, zOut + z);
                int border = this.getBorder(center, left, upLeft, up);
                boolean c = this.getBool(center);
                boolean l = this.getBool(left);
                if (c) {
                    if (xOut < width && zOut < height) {
                        output[xOut + zOut * width] = !l || !u || !ul ? border : center;
                        if (l != u) {
                            if (l && zOut > 0 && xOut < height) {
                                output[xOut + 0 + (zOut - 1) * width] = border;
                            }
                            if (u && xOut > 0 && zOut < width) {
                                output[xOut - 1 + (zOut + 0) * width] = border;
                            }
                        }
                    }
                } else {
                    if (xOut < width && zOut < height) {
                        output[xOut + zOut * width] = center;
                    }
                    if (l && zOut > 0 && xOut < height) {
                        output[xOut + 0 + (zOut - 1) * width] = border;
                    }
                    if (u && xOut > 0 && zOut < width) {
                        output[xOut - 1 + (zOut + 0) * width] = border;
                    }
                    if (ul && xOut > 0 && xOut < width && zOut > 0 && zOut < height) {
                        output[xOut - 1 + (zOut - 1) * width] = border;
                    }
                }
                up = center;
                upLeft = left;
                u = c;
                ul = l;
            }
        }
        return output;
    }

    protected boolean isUpBiome(int center) {
        return Biome.func_150568_d((int)center) instanceof BiomeMist && ((BiomeMist)Biome.func_150568_d((int)center)).isUpBiome();
    }

    protected abstract int getBorder(int var1, int var2, int var3, int var4);

    protected abstract boolean getBool(int var1);
}

