/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.tileentity.TileEntityUrn;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.biome.BiomeMistBorder;
import ru.liahim.mist.world.biome.BiomeMistUpDesert;
import ru.liahim.mist.world.generators.TombGenBase;

public class WellGen
extends WorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        return this.generate(world, rand, pos, false);
    }

    public boolean generate(World world, Random rand, BlockPos pos, boolean manual) {
        int rz;
        if (!manual && (double)rand.nextFloat() >= ModConfig.generation.wellsGenerationChance) {
            return false;
        }
        int rx = rand.nextInt(16) + 8;
        BlockPos center = world.func_175645_m(pos.func_177982_a(rx, 0, rz = rand.nextInt(16) + 8));
        if (world.func_180495_p(center.func_177977_b()).func_185904_a().func_76222_j()) {
            center = center.func_177977_b();
        }
        if (center.func_177956_o() <= 108 || center.func_177956_o() > 130) {
            return false;
        }
        Biome biome = world.func_180494_b(center);
        if (!(biome instanceof BiomeMist) || biome instanceof BiomeMistBorder || biome instanceof BiomeMistUpDesert || !((BiomeMist)biome).isUpBiome() || !(world.func_180495_p(center.func_177977_b()).func_177230_c() instanceof MistSoil)) {
            return false;
        }
        boolean check = true;
        block0: for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (world.func_180495_p(center.func_177982_a(x, 0, z)).func_185904_a().func_76222_j() && world.func_175677_d(center.func_177982_a(x, -1, z), false)) continue;
                check = false;
                break block0;
            }
        }
        if (check) {
            BlockPos wall;
            boolean desert = ((BiomeMist)biome).getBiomeType() == EnumBiomeType.Desert;
            boolean jungle = ((BiomeMist)biome).getBiomeType() == EnumBiomeType.Jungle;
            boolean cold = ((BiomeMist)biome).getBiomeType() == EnumBiomeType.Cold;
            boolean forest = ((BiomeMist)biome).getBiomeType() == EnumBiomeType.Forest;
            TombGenBase.Type[] bType = new TombGenBase.Type[]{TombGenBase.Type.COBBLE};
            if (cold) {
                bType = rand.nextInt(4) == 0 ? new TombGenBase.Type[]{TombGenBase.Type.BRICK, TombGenBase.Type.BRICK, TombGenBase.Type.COBBLE} : new TombGenBase.Type[]{TombGenBase.Type.BRICK};
            } else if (jungle) {
                bType = new TombGenBase.Type[]{TombGenBase.Type.BRICK};
            } else if (forest && rand.nextInt(4) > 0) {
                bType = rand.nextBoolean() ? new TombGenBase.Type[]{TombGenBase.Type.BRICK, TombGenBase.Type.COBBLE, TombGenBase.Type.COBBLE} : new TombGenBase.Type[]{TombGenBase.Type.BRICK, TombGenBase.Type.BRICK, TombGenBase.Type.COBBLE};
            }
            int i = 1;
            int type = rand.nextInt(4);
            int deep = rand.nextInt(3) + 2;
            boolean water = rand.nextInt(3) > 0;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    wall = center.func_177982_a(x, 0, z);
                    if (x != 0 || z != 0) {
                        if (jungle) {
                            if (type > 1) {
                                world.func_180501_a(wall, TombGenBase.getSlab(bType[rand.nextInt(bType.length)], false, rand, 1), 18);
                            } else {
                                world.func_180501_a(wall, TombGenBase.getStairs(bType[rand.nextInt(bType.length)], x < 0 ? EnumFacing.EAST : (x > 0 ? EnumFacing.WEST : (z < 0 ? EnumFacing.SOUTH : EnumFacing.NORTH)), false, rand, 1), 18);
                            }
                        } else if (desert) {
                            if (type > 1) {
                                world.func_180501_a(wall, TombGenBase.getStairs(bType[rand.nextInt(bType.length)], x < 0 ? EnumFacing.WEST : (x > 0 ? EnumFacing.EAST : (z < 0 ? EnumFacing.NORTH : EnumFacing.SOUTH)), false, rand, -1), 18);
                            } else {
                                world.func_180501_a(wall, TombGenBase.getStep(bType[rand.nextInt(bType.length)], x < 0 ? EnumFacing.WEST : (x > 0 ? EnumFacing.EAST : (z < 0 ? EnumFacing.NORTH : EnumFacing.SOUTH)), false, rand, -1), 18);
                            }
                        } else if (cold && type != 0) {
                            world.func_180501_a(wall, TombGenBase.getBlock(bType[rand.nextInt(bType.length)], rand, 1), 18);
                            if (world.func_175678_i(wall.func_177984_a())) {
                                world.func_175656_a(wall.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                            }
                        } else {
                            i = rand.nextInt(10);
                            if (i == 0) {
                                world.func_180501_a(wall, TombGenBase.getStairs(bType[rand.nextInt(bType.length)], EnumFacing.field_176754_o[rand.nextInt(4)], false, rand, 1), 18);
                            } else if (i == 1) {
                                world.func_180501_a(wall, TombGenBase.getSlab(bType[rand.nextInt(bType.length)], false, rand, 1), 18);
                            } else {
                                world.func_180501_a(wall, TombGenBase.getBlock(bType[rand.nextInt(bType.length)], rand, 1), 18);
                            }
                        }
                    }
                    i = 0;
                    wall = wall.func_177977_b();
                    while (wall.func_177956_o() > 108 && (wall.func_177956_o() > 122 || world.func_180495_p(wall).func_177230_c() != MistBlocks.STONE)) {
                        if (x != 0 || z != 0) {
                            world.func_180501_a(wall, TombGenBase.getBlock(bType[rand.nextInt(bType.length)], rand, desert ? -1 : 1), 18);
                        } else if (water) {
                            if (wall.func_177956_o() <= 125) {
                                world.func_180501_a(wall, Blocks.field_150355_j.func_176223_P(), 18);
                            } else {
                                world.func_175698_g(wall);
                            }
                        } else if (i >= deep) {
                            if (i == deep) {
                                world.func_180501_a(wall, biome.field_76752_A, 18);
                            } else {
                                world.func_180501_a(wall, biome.field_76753_B, 18);
                            }
                        } else {
                            world.func_175698_g(wall);
                        }
                        ++i;
                        wall = wall.func_177977_b();
                    }
                }
            }
            world.func_180501_a(center.func_177979_c(i), MistBlocks.GRAVEL.func_176223_P(), 18);
            if (rand.nextInt(3) == 0) {
                wall = center.func_177979_c(i).func_177972_a(EnumFacing.field_176754_o[rand.nextInt(4)]);
                world.func_180501_a(wall, MistBlocks.URN.func_176223_P(), 18);
                TileEntity te = world.func_175625_s(wall);
                TileEntityUrn.UrnLootType.initializeType(te, ((BiomeMist)biome).getBiomeType(), TileEntityUrn.UrnLocation.WELLS, rand);
            }
            BiomeMist.looseRockGen.func_180709_b(world, rand, center);
            return true;
        }
        return false;
    }
}

