/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockMossy;
import ru.liahim.mist.block.MistBlockSlabStone;
import ru.liahim.mist.block.MistCobblestone;
import ru.liahim.mist.block.MistMasonry;
import ru.liahim.mist.block.MistSand;
import ru.liahim.mist.block.MistStoneBrick;
import ru.liahim.mist.tileentity.TileEntityUrn;
import ru.liahim.mist.util.GenUtil;

public abstract class TombGenBase
extends WorldGenerator {
    protected static IBlockState cobble = MistBlocks.COBBLESTONE.func_176223_P().func_177226_a((IProperty)MistCobblestone.VARIANT, (Comparable)((Object)MistBlockMossy.EnumType.NORMAL));
    protected static IBlockState cobbleMoss = MistBlocks.COBBLESTONE.func_176223_P().func_177226_a((IProperty)MistCobblestone.VARIANT, (Comparable)((Object)MistBlockMossy.EnumType.MOSSY));
    protected static IBlockState masonry = MistBlocks.MASONRY.func_176223_P().func_177226_a((IProperty)MistMasonry.VARIANT, (Comparable)((Object)MistBlockMossy.EnumType.NORMAL));
    protected static IBlockState masonryMoss = MistBlocks.MASONRY.func_176223_P().func_177226_a((IProperty)MistMasonry.VARIANT, (Comparable)((Object)MistBlockMossy.EnumType.MOSSY));
    protected static IBlockState cobbleStep = MistBlocks.COBBLESTONE_STEP.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
    protected static IBlockState cobbleStepMoss = MistBlocks.COBBLESTONE_MOSS_STEP.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
    protected static IBlockState cobbleSlab = MistBlocks.COBBLESTONE_SLAB.func_176223_P().func_177226_a(MistBlockSlabStone.VARIANT, (Comparable)((Object)MistBlockSlabStone.EnumType.NORMAL));
    protected static IBlockState cobbleSlabMoss = MistBlocks.COBBLESTONE_SLAB.func_176223_P().func_177226_a(MistBlockSlabStone.VARIANT, (Comparable)((Object)MistBlockSlabStone.EnumType.MOSSY));
    protected static IBlockState cobbleWall = MistBlocks.COBBLESTONE_WALL.func_176223_P();
    protected static IBlockState cobbleWallMoss = MistBlocks.COBBLESTONE_MOSS_WALL.func_176223_P();
    protected static IBlockState cobbleStairs = MistBlocks.COBBLESTONE_STAIRS.func_176223_P();
    protected static IBlockState cobbleStairsMoss = MistBlocks.COBBLESTONE_MOSS_STAIRS.func_176223_P();
    protected static IBlockState brick = MistBlocks.STONE_BRICK.func_176223_P().func_177226_a((IProperty)MistStoneBrick.VARIANT, (Comparable)((Object)MistBlockMossy.EnumType.NORMAL));
    protected static IBlockState brickMoss = MistBlocks.STONE_BRICK.func_176223_P().func_177226_a((IProperty)MistStoneBrick.VARIANT, (Comparable)((Object)MistBlockMossy.EnumType.MOSSY));
    protected static IBlockState brickStep = MistBlocks.STONE_BRICK_STEP.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
    protected static IBlockState brickStepMoss = MistBlocks.STONE_BRICK_MOSS_STEP.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
    protected static IBlockState brickSlab = MistBlocks.STONE_BRICK_SLAB.func_176223_P().func_177226_a(MistBlockSlabStone.VARIANT, (Comparable)((Object)MistBlockSlabStone.EnumType.NORMAL));
    protected static IBlockState brickSlabMoss = MistBlocks.STONE_BRICK_SLAB.func_176223_P().func_177226_a(MistBlockSlabStone.VARIANT, (Comparable)((Object)MistBlockSlabStone.EnumType.MOSSY));
    protected static IBlockState brickWall = MistBlocks.STONE_BRICK_WALL.func_176223_P();
    protected static IBlockState brickWallMoss = MistBlocks.STONE_BRICK_MOSS_WALL.func_176223_P();
    protected static IBlockState brickStairs = MistBlocks.STONE_BRICK_STAIRS.func_176223_P();
    protected static IBlockState brickStairsMoss = MistBlocks.STONE_BRICK_MOSS_STAIRS.func_176223_P();
    protected static IBlockState sand = MistBlocks.SAND.func_176223_P().func_177226_a(MistSand.VARIANT, (Comparable)BlockSand.EnumType.SAND).func_177226_a((IProperty)MistSand.WET, (Comparable)Boolean.valueOf(false));
    protected static IBlockState redSandWet = MistBlocks.SAND.func_176223_P().func_177226_a(MistSand.VARIANT, (Comparable)BlockSand.EnumType.RED_SAND).func_177226_a((IProperty)MistSand.WET, (Comparable)Boolean.valueOf(true));
    protected static IBlockState redSandDry = MistBlocks.SAND.func_176223_P().func_177226_a(MistSand.VARIANT, (Comparable)BlockSand.EnumType.RED_SAND).func_177226_a((IProperty)MistSand.WET, (Comparable)Boolean.valueOf(false));

    protected static void placeUrn(GenUtil gen, BlockPos pos, EnumBiomeType biomeType, TileEntityUrn.UrnLocation loc, Random rand, boolean air) {
        TombGenBase.placeUrn(gen, pos, biomeType, loc, rand, air, 4);
    }

    protected static void placeUrn(GenUtil gen, BlockPos pos, EnumBiomeType biomeType, TileEntityUrn.UrnLocation loc, Random rand, boolean air, int rarity) {
        if (rand.nextInt(rarity) == 0) {
            gen.setBlockState(pos, MistBlocks.URN.func_176223_P());
            TileEntityUrn.UrnLootType.initializeType(gen.getTileEntity(pos), biomeType, loc, rand);
        } else {
            TombGenBase.placeWeb(gen, pos, rand, air);
        }
    }

    protected static void placeWeb(GenUtil gen, BlockPos pos, Random rand, boolean air) {
        if (rand.nextInt(8) == 0) {
            gen.setBlockState(pos, Blocks.field_150321_G.func_176223_P());
        } else if (air) {
            gen.setBlockState(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    protected static boolean roomCheck(GenUtil gen, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, boolean airCheck) {
        BlockPos center = gen.set.center;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                    BlockPos checkPos = gen.getPos(center.func_177982_a(x, y, z));
                    if ((!airCheck || y != maxY || gen.world.func_180495_p(checkPos.func_177984_a()).func_185904_a().func_76222_j()) && gen.world.func_175677_d(checkPos, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static boolean roomCheck(World world, BlockPos center, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, boolean airCheck) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                    BlockPos checkPos = center.func_177982_a(x, y, z);
                    if ((!airCheck || y != maxY || world.func_180495_p(checkPos.func_177984_a()).func_185904_a().func_76222_j()) && world.func_175677_d(checkPos, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static IBlockState getBlock(Type type, Random rand, int wet) {
        return type.getBlock(wet >= 0 && (wet != 0 || rand.nextInt(4) != 0));
    }

    protected static IBlockState getStep(Type type, EnumFacing face, boolean top, Random rand, int wet) {
        if (wet < 0 || wet == 0 && rand.nextInt(4) == 0) {
            if (top) {
                return type.getStep(false).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM);
            }
            return type.getStep(false).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face);
        }
        if (top) {
            return type.getStep(true).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM);
        }
        return type.getStep(true).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face);
    }

    protected static IBlockState getWall(Type type, EnumFacing face, Random rand, int wet) {
        return TombGenBase.getWall(type, face, false, rand, wet);
    }

    protected static IBlockState getWall(Type type, EnumFacing face, boolean top, Random rand, int wet) {
        if (wet < 0 || wet == 0 && rand.nextInt(4) == 0) {
            if (top) {
                return type.getWall(false).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM);
            }
            return type.getWall(false).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face);
        }
        if (top) {
            return type.getWall(true).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM);
        }
        return type.getWall(true).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face);
    }

    protected static IBlockState getSlab(Type type, boolean top, Random rand, int wet) {
        if (wet < 0 || wet == 0 && rand.nextInt(4) == 0) {
            if (top) {
                return type.getSlab(false).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
            }
            return type.getSlab(false);
        }
        if (top) {
            return type.getSlab(true).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
        }
        return type.getSlab(true);
    }

    protected static IBlockState getStairs(Type type, EnumFacing face, boolean top, Random rand, int wet) {
        if (wet < 0 || wet == 0 && rand.nextInt(4) == 0) {
            if (top) {
                return type.getStairs(false).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            return type.getStairs(false).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face);
        }
        if (top) {
            return type.getStairs(true).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
        }
        return type.getStairs(true).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)face);
    }

    public static enum Type {
        COBBLE(cobble, cobbleMoss, cobbleStairs, cobbleStairsMoss, cobbleWall, cobbleWallMoss, cobbleSlab, cobbleSlabMoss, cobbleStep, cobbleStepMoss),
        BRICK(brick, brickMoss, brickStairs, brickStairsMoss, brickWall, brickWallMoss, brickSlab, brickSlabMoss, brickStep, brickStepMoss),
        MASONRY(masonry, masonryMoss, brickStairs, brickStairsMoss, brickWall, brickWallMoss, brickSlab, brickSlabMoss, brickStep, brickStepMoss);

        final IBlockState block;
        final IBlockState blockMoss;
        final IBlockState stairs;
        final IBlockState stairsMoss;
        final IBlockState wall;
        final IBlockState wallMoss;
        final IBlockState slab;
        final IBlockState slabMoss;
        final IBlockState step;
        final IBlockState stepMoss;

        private Type(IBlockState block, IBlockState blockMoss, IBlockState stairs, IBlockState stairsMoss, IBlockState wall, IBlockState wallMoss, IBlockState slab, IBlockState slabMoss, IBlockState step, IBlockState stepMoss) {
            this.block = block;
            this.blockMoss = blockMoss;
            this.stairs = stairs;
            this.stairsMoss = stairsMoss;
            this.wall = wall;
            this.wallMoss = wallMoss;
            this.slab = slab;
            this.slabMoss = slabMoss;
            this.step = step;
            this.stepMoss = stepMoss;
        }

        public IBlockState getBlock(boolean moss) {
            return moss ? this.blockMoss : this.block;
        }

        public IBlockState getStairs(boolean moss) {
            return moss ? this.stairsMoss : this.stairs;
        }

        public IBlockState getWall(boolean moss) {
            return moss ? this.wallMoss : this.wall;
        }

        public IBlockState getSlab(boolean moss) {
            return moss ? this.slabMoss : this.slab;
        }

        public IBlockState getStep(boolean moss) {
            return moss ? this.stepMoss : this.step;
        }
    }
}

