/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistStoneMined;
import ru.liahim.mist.block.gizmos.Remains;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.tileentity.TileEntityRemains;
import ru.liahim.mist.tileentity.TileEntityUrn;
import ru.liahim.mist.util.GenUtil;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.biome.BiomeMistBorder;
import ru.liahim.mist.world.biome.BiomeMistUpDesert;
import ru.liahim.mist.world.biome.BiomeMistUpMarsh;
import ru.liahim.mist.world.biome.BiomeMistUpSavanna;
import ru.liahim.mist.world.generators.TombGenBase;

public class TombGen
extends TombGenBase {
    static int d = -1;
    private static final TileEntityUrn.UrnLocation loc = TileEntityUrn.UrnLocation.TOMBS;
    private static float genChance;

    public static void updateChance() {
        genChance = (float)Math.max(ModConfig.generation.forestTombGenerationChance, Math.max(ModConfig.generation.swampTombGenerationChance, Math.max(ModConfig.generation.desertTombGenerationChance, Math.max(ModConfig.generation.snowTombGenerationChance, ModConfig.generation.jungleTombGenerationChance))));
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int rz;
        float chance = rand.nextFloat();
        if (chance >= genChance) {
            return false;
        }
        int rx = rand.nextInt(16) + 8;
        BlockPos center = world.func_175645_m(pos.func_177982_a(rx, 0, rz = rand.nextInt(16) + 8));
        if (world.func_180495_p(center.func_177977_b()).func_185904_a().func_76222_j()) {
            center = center.func_177977_b();
        }
        if (center.func_177956_o() <= 125) {
            return false;
        }
        Biome biome = world.func_180494_b(center);
        if (!(biome instanceof BiomeMist) || !((BiomeMist)biome).isUpBiome() || biome instanceof BiomeMistBorder || biome instanceof BiomeMistUpMarsh || biome instanceof BiomeMistUpDesert || !(world.func_180495_p(center.func_177977_b()).func_177230_c() instanceof MistSoil)) {
            return false;
        }
        EnumBiomeType type = ((BiomeMist)biome).getBiomeType();
        if (type == EnumBiomeType.Forest) {
            if ((double)chance < ModConfig.generation.forestTombGenerationChance && (biome != MistBiomes.upMeadow || rand.nextBoolean())) {
                return ForestTomb.generate(world, center, (BiomeMist)biome, rand);
            }
        } else if (type == EnumBiomeType.Swamp) {
            if ((double)chance < ModConfig.generation.swampTombGenerationChance) {
                return SwampTomb.generate(world, center, (BiomeMist)biome, rand);
            }
        } else if (type == EnumBiomeType.Cold) {
            if ((double)chance < ModConfig.generation.snowTombGenerationChance && (biome != MistBiomes.upSnowfields || rand.nextBoolean())) {
                return SnowTomb.generate(world, center, (BiomeMist)biome, rand);
            }
        } else if (type == EnumBiomeType.Desert) {
            if ((double)chance < ModConfig.generation.desertTombGenerationChance) {
                return SavannaTomb.generate(world, center, (BiomeMist)biome, rand);
            }
        } else if (type == EnumBiomeType.Jungle && (double)chance < ModConfig.generation.jungleTombGenerationChance) {
            return TropicTomb.generate(world, pos, rand);
        }
        return false;
    }

    private static void generateEntrance(GenUtil gen, BiomeMist biome, Random rand, int offset, boolean wet, TombGenBase.Type type) {
        BlockPos center = gen.set.center;
        boolean cold = biome.func_150559_j();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -5 - offset; z <= 1; ++z) {
                for (int y = -1; y >= -6 - offset; --y) {
                    BlockPos checkPos = center.func_177982_a(x, y, z);
                    if (y == -1) {
                        if (z >= 1 - offset) continue;
                        if (cold && (x != 0 || z == -offset) && gen.world.func_175710_j(gen.getPos(checkPos.func_177984_a()))) {
                            gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                        } else {
                            gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                        }
                        if (x == -1) {
                            if (cold) {
                                gen.setBlockState(checkPos, TombGen.getBlock(type, rand, wet ? 0 : -1));
                                continue;
                            }
                            if (rand.nextInt(8) == 0) {
                                gen.setBlockState(checkPos, TombGen.getSlab(type, false, rand, wet ? 1 : -1));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGen.getStairs(type, EnumFacing.WEST, false, rand, wet ? 1 : -1));
                            continue;
                        }
                        if (x == 1) {
                            if (cold) {
                                gen.setBlockState(checkPos, TombGen.getBlock(type, rand, wet ? 0 : -1));
                                continue;
                            }
                            if (rand.nextInt(8) == 0) {
                                gen.setBlockState(checkPos, TombGen.getSlab(type, false, rand, wet ? 1 : -1));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGen.getStairs(type, EnumFacing.EAST, false, rand, wet ? 1 : -1));
                            continue;
                        }
                        if (z == -offset) {
                            if (cold) {
                                gen.setBlockState(checkPos, TombGen.getBlock(type, rand, wet ? 0 : -1));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGen.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 1 : -1));
                            continue;
                        }
                        if (z == -5 - offset && gen.world.func_175677_d(gen.getPos(checkPos.func_177982_a(0, 0, -1)), false)) {
                            gen.setBlockState(checkPos, TombGen.getStairs(type, EnumFacing.NORTH, false, rand, wet ? 1 : -1));
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    if (y > -1 - z - offset || y < -7 - z - offset) continue;
                    if (x == 0 && y < -1 - z - offset && y > -7 - z - offset) {
                        if (y == -2 - z - offset) {
                            gen.setBlockState(checkPos, TombGen.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y > -6 - offset) {
                            if (y > -6 - z - offset) {
                                if (y == -2) {
                                    gen.setBlockState(checkPos, biome.field_76752_A);
                                    if (!cold || !gen.world.func_175710_j(gen.getPos(checkPos.func_177984_a()))) continue;
                                    gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                                    continue;
                                }
                                if (y == -3) {
                                    gen.setBlockState(checkPos, biome.secondTopBlock);
                                    continue;
                                }
                                gen.setBlockState(checkPos, biome.field_76753_B);
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGen.getStairs(type, EnumFacing.NORTH, false, rand, wet ? 0 : (y == -2 ? -1 : d)));
                            continue;
                        }
                        gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                        continue;
                    }
                    gen.setBlockState(checkPos, TombGen.getBlock(type, rand, wet ? 0 : (y == -2 && z == -4 - offset ? -1 : d)));
                }
            }
        }
        BiomeMist.looseRockGen.func_180709_b(gen.world, rand, center);
    }

    static {
        TombGen.updateChance();
    }

    public static class SwampTomb {
        private static final EnumBiomeType biomeType = EnumBiomeType.Swamp;

        public static boolean generate(World world, BlockPos center, BiomeMist biome, Random rand) {
            GenUtil gen = new GenUtil(world, new GenUtil.GenSet(center, Rotation.CLOCKWISE_90, Mirror.NONE));
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            if (TombGenBase.roomCheck(gen, -1, 1, -6, -1, -5, 1, true)) {
                boolean wet;
                int i = rand.nextInt(3);
                boolean bl = wet = !(biome instanceof BiomeMistUpSavanna);
                if (i < 2 && TombGenBase.roomCheck(gen, -4, 4, -7, -1, 1, 7, false)) {
                    if (i == 0 && TombGenBase.roomCheck(gen, -4, 4, -7, -1, -9, -3, false)) {
                        TombGen.generateEntrance(gen, biome, rand, 0, wet, type);
                        SwampTomb.generateRoom(gen, biome, rand, true, false, wet);
                        if (rand.nextInt(3) == 0 && TombGenBase.roomCheck(gen, -4, 4, -9, -8, -9, -3, false)) {
                            SwampTomb.generateRoom(gen.add(center.func_177964_d(2).func_177979_c(2), Rotation.CLOCKWISE_180, Mirror.NONE), biome, rand, true, true, wet);
                            SwampTomb.generateStairs(gen, biome, rand, wet);
                            SwampTomb.generateStairs(gen.add(center, Rotation.NONE, Mirror.FRONT_BACK), biome, rand, wet);
                        } else {
                            SwampTomb.generateRoom(gen.add(center.func_177964_d(2), Rotation.CLOCKWISE_180, Mirror.NONE), biome, rand, true, true, wet);
                            SwampTomb.generateCorridor(gen, biome, rand, wet);
                            SwampTomb.generateCorridor(gen.add(center, Rotation.NONE, Mirror.FRONT_BACK), biome, rand, wet);
                        }
                    } else {
                        TombGen.generateEntrance(gen, biome, rand, 0, wet, type);
                        SwampTomb.generateRoom(gen, biome, rand, false, false, wet);
                    }
                    return true;
                }
                if (TombGenBase.roomCheck(gen, -2, 2, -7, -1, 1, 6, false)) {
                    TombGen.generateEntrance(gen, biome, rand, 0, wet, type);
                    SwampTomb.generateMiniRoom(gen, biome, biomeType, loc, rand, false, wet);
                    return true;
                }
            }
            return false;
        }

        private static void generateRoom(GenUtil gen, BiomeMist biome, Random rand, boolean mini, boolean back, boolean wet) {
            SwampTomb.generateRoom(gen, biome, rand, mini, back, true, wet);
        }

        private static void generateRoom(GenUtil gen, BiomeMist biome, Random rand, boolean mini, boolean back, boolean backUrn, boolean wet) {
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            for (int x = -4; x <= 4; ++x) {
                for (int z = 1; z <= 7; ++z) {
                    for (int y = -6; y <= -2; ++y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (x == -4 || x == 4 || y == -2 || z == 1 || z == 7) {
                            if (x >= -1 && x <= 1 && !(back ? x != 0 || y < -3 || z > 2 || z == 2 && gen.getBlockState(checkPos).func_185917_h() : z != 1)) continue;
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == -6) {
                            gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                            continue;
                        }
                        if (y == -3) {
                            if (z == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (z == 6) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == -3) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 3) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == -1 || x == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getSlab(type, true, rand, wet ? 0 : d));
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            SwampTomb.generateGrave(gen, center.func_177982_a(0, -5, 7), Rotation.NONE, rand, wet);
            if (mini) {
                SwampTomb.generateGrave(gen, center.func_177982_a(-2, -5, 7), Rotation.NONE, rand, wet);
                SwampTomb.generateGrave(gen, center.func_177982_a(2, -5, 7), Rotation.NONE, rand, wet);
                gen.setBlockState(center.func_177982_a(-5, -4, 5), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                gen.setBlockState(center.func_177982_a(5, -4, 5), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                gen.setBlockState(center.func_177982_a(-5, -4, 3), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                gen.setBlockState(center.func_177982_a(5, -4, 3), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                TombGenBase.placeUrn(gen, center.func_177982_a(-4, -4, 5), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(4, -4, 5), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(-4, -4, 3), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(4, -4, 3), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(-1, -5, 6), biomeType, loc, rand, false);
                TombGenBase.placeUrn(gen, center.func_177982_a(1, -5, 6), biomeType, loc, rand, false);
                if (back) {
                    TombGenBase.placeUrn(gen, center.func_177982_a(-1, -4, 1), biomeType, loc, rand, true);
                    TombGenBase.placeUrn(gen, center.func_177982_a(1, -4, 1), biomeType, loc, rand, true);
                }
            } else {
                SwampTomb.generateGrave(gen, center.func_177982_a(-4, -5, 3), Rotation.CLOCKWISE_90, rand, wet);
                SwampTomb.generateGrave(gen, center.func_177982_a(-4, -5, 5), Rotation.CLOCKWISE_90, rand, wet);
                SwampTomb.generateGrave(gen, center.func_177982_a(4, -5, 3), Rotation.COUNTERCLOCKWISE_90, rand, wet);
                SwampTomb.generateGrave(gen, center.func_177982_a(4, -5, 5), Rotation.COUNTERCLOCKWISE_90, rand, wet);
                gen.setBlockState(center.func_177982_a(-2, -4, 8), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                gen.setBlockState(center.func_177982_a(2, -4, 8), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                TombGenBase.placeUrn(gen, center.func_177982_a(-2, -4, 7), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(2, -4, 7), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(-3, -5, 2), biomeType, loc, rand, false);
                TombGenBase.placeUrn(gen, center.func_177982_a(-3, -5, 4), biomeType, loc, rand, false);
                TombGenBase.placeUrn(gen, center.func_177982_a(3, -5, 2), biomeType, loc, rand, false);
                TombGenBase.placeUrn(gen, center.func_177982_a(3, -5, 4), biomeType, loc, rand, false);
                if (backUrn) {
                    gen.setBlockState(center.func_177982_a(-2, -4, 0), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    gen.setBlockState(center.func_177982_a(2, -4, 0), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    TombGenBase.placeUrn(gen, center.func_177982_a(-2, -4, 1), biomeType, loc, rand, true);
                    TombGenBase.placeUrn(gen, center.func_177982_a(2, -4, 1), biomeType, loc, rand, true);
                }
            }
            TombGenBase.placeUrn(gen, center.func_177982_a(-3, -5, 6), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(3, -5, 6), biomeType, loc, rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -4, 6), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(3, -4, 6), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -4, 2), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(3, -4, 2), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-2, -3, 5), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(2, -3, 5), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-2, -3, 3), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(2, -3, 3), rand, false);
        }

        public static void generateMiniRoom(GenUtil gen, BiomeMist biome, EnumBiomeType biomeType, TileEntityUrn.UrnLocation loc, Random rand, boolean close, boolean wet) {
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            for (int x = -2; x <= 2; ++x) {
                for (int z = 1; z <= 6; ++z) {
                    for (int y = -6; y <= -2; ++y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (x == -2 || x == 2 || y == -2 || z == 1 || z == 6) {
                            if (!(close ? y != -6 : z != 1)) continue;
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == -6) {
                            if (close) continue;
                            gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                            continue;
                        }
                        if (y == -3) {
                            if (x == -1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (z == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (z == 5) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            if (rand.nextInt(3) == 0) {
                SwampTomb.generateGrave(gen, center.func_177982_a(0, -5, 6), Rotation.NONE, rand, wet);
                TombGenBase.placeUrn(gen, center.func_177982_a(-1, -5, 5), biomeType, loc, rand, false);
                TombGenBase.placeUrn(gen, center.func_177982_a(1, -5, 5), biomeType, loc, rand, false);
                TombGenBase.placeWeb(gen, center.func_177982_a(-1, -4, 5), rand, false);
                TombGenBase.placeWeb(gen, center.func_177982_a(1, -4, 5), rand, false);
            } else {
                SwampTomb.generateGrave(gen, center.func_177982_a(-1, -5, 6), Rotation.NONE, rand, wet);
                SwampTomb.generateGrave(gen, center.func_177982_a(1, -5, 6), Rotation.NONE, rand, wet);
                TombGenBase.placeUrn(gen, center.func_177982_a(0, -5, 5), biomeType, loc, rand, false);
            }
            gen.setBlockState(center.func_177982_a(-3, -4, 3), TombGenBase.getBlock(type, rand, wet ? 0 : d));
            gen.setBlockState(center.func_177982_a(3, -4, 3), TombGenBase.getBlock(type, rand, wet ? 0 : d));
            TombGenBase.placeUrn(gen, center.func_177982_a(-2, -4, 3), biomeType, loc, rand, true);
            TombGenBase.placeUrn(gen, center.func_177982_a(2, -4, 3), biomeType, loc, rand, true);
            TombGenBase.placeWeb(gen, center.func_177982_a(-1, -5, 2), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(1, -5, 2), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(0, -3, 4), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(0, -3, 3), rand, false);
        }

        private static void generateCorridor(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            boolean miniRoom = rand.nextBoolean();
            boolean room = rand.nextInt(4) == 0;
            GenUtil gen90 = null;
            if (miniRoom) {
                gen90 = gen.add(center.func_177982_a(-4, 0, -1), Rotation.CLOCKWISE_90, Mirror.NONE);
                if (room) {
                    room = miniRoom = TombGenBase.roomCheck(gen90, -4, 4, -7, -1, 2, 7, false);
                }
                if (!miniRoom) {
                    miniRoom = TombGenBase.roomCheck(gen90, -2, 2, -6, -1, 2, 6, false);
                }
            }
            for (int x = -5; x <= -2; ++x) {
                for (int z = -3; z <= 1; ++z) {
                    for (int y = -6; y <= -2; ++y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (x == -5 || y == -2 || z == -3 || z == 1) {
                            if (x != -5 && y != -2) continue;
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == -6) {
                            gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                            continue;
                        }
                        if (y == -3) {
                            if (x == -4) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (z == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (z == 0) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (!(y != -5 || x == -3 || miniRoom && x == -4)) {
                            if (z == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, false, rand, wet ? 0 : d));
                                gen.setBlockState(checkPos.func_177977_b(), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            if (z == 0) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d));
                                gen.setBlockState(checkPos.func_177977_b(), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getSlab(type, false, rand, wet ? 0 : d));
                            gen.setBlockState(checkPos.func_177977_b(), MistBlocks.FLOATING_MAT.func_176223_P());
                            gen.setBlockState(checkPos.func_177977_b(), MistBlocks.REMAINS.func_176223_P().func_177226_a((IProperty)Remains.LAYERS, (Comparable)Integer.valueOf(rand.nextInt(3) + 4)).func_177226_a((IProperty)Remains.OLD, (Comparable)Boolean.valueOf(true)));
                            ((TileEntityRemains)gen.getTileEntity(checkPos.func_177977_b())).func_189404_a(LootTables.REMAINS_LOOT, rand.nextLong());
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -4, -3), rand, true);
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -5, -3), rand, true);
            gen.setBlockState(center.func_177982_a(-3, -6, -3), MistBlocks.GRAVEL.func_176223_P());
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -4, 1), rand, true);
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -5, 1), rand, true);
            gen.setBlockState(center.func_177982_a(-3, -6, 1), MistBlocks.GRAVEL.func_176223_P());
            TombGenBase.placeWeb(gen, center.func_177982_a(-4, -4, 0), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-2, -4, 0), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-4, -4, -2), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-2, -4, -2), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -3, -1), rand, false);
            if (miniRoom) {
                if (room) {
                    SwampTomb.generateRoom(gen90, biome, rand, false, false, wet);
                } else {
                    SwampTomb.generateMiniRoom(gen90, biome, biomeType, loc, rand, false, wet);
                }
                TombGenBase.placeWeb(gen, center.func_177982_a(-5, -4, -1), rand, true);
                TombGenBase.placeWeb(gen, center.func_177982_a(-5, -5, -1), rand, true);
                gen.setBlockState(center.func_177982_a(-5, -6, -1), MistBlocks.GRAVEL.func_176223_P());
            } else {
                gen.setBlockState(center.func_177982_a(-6, -4, -1), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                TombGenBase.placeUrn(gen, center.func_177982_a(-5, -4, -1), biomeType, loc, rand, true);
            }
        }

        private static void generateStairs(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            boolean miniRoom = rand.nextBoolean();
            boolean room = rand.nextInt(4) == 0;
            GenUtil gen90 = null;
            if (miniRoom) {
                gen90 = gen.add(center.func_177982_a(-3, -2, -2), Rotation.CLOCKWISE_90, Mirror.NONE);
                if (room) {
                    room = miniRoom = TombGenBase.roomCheck(gen90, -4, 4, -7, -1, 2, 7, false);
                }
                if (!miniRoom) {
                    miniRoom = TombGenBase.roomCheck(gen90, -2, 2, -6, -1, 2, 6, false);
                }
            }
            for (int x = -4; x <= -2; ++x) {
                for (int z = -3; z <= 1; ++z) {
                    for (int y = -8; y <= -3; ++y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (x == -4 || x == -2 || y == -3 || z == -3 || z == 1) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (z >= -1) {
                            if (y == z - 6) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d));
                                continue;
                            }
                            if (y < z - 6) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        if (y == -8) {
                            gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                            continue;
                        }
                        TombGenBase.placeWeb(gen, checkPos, rand, true);
                    }
                }
            }
            gen.setBlockState(center.func_177982_a(-3, -5, -3), TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 0 : d));
            gen.setBlockState(center.func_177982_a(-3, -4, -2), TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 0 : d));
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -6, -3), rand, true);
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -7, -3), rand, true);
            gen.setBlockState(center.func_177982_a(-3, -8, -3), MistBlocks.GRAVEL.func_176223_P());
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -4, 1), rand, true);
            TombGenBase.placeWeb(gen, center.func_177982_a(-3, -5, 1), rand, true);
            gen.setBlockState(center.func_177982_a(-3, -6, 1), MistBlocks.GRAVEL.func_176223_P());
            if (miniRoom) {
                if (room) {
                    SwampTomb.generateRoom(gen90, biome, rand, false, false, false, wet);
                } else {
                    SwampTomb.generateMiniRoom(gen90, biome, biomeType, loc, rand, false, wet);
                }
                TombGenBase.placeWeb(gen, center.func_177982_a(-4, -6, -2), rand, true);
                TombGenBase.placeWeb(gen, center.func_177982_a(-4, -7, -2), rand, true);
                gen.setBlockState(center.func_177982_a(-4, -8, -2), MistBlocks.GRAVEL.func_176223_P());
            }
        }

        private static void generateGrave(GenUtil gen, BlockPos center, Rotation rotation, Random rand, boolean wet) {
            IBlockState state;
            GenUtil genRot = gen.add(center, rotation, Mirror.NONE);
            center = genRot.set.center;
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            genRot.setBlockState(center, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d));
            genRot.setBlockState(center.func_177984_a(), TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
            int i = rand.nextInt(32);
            boolean close = false;
            if (i == 0) {
                state = Blocks.field_150350_a.func_176223_P();
            } else if (i == 1) {
                state = TombGenBase.getStep(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d);
            } else if (i == 2) {
                state = TombGenBase.getStep(type, EnumFacing.EAST, false, rand, wet ? 0 : d);
            } else if (i == 3) {
                state = TombGenBase.getStep(type, EnumFacing.WEST, false, rand, wet ? 0 : d);
            } else {
                state = TombGenBase.getSlab(type, false, rand, wet ? 0 : d);
                close = true;
            }
            genRot.setBlockState(center.func_177978_c(), state);
            state = i > 3 ? ((i = rand.nextInt(16)) == 0 ? Blocks.field_150350_a.func_176223_P() : (i == 1 ? TombGenBase.getStep(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d) : (i == 2 ? TombGenBase.getStep(type, EnumFacing.EAST, false, rand, wet ? 0 : d) : (i == 3 ? TombGenBase.getStep(type, EnumFacing.WEST, false, rand, wet ? 0 : d) : TombGenBase.getSlab(type, false, rand, wet ? 0 : d))))) : Blocks.field_150350_a.func_176223_P();
            genRot.setBlockState(center.func_177964_d(2), state);
            if (close && i == 0 && rand.nextInt(4) == 0) {
                if (rand.nextBoolean()) {
                    genRot.setBlockState(center.func_177964_d(2).func_177974_f(), TombGenBase.getStep(type, EnumFacing.WEST, false, rand, wet ? 0 : d));
                } else {
                    genRot.setBlockState(center.func_177964_d(2).func_177976_e(), TombGenBase.getStep(type, EnumFacing.EAST, false, rand, wet ? 0 : d));
                }
            }
            int size = rand.nextInt(3) + 4;
            genRot.setBlockState(center.func_177978_c().func_177977_b(), MistBlocks.REMAINS.func_176223_P().func_177226_a((IProperty)Remains.LAYERS, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)Remains.OLD, (Comparable)Boolean.valueOf(true)));
            genRot.setBlockState(center.func_177964_d(2).func_177977_b(), MistBlocks.REMAINS.func_176223_P().func_177226_a((IProperty)Remains.LAYERS, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)Remains.OLD, (Comparable)Boolean.valueOf(true)));
            ((TileEntityRemains)genRot.getTileEntity(center.func_177978_c().func_177977_b())).func_189404_a(LootTables.REMAINS_LOOT, rand.nextLong());
            ((TileEntityRemains)genRot.getTileEntity(center.func_177964_d(2).func_177977_b())).func_189404_a(LootTables.REMAINS_LOOT, rand.nextLong());
        }
    }

    public static class ForestTomb {
        private static final EnumBiomeType biomeType = EnumBiomeType.Forest;

        public static boolean generate(World world, BlockPos center, BiomeMist biome, Random rand) {
            boolean mini;
            int offset = rand.nextInt(3);
            GenUtil gen = new GenUtil(world, new GenUtil.GenSet(center, Rotation.CLOCKWISE_90, Mirror.NONE));
            boolean bl = mini = rand.nextInt(3) == 0;
            if (TombGenBase.roomCheck(gen, -1, 1, -6 - offset, -1, -5 - offset, 0, true)) {
                boolean check = false;
                if (!mini) {
                    if (TombGenBase.roomCheck(gen, -4, 4, -6 - offset, -1 + offset, 1, 5 + offset, false)) {
                        check = true;
                    } else {
                        mini = true;
                    }
                }
                if (mini) {
                    check = TombGenBase.roomCheck(gen, -3, 3, -6 - offset, -1 + offset, 1, 5 + offset, false);
                }
                if (check) {
                    int i;
                    int f = mini ? 3 : 4;
                    TombGen.generateEntrance(gen, biome, rand, offset, true, TombGenBase.Type.BRICK);
                    int j = (mini ? 1 : 2) - rand.nextInt(rand.nextInt(mini ? 2 : 3) + 1);
                    for (i = 0; i < j; ++i) {
                        if (TombGenBase.roomCheck(gen, -f, f, -6 - offset, -1 - offset, 6 + offset + i * 2, 7 + offset + i * 2, false)) continue;
                        j = i;
                        break;
                    }
                    ++j;
                    for (i = 0; i < j; ++i) {
                        if (mini) {
                            ForestTomb.generateMiniRoomPart(gen.add(center.func_177982_a(0, -6 - offset, 2 + i * 2), Rotation.NONE, Mirror.NONE), biome, biomeType, loc, rand, false, i == 0, i == j - 1, true);
                            continue;
                        }
                        ForestTomb.generateRoomPart(gen.add(center.func_177982_a(0, -6 - offset, 2 + i * 2), Rotation.NONE, Mirror.NONE), biome, rand, i == 0, i == j - 1, true);
                    }
                    return true;
                }
            }
            return false;
        }

        private static void generateRoomPart(GenUtil gen, BiomeMist biome, Random rand, boolean start, boolean end, boolean wet) {
            BlockPos checkPos;
            int y;
            int x;
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.BRICK;
            for (x = -4; x <= 4; ++x) {
                for (int z = 0; z <= 2; ++z) {
                    for (y = 0; y <= 4; ++y) {
                        checkPos = center.func_177982_a(x, y, z);
                        if (z == 1) {
                            if (x == -4 || x == 4 || y == 4) {
                                if (y == 4) {
                                    if (x >= -1 && x <= 1) {
                                        gen.setBlockState(checkPos, TombGenBase.getSlab(type, true, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            if (y == 3) {
                                if (x == -3) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (x == 3) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (x == -2 || x == 2) {
                                    TombGenBase.placeWeb(gen, checkPos, rand, true);
                                    continue;
                                }
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            if (y == 2) {
                                if (x == -3 || x == 3) {
                                    TombGenBase.placeWeb(gen, checkPos, rand, true);
                                    continue;
                                }
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            if (y == 0) {
                                if (x == -3 || x == 3) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (!end && z != 0) continue;
                        if (x == -4 || x == 4 || y == 4) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == 3) {
                            if (x == 3 || x == -3) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == -1) {
                                gen.setBlockState(checkPos, TombGenBase.getStep(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStep(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (y == 2) {
                            if (x == -3) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 3) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == -2 || x == 2) {
                                TombGenBase.placeWeb(gen, checkPos, rand, true);
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (y == 1) {
                            if (x == -3) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, false, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 3) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, false, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == -2 || x == 2) {
                                TombGenBase.placeWeb(gen, checkPos, rand, true);
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (x == -3 || x == 3) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                    }
                }
            }
            if (start || rand.nextInt(3) != 0) {
                ForestTomb.generateGrave(gen, center.func_177982_a(-3, 1, 1), Rotation.CLOCKWISE_90, rand, wet);
                ForestTomb.generateGrave(gen, center.func_177982_a(3, 1, 1), Rotation.COUNTERCLOCKWISE_90, rand, wet);
            } else {
                if (rand.nextBoolean() && gen.getBlockState(center.func_177982_a(-3, 0, -1)).func_177230_c() == MistBlocks.REMAINS) {
                    if (ForestTomb.generateMiniRoom(gen.add(center.func_177982_a(-3, 0, 1), Rotation.CLOCKWISE_90, Mirror.NONE), biome, biomeType, loc, rand, false, wet)) {
                        gen.setBlockState(center.func_177982_a(-3, 0, 1), MistBlocks.GRAVEL.func_176223_P());
                        gen.setBlockState(center.func_177982_a(-4, 0, 1), MistBlocks.GRAVEL.func_176223_P());
                        TombGenBase.placeWeb(gen, center.func_177982_a(-4, 1, 1), rand, true);
                        TombGenBase.placeWeb(gen, center.func_177982_a(-4, 2, 1), rand, true);
                    } else {
                        ForestTomb.generateGrave(gen, center.func_177982_a(-3, 1, 1), Rotation.CLOCKWISE_90, rand, wet);
                    }
                } else {
                    ForestTomb.generateGrave(gen, center.func_177982_a(-3, 1, 1), Rotation.CLOCKWISE_90, rand, wet);
                }
                if (rand.nextBoolean() && gen.getBlockState(center.func_177982_a(3, 0, -1)).func_177230_c() == MistBlocks.REMAINS) {
                    if (ForestTomb.generateMiniRoom(gen.add(center.func_177982_a(3, 0, 1), Rotation.COUNTERCLOCKWISE_90, Mirror.NONE), biome, biomeType, loc, rand, false, wet)) {
                        gen.setBlockState(center.func_177982_a(3, 0, 1), MistBlocks.GRAVEL.func_176223_P());
                        gen.setBlockState(center.func_177982_a(4, 0, 1), MistBlocks.GRAVEL.func_176223_P());
                        TombGenBase.placeWeb(gen, center.func_177982_a(4, 1, 1), rand, true);
                        TombGenBase.placeWeb(gen, center.func_177982_a(4, 2, 1), rand, true);
                    } else {
                        ForestTomb.generateGrave(gen, center.func_177982_a(3, 1, 1), Rotation.COUNTERCLOCKWISE_90, rand, wet);
                    }
                } else {
                    ForestTomb.generateGrave(gen, center.func_177982_a(3, 1, 1), Rotation.COUNTERCLOCKWISE_90, rand, wet);
                }
            }
            if (start) {
                for (x = -4; x <= 4; ++x) {
                    for (int y2 = 0; y2 <= 4; ++y2) {
                        checkPos = center.func_177982_a(x, y2, -1);
                        if (x >= -1 && x <= 1) continue;
                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    }
                }
            }
            if (end) {
                int z;
                int x2;
                int i = rand.nextInt(3);
                if (i == 0) {
                    for (x2 = -4; x2 <= 4; ++x2) {
                        for (y = 0; y <= 4; ++y) {
                            checkPos = center.func_177982_a(x2, y, 3);
                            if (y == 3 && x2 >= -1 && x2 <= 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x2 >= -1 && x2 <= 1 && y == 2) continue;
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                        }
                    }
                    gen.setBlockState(center.func_177982_a(-1, 2, 4), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    gen.setBlockState(center.func_177982_a(0, 2, 4), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    gen.setBlockState(center.func_177982_a(1, 2, 4), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    TombGenBase.placeUrn(gen, center.func_177982_a(-1, 2, 3), biomeType, loc, rand, true, 3);
                    TombGenBase.placeUrn(gen, center.func_177982_a(0, 2, 3), biomeType, loc, rand, true, 3);
                    TombGenBase.placeUrn(gen, center.func_177982_a(1, 2, 3), biomeType, loc, rand, true, 3);
                } else if (i == 1) {
                    for (x2 = -4; x2 <= 4; ++x2) {
                        for (z = 3; z <= 5; ++z) {
                            for (int y3 = 0; y3 <= 4; ++y3) {
                                checkPos = center.func_177982_a(x2, y3, z);
                                if (x2 == -4 || x2 == 4 || y3 == 4 || z == 5) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y3 == 0) {
                                    if (x2 == -3 || x2 == 3 || z == 4) {
                                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                                    continue;
                                }
                                if (z == 3) {
                                    if (y3 == 3) {
                                        if (x2 == -3 || x2 == 3) {
                                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        if (x2 == -1 || x2 == 1) {
                                            gen.setBlockState(checkPos, TombGenBase.getSlab(type, true, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    if (y3 == 2) {
                                        if (x2 == -3) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        if (x2 == 3) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        if (x2 == -2 || x2 == 2) {
                                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                                            continue;
                                        }
                                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                        continue;
                                    }
                                    if (y3 != 1) continue;
                                    if (x2 == -3) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, false, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    if (x2 == 3) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, false, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    if (x2 == -1 || x2 == 1) continue;
                                    TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true);
                                    continue;
                                }
                                if (y3 == 3) {
                                    if (x2 != -1 && x2 != 1) {
                                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y3 == 2) {
                                    if (x2 == -3 || x2 == 3) {
                                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    if (x2 != -1 && x2 != 1) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    TombGenBase.placeWeb(gen, checkPos, rand, true);
                                    continue;
                                }
                                if (y3 != 1) continue;
                                if (x2 == -3 || x2 == 3) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (x2 == -1 || x2 == 1) continue;
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d));
                            }
                        }
                    }
                    gen.setBlockState(center.func_177982_a(0, 3, 2), TombGenBase.getStep(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                    ForestTomb.generateGrave(gen, center.func_177982_a(-1, 1, 4), Rotation.NONE, rand, wet);
                    ForestTomb.generateGrave(gen, center.func_177982_a(1, 1, 4), Rotation.NONE, rand, wet);
                } else {
                    for (x2 = -4; x2 <= 4; ++x2) {
                        for (z = 3; z <= 5; ++z) {
                            for (int y4 = 0; y4 <= 4; ++y4) {
                                checkPos = center.func_177982_a(x2, y4, z);
                                if (x2 <= -2 || x2 >= 2 || y4 == 4 || z == 5) {
                                    if (z != 3 && (x2 < -2 || x2 > 2)) continue;
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (x2 == 0) {
                                    if (y4 <= 1) continue;
                                    if (z == 3) {
                                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                        continue;
                                    }
                                    if (y4 == 2) {
                                        TombGenBase.placeWeb(gen, checkPos, rand, true);
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (z == 3) {
                                    if (y4 == 0) {
                                        gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                                        continue;
                                    }
                                    if (y4 == 1) {
                                        TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true);
                                        continue;
                                    }
                                    if (y4 == 2) {
                                        TombGenBase.placeWeb(gen, checkPos, rand, true);
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y4 == 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y4 == 2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            }
                        }
                    }
                    ForestTomb.generateGrave(gen, center.func_177982_a(0, 1, 4), Rotation.NONE, rand, wet);
                    TombGenBase.placeUrn(gen, center.func_177982_a(-2, 1, 2), biomeType, loc, rand, false);
                    TombGenBase.placeUrn(gen, center.func_177982_a(2, 1, 2), biomeType, loc, rand, false);
                }
            }
        }

        public static boolean generateMiniRoom(GenUtil gen, BiomeMist biome, EnumBiomeType biomeType, TileEntityUrn.UrnLocation loc, Random rand, boolean close, boolean wet) {
            if (TombGenBase.roomCheck(gen, -3, 3, 0, 4, 1, 5, false)) {
                int i;
                int j = rand.nextInt(2);
                for (i = 0; i < j; ++i) {
                    if (TombGenBase.roomCheck(gen, -3, 3, 0, 4, 6 + i * 2, 7 + i * 2, false)) continue;
                    j = i;
                    break;
                }
                ++j;
                for (i = 0; i < j; ++i) {
                    ForestTomb.generateMiniRoomPart(gen.add(gen.set.center.func_177982_a(0, 0, 2 + i * 2), Rotation.NONE, Mirror.NONE), biome, biomeType, loc, rand, close, i == 0, i == j - 1, wet);
                }
                return true;
            }
            return false;
        }

        private static void generateMiniRoomPart(GenUtil gen, BiomeMist biome, EnumBiomeType biomeType, TileEntityUrn.UrnLocation loc, Random rand, boolean close, boolean start, boolean end, boolean wet) {
            BlockPos checkPos;
            int y;
            int x;
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.BRICK;
            for (x = -3; x <= 3; ++x) {
                for (int z = 0; z <= 2; ++z) {
                    for (y = 0; y <= 4; ++y) {
                        checkPos = center.func_177982_a(x, y, z);
                        if (z == 1) {
                            if (x == -3 || x == 3 || y == 4) {
                                if (close && y <= 0) continue;
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            if (y == 0) {
                                if (close || x != 0) continue;
                                gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                                continue;
                            }
                            if (y == 1) {
                                if (x != 0) continue;
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            if (y == 2) {
                                if (x == -2 || x == 2) {
                                    TombGenBase.placeWeb(gen, checkPos, rand, true);
                                    continue;
                                }
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            if (x == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 0) {
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        if (!end && z != 0) continue;
                        if (x == -3 || x == 3 || y == 4) {
                            if (close && y <= 0) continue;
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == 0) {
                            if (close) continue;
                            if (x == -2 || x == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                            continue;
                        }
                        if (y == 1) {
                            if (x == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, false, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, false, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 0) {
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        if (y == 2) {
                            if (x == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 0) {
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        if (x == 0) {
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        if (x == -1) {
                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                            continue;
                        }
                        if (x == 1) {
                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                            continue;
                        }
                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    }
                }
            }
            ForestTomb.generateGrave(gen, center.func_177982_a(-2, 1, 1), Rotation.CLOCKWISE_90, rand, wet);
            ForestTomb.generateGrave(gen, center.func_177982_a(2, 1, 1), Rotation.COUNTERCLOCKWISE_90, rand, wet);
            if (start) {
                for (x = -3; x <= 3; ++x) {
                    for (int y2 = 0; y2 <= 4; ++y2) {
                        checkPos = center.func_177982_a(x, y2, -1);
                        if (x >= -1 && x <= 1) continue;
                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    }
                }
            }
            if (end) {
                int x2;
                int i = rand.nextInt(3);
                if (rand.nextBoolean()) {
                    for (x2 = -3; x2 <= 3; ++x2) {
                        for (y = 0; y <= 4; ++y) {
                            checkPos = center.func_177982_a(x2, y, 3);
                            if (y == 3 && x2 == 0) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x2 == 0 && y == 2) continue;
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                        }
                    }
                    gen.setBlockState(center.func_177982_a(0, 2, 4), TombGenBase.getBlock(type, rand, wet ? 0 : d));
                    TombGenBase.placeUrn(gen, center.func_177982_a(0, 2, 3), biomeType, loc, rand, true, 2);
                } else {
                    for (x2 = -3; x2 <= 3; ++x2) {
                        for (int z = 3; z <= 5; ++z) {
                            for (int y3 = 0; y3 <= 4; ++y3) {
                                checkPos = center.func_177982_a(x2, y3, z);
                                if (x2 <= -3 || x2 >= 3 || y3 == 4 || z == 5) {
                                    if (z == 5 && (x2 == -3 || x2 == 3)) continue;
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (z == 3) {
                                    if (y3 == 0) {
                                        if (close) continue;
                                        if (x2 == -2 || x2 == 2) {
                                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        if (x2 == 0) continue;
                                        gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                                        continue;
                                    }
                                    if (y3 == 1) {
                                        if (x2 == -2) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, false, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        if (x2 == 2) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, false, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        if (x2 == 0) continue;
                                        TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true);
                                        continue;
                                    }
                                    if (y3 == 2) {
                                        if (x2 == -2) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        if (x2 == 2) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                            continue;
                                        }
                                        if (x2 == 0) {
                                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                            continue;
                                        }
                                        TombGenBase.placeWeb(gen, checkPos, rand, true);
                                        continue;
                                    }
                                    if (x2 == -2 || x2 == 2) {
                                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    if (x2 == 0) {
                                        TombGenBase.placeWeb(gen, checkPos, rand, true);
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y3 == 0) {
                                    if (x2 == 0) continue;
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y3 == 1) {
                                    if (x2 == -2 || x2 == 2) {
                                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    if (x2 == 0) continue;
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y3 == 2) {
                                    if (x2 == -2 || x2 == 2) {
                                        gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                        continue;
                                    }
                                    if (x2 == 0) {
                                        TombGenBase.placeWeb(gen, checkPos, rand, true);
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (x2 == 0) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            }
                        }
                    }
                    ForestTomb.generateGrave(gen, center.func_177982_a(0, 1, 4), Rotation.NONE, rand, wet);
                }
            }
        }

        private static void generateGrave(GenUtil gen, BlockPos center, Rotation rotation, Random rand, boolean wet) {
            GenUtil genRot = gen.add(center, rotation, Mirror.NONE);
            center = genRot.set.center;
            TombGenBase.Type type = rand.nextInt(3) == 0 ? TombGenBase.Type.COBBLE : TombGenBase.Type.BRICK;
            genRot.setBlockState(center, TombGenBase.getSlab(type, false, rand, wet ? 0 : d));
            int i = rand.nextInt(16);
            IBlockState state = i == 0 ? Blocks.field_150350_a.func_176223_P() : (i == 1 ? TombGenBase.getStep(type, EnumFacing.EAST, false, rand, wet ? 0 : d) : (i == 2 ? TombGenBase.getStep(type, EnumFacing.WEST, false, rand, wet ? 0 : d) : (i < 6 ? TombGenBase.getStep(type, EnumFacing.SOUTH, false, rand, wet ? 0 : d) : TombGenBase.getSlab(type, false, rand, wet ? 0 : d))));
            genRot.setBlockState(center.func_177978_c(), state);
            int size = rand.nextInt(3) + 4;
            genRot.setBlockState(center.func_177977_b(), MistBlocks.REMAINS.func_176223_P().func_177226_a((IProperty)Remains.LAYERS, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)Remains.OLD, (Comparable)Boolean.valueOf(true)));
            genRot.setBlockState(center.func_177978_c().func_177977_b(), MistBlocks.REMAINS.func_176223_P().func_177226_a((IProperty)Remains.LAYERS, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)Remains.OLD, (Comparable)Boolean.valueOf(true)));
            ((TileEntityRemains)genRot.getTileEntity(center.func_177977_b())).func_189404_a(LootTables.REMAINS_LOOT, rand.nextLong());
            ((TileEntityRemains)genRot.getTileEntity(center.func_177978_c().func_177977_b())).func_189404_a(LootTables.REMAINS_LOOT, rand.nextLong());
        }
    }

    public static class SavannaTomb {
        private static final EnumBiomeType biomeType = EnumBiomeType.Desert;

        public static boolean generate(World world, BlockPos center, BiomeMist biome, Random rand) {
            GenUtil gen = new GenUtil(world, new GenUtil.GenSet(center, Rotation.CLOCKWISE_90, Mirror.NONE));
            if (TombGenBase.roomCheck(gen, -1, 2, -6, -1, -3, 0, true) && TombGenBase.roomCheck(gen, -1, 2, -6, -1, 1, 4, false) && (rand.nextInt(3) == 0 && SavannaTomb.generateCross(gen.add(center.func_177982_a(0, -6, 5), Rotation.NONE, Mirror.NONE), biome, rand, false, 1) || SavannaTomb.generateRoom(gen.add(center.func_177982_a(0, -6, 5), Rotation.NONE, Mirror.NONE), biome, rand, false, 0))) {
                SavannaTomb.generateSavannaEntrance(gen, biome, rand, false);
                return true;
            }
            return false;
        }

        private static boolean generateRoom(GenUtil gen, BiomeMist biome, Random rand, boolean wet, int count) {
            if (TombGenBase.roomCheck(gen, -2, 3, 0, 5, 0, 3, false)) {
                int i;
                boolean check = true;
                int j = rand.nextInt(3);
                for (i = 0; i < j; ++i) {
                    if (TombGenBase.roomCheck(gen, -2, 3, 0, 5, 4 + i * 2, 5 + i * 2, false)) continue;
                    if (i == 0) {
                        check = false;
                    }
                    j = i;
                    break;
                }
                if (check) {
                    ++j;
                    for (i = 0; i < j; ++i) {
                        SavannaTomb.generateRoomPart(gen.add(gen.set.center.func_177982_a(0, 0, i * 2), Rotation.NONE, Mirror.NONE), biome, rand, i == j - 1, wet, count);
                    }
                    return true;
                }
            }
            return false;
        }

        private static boolean generateCross(GenUtil gen, BiomeMist biome, Random rand, boolean wet, int count) {
            if (TombGenBase.roomCheck(gen, -3, 4, 0, 5, 0, 4, false)) {
                boolean check = false;
                GenUtil gen1 = gen.add(gen.set.center.func_177982_a(0, 0, 3), Rotation.NONE, Mirror.NONE);
                if (SavannaTomb.generateRoom(gen1, biome, rand, wet, count)) {
                    SavannaTomb.generateCrossWall(gen1, biome, rand, true, wet);
                    check = true;
                } else {
                    SavannaTomb.generateCrossWall(gen1, biome, rand, false, wet);
                }
                gen1 = gen.add(gen.set.center.func_177982_a(-2, 0, 0), Rotation.CLOCKWISE_90, Mirror.NONE);
                if (SavannaTomb.generateRoom(gen1, biome, rand, wet, count)) {
                    SavannaTomb.generateCrossWall(gen1, biome, rand, true, wet);
                    check = true;
                } else {
                    SavannaTomb.generateCrossWall(gen1, biome, rand, false, wet);
                }
                gen1 = gen.add(gen.set.center.func_177982_a(3, 0, 1), Rotation.COUNTERCLOCKWISE_90, Mirror.NONE);
                if (SavannaTomb.generateRoom(gen1, biome, rand, wet, count)) {
                    SavannaTomb.generateCrossWall(gen1, biome, rand, true, wet);
                    check = true;
                } else {
                    SavannaTomb.generateCrossWall(gen1, biome, rand, false, wet);
                }
                if (check) {
                    SavannaTomb.generateCrossWall(gen, biome, rand, true, wet);
                    SavannaTomb.generateCrossPart(gen, biome, rand, wet);
                    return true;
                }
            }
            return false;
        }

        private static void generateCrossWall(GenUtil gen, BiomeMist biome, Random rand, boolean medium, boolean wet) {
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            if (medium || rand.nextBoolean()) {
                BlockPos checkPos;
                int y;
                int x;
                if (!medium) {
                    for (x = -1; x <= 2; ++x) {
                        for (y = 0; y <= 4; ++y) {
                            checkPos = center.func_177982_a(x, y, 0);
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                        }
                    }
                }
                for (x = -1; x <= 2; ++x) {
                    for (y = 0; y <= 4; ++y) {
                        checkPos = center.func_177982_a(x, y, -1);
                        if (x == -1 || x == 2 || y == 4) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == 0) {
                            gen.setBlockState(checkPos, TombGenBase.sand);
                            continue;
                        }
                        if (y == 1) {
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (y == 2) {
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        if (x == 0) {
                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                            continue;
                        }
                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                    }
                }
            } else {
                for (int x = -1; x <= 2; ++x) {
                    for (int z = -1; z <= 0; ++z) {
                        for (int y = 0; y <= 4; ++y) {
                            BlockPos checkPos = center.func_177982_a(x, y, z);
                            if (z == -1) {
                                if (x == -1 || x == 2 || y == 4) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y == 0) {
                                    gen.setBlockState(checkPos, TombGenBase.sand);
                                    continue;
                                }
                                if (y == 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y == 2) {
                                    TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true, 2);
                                    continue;
                                }
                                if (x == 0) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                        }
                    }
                }
            }
        }

        private static void generateCrossPart(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    for (int y = 0; y <= 4; ++y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (y == 4) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == 0) {
                            gen.setBlockState(checkPos, TombGenBase.sand);
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }

        private static void generateSavannaEntrance(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            int grass = rand.nextInt(3);
            boolean mirror = rand.nextBoolean();
            for (int x = -1; x <= 2; ++x) {
                for (int z = -3; z <= 4; ++z) {
                    for (int y = -6; y <= -1; ++y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (y == -1) {
                            if (z > 0) continue;
                            if (x == -1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, false, rand, wet ? 1 : -1));
                                continue;
                            }
                            if (x == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, false, rand, wet ? 1 : -1));
                                continue;
                            }
                            if (z == 0) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 1 : -1));
                                continue;
                            }
                            if (z == -3) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, false, rand, wet ? 1 : -1));
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (x == -1 || x == 2 || z == -3 || y == -2 && z > 0) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (z < 0) {
                            if (x == 0 && (z == -2 && y <= (mirror ? -2 : -3) || z == -1 && y <= (mirror ? -5 : -4)) || x == 1 && (z == -2 && y <= (mirror ? -3 : -2) || z == -1 && y <= (mirror ? -4 : -5))) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            if (y == -2) {
                                if (grass == 0) {
                                    gen.setBlockState(checkPos, biome.field_76752_A);
                                    continue;
                                }
                                if (grass == 1) {
                                    gen.setBlockState(checkPos, biome.field_76752_A.func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.sand);
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.sand);
                            continue;
                        }
                        if (y == -6) {
                            gen.setBlockState(checkPos, TombGenBase.sand);
                            continue;
                        }
                        if (y == -2) {
                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y < -2 - z) {
                            gen.setBlockState(checkPos, TombGenBase.sand);
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            gen.setBlockState(center.func_177982_a(0, -3, 4), TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
            gen.setBlockState(center.func_177982_a(1, -3, 4), TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
            gen.setBlockState(center.func_177982_a(0, -3, 1), TombGenBase.getSlab(type, true, rand, wet ? 0 : d));
            gen.setBlockState(center.func_177982_a(1, -3, 1), TombGenBase.getSlab(type, true, rand, wet ? 0 : d));
        }

        private static void generateRoomPart(GenUtil gen, BiomeMist biome, Random rand, boolean end, boolean wet, int count) {
            BlockPos checkPos;
            int y;
            int z;
            int x;
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.COBBLE;
            for (x = -2; x <= 3; ++x) {
                for (z = 0; z <= 2; ++z) {
                    for (y = 0; y <= 4; ++y) {
                        checkPos = center.func_177982_a(x, y, z);
                        if (z == 1) {
                            if (x == -2 || x == 3) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            if (y == 4) {
                                if (x == 0) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (x == 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                continue;
                            }
                            if (y == 0) {
                                gen.setBlockState(checkPos, TombGenBase.sand);
                                continue;
                            }
                            if (x == -1) {
                                if (y == 2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true);
                                continue;
                            }
                            if (x == 2) {
                                if (y == 2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true);
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (!end && z != 0) continue;
                        if (x == -2 || x == 3) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == 4) {
                            if (x == 0) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                            continue;
                        }
                        if (y == 0) {
                            gen.setBlockState(checkPos, TombGenBase.sand);
                            continue;
                        }
                        if (x == -1) {
                            if (y == 2) {
                                TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true);
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                            continue;
                        }
                        if (x == 2) {
                            if (y == 2) {
                                TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true);
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            if (end && (count > 1 || rand.nextInt(4) != 0 || !SavannaTomb.generateCross(gen.add(center.func_177982_a(0, 0, 4), Rotation.NONE, Mirror.NONE), biome, rand, wet, count + 1))) {
                for (x = -2; x <= 3; ++x) {
                    for (z = 3; z <= 4; ++z) {
                        for (y = 0; y <= 4; ++y) {
                            checkPos = center.func_177982_a(x, y, z);
                            if (z == 3) {
                                if (x < 0 || x > 1 || y == 4) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y == 0) {
                                    gen.setBlockState(checkPos, TombGenBase.sand);
                                    continue;
                                }
                                if (y == 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                if (y == 2) {
                                    TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true, 2);
                                    continue;
                                }
                                if (x == 0) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 0 : d));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 0 : d));
                                continue;
                            }
                            if (x == -2 || x == 3) continue;
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 0 : d));
                        }
                    }
                }
                TombGenBase.placeWeb(gen, center.func_177982_a(0, 3, 2), rand, false);
                TombGenBase.placeWeb(gen, center.func_177982_a(1, 3, 2), rand, false);
            }
        }
    }

    public static class SnowTomb {
        private static final EnumBiomeType biomeType = EnumBiomeType.Cold;

        public static boolean generate(World world, BlockPos center, BiomeMist biome, Random rand) {
            GenUtil gen = new GenUtil(world, new GenUtil.GenSet(center, Rotation.values()[rand.nextInt(4)], Mirror.values()[rand.nextInt(2)]));
            if (rand.nextInt(5) != 0 && TombGenBase.roomCheck(gen, -3, 3, -6, -1, -3, 3, true)) {
                SnowTomb.generateSnowEntrance(gen, biome, rand, true);
                return true;
            }
            gen = new GenUtil(world, new GenUtil.GenSet(center.func_177982_a(0, -3, 0), Rotation.CLOCKWISE_90, Mirror.NONE));
            if (TombGenBase.roomCheck(gen, -2, 2, 0, 2, -3, 4, true)) {
                SnowTomb.generateMiniRoomPart(gen, biome, rand, true, true);
                return true;
            }
            return false;
        }

        private static void generateSnowEntrance(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.BRICK;
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    for (int y = -1; y >= -6; --y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (x >= -1 && x <= 1 && z >= -1 && z <= 1) {
                            if (y == -1) {
                                gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                            }
                            if (x == 0 || z == 0) {
                                if (y == -6) {
                                    gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                                    continue;
                                }
                                if (y == -5) {
                                    if (!gen.world.func_175710_j(gen.getPos(checkPos.func_177984_a()))) continue;
                                    gen.setBlockState(checkPos, Blocks.field_150431_aC.func_176223_P());
                                    continue;
                                }
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            int i = -1;
                            if (z == 1) {
                                i = x == -1 ? -4 : -3;
                            } else if (x == 1) {
                                i = -2;
                            }
                            if (y < i) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (y > i) {
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            if (!gen.world.func_175710_j(gen.getPos(checkPos.func_177984_a()))) continue;
                            gen.setBlockState(checkPos, Blocks.field_150431_aC.func_176223_P());
                            continue;
                        }
                        if (y == -1) {
                            if (x >= -2 && x <= 2 && z >= -2 && z <= 2) {
                                if (Math.abs(x * z) == 4) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                } else if (x == -2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 1 : 0));
                                } else if (x == 2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 1 : 0));
                                } else if (z == -2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 1 : 0));
                                } else if (z == 2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                                }
                            } else {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                            }
                            if (!gen.world.func_175710_j(gen.getPos(checkPos.func_177984_a()))) continue;
                            gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                            continue;
                        }
                        if (x == -3 || x == 3 || z == -3 || z == 3) {
                            if (Math.abs(x * z) == 9) continue;
                            if (x == 0 || z == 0) {
                                if (y == -6) {
                                    gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                                    continue;
                                }
                                if (y <= -4) {
                                    gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                    continue;
                                }
                                if (y == -3) {
                                    if (x == -3) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 1 : 0));
                                        continue;
                                    }
                                    if (x == 3) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 1 : 0));
                                        continue;
                                    }
                                    if (z == -3) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 1 : 0));
                                        continue;
                                    }
                                    if (z != 3) continue;
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                            continue;
                        }
                        if (Math.abs(x * z) == 4) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                            continue;
                        }
                        if (y == -6) {
                            gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            SnowTomb.generateRoom(gen.add(gen.set.center.func_177982_a(0, -6, 4), Rotation.NONE, Mirror.NONE), biome, rand, false);
            SnowTomb.generateRoom(gen.add(gen.set.center.func_177982_a(0, -6, -4), Rotation.CLOCKWISE_180, Mirror.NONE), biome, rand, false);
            SnowTomb.generateRoom(gen.add(gen.set.center.func_177982_a(-4, -6, 0), Rotation.CLOCKWISE_90, Mirror.NONE), biome, rand, false);
            SnowTomb.generateRoom(gen.add(gen.set.center.func_177982_a(4, -6, 0), Rotation.COUNTERCLOCKWISE_90, Mirror.NONE), biome, rand, false);
        }

        private static void generateRoom(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            TombGenBase.Type type = TombGenBase.Type.BRICK;
            if (rand.nextInt(3) == 0 && TombGenBase.roomCheck(gen, -3, 3, 0, 5, 0, 6, false)) {
                SnowTomb.generateRoomPart(gen, biome, rand, wet);
            } else if (rand.nextInt(3) != 0 && TombGenBase.roomCheck(gen, -2, 2, 0, 5, 0, 4, false)) {
                SnowTomb.generateMiniRoomPart(gen, biome, rand, false, wet);
            } else {
                BlockPos center = gen.set.center;
                for (int x = -1; x <= 1; ++x) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int y = 0; y <= 3; ++y) {
                            BlockPos checkPos = center.func_177982_a(x, y, z);
                            if (x == 0 && z == 0 && (y == 1 || y == 2)) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                        }
                    }
                }
                TombGenBase.placeUrn(gen, center.func_177982_a(0, 2, 1), biomeType, loc, rand, false, 1);
                gen.setBlockState(center.func_177982_a(0, 1, 1), TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(0, 0, 1), MistBlocks.GRAVEL.func_176223_P());
                gen.setBlockState(center.func_177982_a(0, 0, 0), MistBlocks.GRAVEL.func_176223_P());
            }
        }

        private static void generateRoomPart(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            TombGenBase.Type type = TombGenBase.Type.BRICK;
            for (int x = -3; x <= 3; ++x) {
                for (int z = 0; z <= 6; ++z) {
                    for (int y = 0; y <= 4; ++y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (y == 4) {
                            if (x <= -2 || x >= 2 || z <= 1 || z >= 5) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (x == -1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (x == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z != 4) continue;
                            gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                            continue;
                        }
                        if (x == -3 || x == 3 || z == 0 || z == 6) {
                            if (z == 0 && x == 0 && (y == 1 || y == 2)) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                            continue;
                        }
                        if (y == 0) {
                            gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                            continue;
                        }
                        if (y == 3) {
                            if (x == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (x == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.NORTH, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z == 5) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (x == 0 || z == 3) {
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            gen.setBlockState(center.func_177982_a(0, 4, 3), TombGenBase.getSlab(type, true, rand, wet ? 1 : 0));
            gen.setBlockState(center.func_177982_a(0, 0, 0), MistBlocks.GRAVEL.func_176223_P());
            SnowTomb.generateGrave(gen, center.func_177982_a(-1, 1, 6), Rotation.NONE, rand, wet);
            SnowTomb.generateGrave(gen, center.func_177982_a(1, 1, 6), Rotation.NONE, rand, wet);
            SnowTomb.generateGrave(gen, center.func_177982_a(-3, 1, 2), Rotation.CLOCKWISE_90, rand, wet);
            SnowTomb.generateGrave(gen, center.func_177982_a(-3, 1, 4), Rotation.CLOCKWISE_90, rand, wet);
            SnowTomb.generateGrave(gen, center.func_177982_a(3, 1, 2), Rotation.COUNTERCLOCKWISE_90, rand, wet);
            SnowTomb.generateGrave(gen, center.func_177982_a(3, 1, 4), Rotation.COUNTERCLOCKWISE_90, rand, wet);
            TombGenBase.placeWeb(gen, center.func_177982_a(-2, 2, 1), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(-2, 2, 5), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(2, 2, 1), rand, false);
            TombGenBase.placeWeb(gen, center.func_177982_a(2, 2, 5), rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(-2, 1, 1), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(-2, 1, 3), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(-2, 1, 5), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(0, 1, 5), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(2, 1, 5), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(2, 1, 3), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(2, 1, 1), biomeType, loc, rand, false);
        }

        private static void generateMiniRoomPart(GenUtil gen, BiomeMist biome, Random rand, boolean separate, boolean wet) {
            BlockPos checkPos;
            int y;
            int z;
            int x;
            BlockPos center = gen.set.center;
            TombGenBase.Type cobble = TombGenBase.Type.COBBLE;
            TombGenBase.Type brick = TombGenBase.Type.BRICK;
            for (x = -2; x <= 2; ++x) {
                for (z = 0; z <= 4; ++z) {
                    for (y = 0; y <= 5; ++y) {
                        checkPos = center.func_177982_a(x, y, z);
                        if (y == 5) {
                            if (!separate || x < -1 || x > 1 || z < 1 || z > 3) continue;
                            if (x == 0 && z == 2) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(cobble, rand, wet ? 1 : 0));
                                if (!gen.world.func_175710_j(gen.getPos(checkPos.func_177984_a()))) continue;
                                gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                                continue;
                            }
                            if (x == -1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(z == 1 || z == 3 ? brick : cobble, EnumFacing.EAST, false, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (x == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(z == 1 || z == 3 ? brick : cobble, EnumFacing.WEST, false, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStairs(cobble, EnumFacing.SOUTH, false, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z != 3) continue;
                            gen.setBlockState(checkPos, TombGenBase.getStairs(cobble, EnumFacing.NORTH, false, rand, wet ? 1 : 0));
                            continue;
                        }
                        if (x == -2 || x == 2 || z == 0 || z == 4 || y == 4) {
                            if (separate && y == 4) {
                                if (x == -2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(z == 0 || z == 4 ? brick : cobble, EnumFacing.EAST, false, rand, wet ? 1 : 0));
                                    continue;
                                }
                                if (x == 2) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(z == 0 || z == 4 ? brick : cobble, EnumFacing.WEST, false, rand, wet ? 1 : 0));
                                    continue;
                                }
                                if (z == 0) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(cobble, EnumFacing.SOUTH, false, rand, wet ? 1 : 0));
                                    continue;
                                }
                                if (z == 4) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(cobble, EnumFacing.NORTH, false, rand, wet ? 1 : 0));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getBlock(brick, rand, wet ? 1 : 0));
                                continue;
                            }
                            if ((y == 1 || y == 2) && (x > -2 && x < 2 || z > 0 && z < 4)) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (!(!separate || y != 3 || x != -2 && x != 2 || z != 0 && z != 4)) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (y == 0) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(brick, rand, wet ? 1 : 0));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getBlock(y == 4 ? brick : cobble, rand, wet ? 1 : 0));
                            continue;
                        }
                        if (y == 0) {
                            gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                            continue;
                        }
                        if (y == 3) {
                            if (x == -1) {
                                gen.setBlockState(checkPos, TombGenBase.getStep(brick, EnumFacing.WEST, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (x == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStep(brick, EnumFacing.EAST, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getStep(brick, EnumFacing.NORTH, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z == 3) {
                                gen.setBlockState(checkPos, TombGenBase.getStep(brick, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                                continue;
                            }
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        if (y == 2) {
                            if (x == 0 || z == 2) {
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            TombGenBase.placeWeb(gen, checkPos, rand, true);
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            gen.setBlockState(center.func_177982_a(0, 4, 2), TombGenBase.getSlab(brick, true, rand, wet ? 1 : 0));
            gen.setBlockState(center.func_177982_a(0, 3, 0), TombGenBase.getBlock(TombGenBase.Type.BRICK, rand, wet ? 1 : 0));
            gen.setBlockState(center.func_177982_a(1, 3, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
            gen.setBlockState(center.func_177982_a(-1, 3, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
            gen.setBlockState(center.func_177982_a(0, 0, 0), MistBlocks.GRAVEL.func_176223_P());
            SnowTomb.generateGrave(gen, center.func_177982_a(0, 1, 4), Rotation.NONE, rand, wet);
            SnowTomb.generateGrave(gen, center.func_177982_a(-2, 1, 2), Rotation.CLOCKWISE_90, rand, wet);
            SnowTomb.generateGrave(gen, center.func_177982_a(2, 1, 2), Rotation.COUNTERCLOCKWISE_90, rand, wet);
            TombGenBase.placeUrn(gen, center.func_177982_a(-1, 1, 1), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(1, 1, 1), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(-1, 1, 3), biomeType, loc, rand, false);
            TombGenBase.placeUrn(gen, center.func_177982_a(1, 1, 3), biomeType, loc, rand, false);
            if (separate) {
                for (x = -1; x <= 1; ++x) {
                    for (z = -3; z <= -1; ++z) {
                        for (y = 0; y <= 2; ++y) {
                            checkPos = center.func_177982_a(x, y, z);
                            if (x == -1 || x == 1) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(cobble, rand, wet ? 1 : 0));
                                if (y != 2 || !gen.world.func_175710_j(gen.getPos(checkPos.func_177984_a()))) continue;
                                gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                                continue;
                            }
                            if (z <= -2) {
                                if (y == -z - 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(brick, EnumFacing.NORTH, false, rand, wet ? 1 : 0));
                                    if (y != 2) continue;
                                    gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                                    continue;
                                }
                                if (y >= -z - 1) continue;
                                gen.setBlockState(checkPos, TombGenBase.getBlock(cobble, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (y == 0) {
                                gen.setBlockState(checkPos, MistBlocks.GRAVEL.func_176223_P());
                                continue;
                            }
                            if (y == 1) {
                                gen.setBlockState(checkPos, biome.field_76753_B);
                                continue;
                            }
                            if (y != 2) continue;
                            gen.setBlockState(checkPos, biome.field_76752_A);
                            if (!gen.world.func_175710_j(gen.getPos(checkPos.func_177984_a()))) continue;
                            gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                        }
                    }
                }
                gen.setBlockState(center.func_177982_a(0, 1, 0), biome.field_76753_B);
                gen.setBlockState(center.func_177982_a(0, 2, 0), biome.field_76753_B);
            }
        }

        private static void generateGrave(GenUtil gen, BlockPos center, Rotation rotation, Random rand, boolean wet) {
            GenUtil genRot = gen.add(center, rotation, Mirror.NONE);
            center = genRot.set.center;
            genRot.setBlockState(center, TombGenBase.getStairs(TombGenBase.Type.COBBLE, EnumFacing.SOUTH, false, rand, wet ? 1 : 0));
            genRot.setBlockState(center.func_177984_a(), TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
            genRot.setBlockState(center.func_177977_b(), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
            int i = rand.nextInt(16);
            IBlockState state = i == 0 ? Blocks.field_150350_a.func_176223_P() : (i == 1 ? TombGenBase.getStep(TombGenBase.Type.COBBLE, EnumFacing.EAST, false, rand, wet ? 1 : 0) : (i == 2 ? TombGenBase.getStep(TombGenBase.Type.COBBLE, EnumFacing.WEST, false, rand, wet ? 1 : 0) : (i < 6 ? TombGenBase.getStep(TombGenBase.Type.COBBLE, EnumFacing.SOUTH, false, rand, wet ? 1 : 0) : TombGenBase.getSlab(TombGenBase.Type.COBBLE, false, rand, wet ? 1 : 0))));
            genRot.setBlockState(center.func_177978_c(), state);
            genRot.setBlockState(center.func_177978_c().func_177977_b(), MistBlocks.REMAINS.func_176223_P().func_177226_a((IProperty)Remains.LAYERS, (Comparable)Integer.valueOf(rand.nextInt(3) + 4)).func_177226_a((IProperty)Remains.OLD, (Comparable)Boolean.valueOf(true)));
            ((TileEntityRemains)genRot.getTileEntity(center.func_177978_c().func_177977_b())).func_189404_a(LootTables.REMAINS_LOOT, rand.nextLong());
        }
    }

    public static class TropicTomb {
        private static final EnumBiomeType biomeType = EnumBiomeType.Jungle;

        public static boolean generate(World world, BlockPos pos, Random rand) {
            for (int i = 0; i < 5; ++i) {
                GenUtil gen;
                Biome biome;
                int rz;
                int rx = rand.nextInt(16) + 8;
                BlockPos center = world.func_175645_m(pos.func_177982_a(rx, 0, rz = rand.nextInt(16) + 8));
                if (world.func_180495_p(center.func_177977_b()).func_185904_a().func_76222_j()) {
                    center = center.func_177977_b();
                }
                if (center.func_177956_o() <= 125 || !((biome = world.func_180494_b(center)) instanceof BiomeMist) || ((BiomeMist)biome).getBiomeType() != EnumBiomeType.Jungle || !(world.func_180495_p(center.func_177977_b()).func_177230_c() instanceof MistSoil) || !TombGenBase.roomCheck(gen = new GenUtil(world, new GenUtil.GenSet(center, Rotation.values()[rand.nextInt(4)], Mirror.values()[rand.nextInt(2)])), -3, 3, -3, -1, -3, 3, true)) continue;
                TropicTomb.generateTropicEntrance(gen, (BiomeMist)biome, rand, false);
                return true;
            }
            return false;
        }

        private static void generateTropicEntrance(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos checkPos;
            BlockPos center = gen.set.center;
            IBlockState top = null;
            IBlockState fill = null;
            boolean water = false;
            int state = rand.nextInt(6);
            if (state == 0) {
                top = TombGenBase.redSandDry;
                fill = TombGenBase.redSandWet;
            } else if (state == 1) {
                top = biome.field_76752_A;
                fill = biome.field_76753_B;
            } else if (state == 2) {
                top = fill = TombGenBase.redSandWet;
            } else if (state == 3) {
                top = fill = MistBlocks.GRAVEL.func_176223_P();
            } else {
                water = true;
            }
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    gen.setBlockState(center.func_177982_a(x, 0, z), Blocks.field_150350_a.func_176223_P());
                    int i = -1;
                    if (x <= -2) {
                        if (z <= -2) {
                            i = 0;
                        } else if (z == -1) {
                            i = -1;
                        } else if (z == 0) {
                            i = 1;
                        } else if (z == 1) {
                            i = -2;
                        } else if (z >= 2) {
                            i = 2;
                        }
                    } else if (x == -1) {
                        if (z > 2) {
                            i = -3;
                        } else if (z < -2) {
                            i = -8;
                        }
                    } else if (x == 0) {
                        if (z >= 2) {
                            i = 3;
                        } else if (z <= -2) {
                            i = 7;
                        }
                    } else if (x == 1) {
                        if (z > 2) {
                            i = -4;
                        } else if (z < -2) {
                            i = -7;
                        }
                    } else if (x >= 2) {
                        if (z >= 2) {
                            i = 4;
                        } else if (z == 1) {
                            i = -5;
                        } else if (z == 0) {
                            i = 5;
                        } else if (z == -1) {
                            i = -6;
                        } else if (z <= -2) {
                            i = 6;
                        }
                    }
                    int bottonDeep = 112 - center.func_177956_o() + (int)(biome.getGrassNoise().func_151601_a((double)(center.func_177958_n() + x) / 20.0, (double)(center.func_177952_p() + z) / 20.0) * 2.0 + (double)Math.abs(x * z) * 0.2);
                    int deep = 111 - center.func_177956_o() + rand.nextInt(rand.nextInt(3) + 1);
                    if (state == 2) {
                        top = rand.nextBoolean() ? biome.field_76752_A.func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(rand.nextInt(3))) : TombGenBase.redSandDry;
                    } else if (state == 3) {
                        top = rand.nextBoolean() ? biome.field_76752_A.func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(rand.nextInt(2) + 1)) : MistBlocks.GRAVEL.func_176223_P();
                    }
                    for (int y = -1; y > deep; --y) {
                        checkPos = center.func_177982_a(x, y, z);
                        if (!gen.world.func_175665_u(gen.getPos(checkPos))) continue;
                        if (x == -3 || x == 3 || z == -3 || z == 3) {
                            int w;
                            if (i < 0) {
                                if (y == -1) {
                                    gen.setBlockState(checkPos, MistBlocks.STONE_MINED.func_176223_P().func_177226_a(MistStoneMined.STAGE, (Comparable)((Object)MistStoneMined.EnumStoneStage.MOSS)));
                                    continue;
                                }
                                if (y == -2) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.BRICK, rand, 1));
                                    continue;
                                }
                                if ((y - 7) % 8 == i + 1 || (y - 4) % 8 == i + 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, 1));
                                    continue;
                                }
                                if ((y - 6) % 8 == i + 1 || (y - 5) % 8 == i + 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.BRICK, rand, 1));
                                    continue;
                                }
                                if (gen.getBlockState(checkPos).func_177230_c() == MistBlocks.MASONRY) continue;
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, 1));
                                continue;
                            }
                            int n = wet || -y - 1 <= i ? 1 : (w = (-y - 4) % 8 == i ? -1 : 0);
                            if (y < -1 && (-y - 2) % 8 == i) {
                                gen.setBlockState(checkPos, MistBlocks.STONE.func_176223_P());
                                continue;
                            }
                            if (y == -2) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.BRICK, rand, 1));
                                continue;
                            }
                            if (y > 113 - center.func_177956_o()) {
                                if (y == -1 || (-y - 1) % 8 == i) {
                                    if (y > -6 || x != 0 && z != 0) {
                                        if (x == -3) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.WEST, true, rand, w));
                                            continue;
                                        }
                                        if (x == 3) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.EAST, true, rand, w));
                                            continue;
                                        }
                                        if (z == -3) {
                                            gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.NORTH, true, rand, w));
                                            continue;
                                        }
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.SOUTH, true, rand, w));
                                        continue;
                                    }
                                    if (y <= 112 - center.func_177956_o()) continue;
                                    gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                    Rotation rot = x == -3 ? Rotation.CLOCKWISE_90 : (x == 3 ? Rotation.COUNTERCLOCKWISE_90 : (z == -3 ? Rotation.CLOCKWISE_180 : Rotation.NONE));
                                    int j = rand.nextInt(8);
                                    if (y < -7 && j <= 4) {
                                        TropicTomb.generateRoom(gen.add(checkPos.func_177977_b(), rot, Mirror.NONE), biome, rand, false);
                                        continue;
                                    }
                                    if (j <= 6) {
                                        TropicTomb.generateMiniRoomPart(gen.add(checkPos.func_177977_b(), rot, Mirror.NONE), biome, rand, false);
                                        continue;
                                    }
                                    TropicTomb.generateEnd(gen.add(checkPos.func_177977_b(), rot, Mirror.NONE), biome, rand, false);
                                    continue;
                                }
                                if (y < -2 && (-y - 3) % 8 == i) {
                                    if (x == -3) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.WEST, false, rand, -1));
                                        continue;
                                    }
                                    if (x == 3) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.EAST, false, rand, -1));
                                        continue;
                                    }
                                    if (z == -3) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.NORTH, false, rand, -1));
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.SOUTH, false, rand, -1));
                                    continue;
                                }
                                if ((x == 0 || z == 0) && y > 114 - center.func_177956_o()) {
                                    if (y <= -5 && -y % 8 == i) {
                                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                        continue;
                                    }
                                    if (y <= -4 && (-y + 1) % 8 == i) {
                                        gen.setBlockState(checkPos, MistBlocks.STONE_MINED.func_176223_P().func_177226_a(MistStoneMined.TYPE, (Comparable)((Object)MistStoneMined.EnumStoneType.CHISELED)).func_177226_a(MistStoneMined.STAGE, (Comparable)((Object)MistStoneMined.EnumStoneStage.MOSS)));
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, w));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, w));
                                continue;
                            }
                            gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, w));
                            continue;
                        }
                        if ((x == -2 || x == 2 || z == -2 || z == 2) && i != -1 && y < -1 && (-y - 2) % 8 == i) {
                            gen.setBlockState(checkPos, MistBlocks.STONE.func_176223_P());
                            continue;
                        }
                        if (water) {
                            if (y < 114 - center.func_177956_o()) {
                                gen.setBlockState(checkPos, Blocks.field_150355_j.func_176223_P());
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (y == bottonDeep + 1) {
                            gen.setBlockState(checkPos, top);
                            continue;
                        }
                        if (y < bottonDeep + 1) {
                            gen.setBlockState(checkPos, fill);
                            continue;
                        }
                        gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            if (state > 0) {
                checkPos = center.func_177979_c(112 - center.func_177956_o());
                BiomeMist.looseRockGen.func_180709_b(gen.world, rand, checkPos);
                if (state == 1) {
                    biome.func_76730_b(rand).func_180709_b(gen.world, rand, checkPos);
                }
            }
        }

        private static void generateMiniRoomPart(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            if (TombGenBase.roomCheck(gen, -3, 3, 0, 5, 1, 7, false)) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = 1; z <= 6; ++z) {
                        for (int y = 0; y <= 4; ++y) {
                            TombGenBase.Type type = y >= 3 || z == 1 && x != 0 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE;
                            BlockPos checkPos = center.func_177982_a(x, y, z);
                            if (x == -2 || x == 2 || z == 1 || z == 6 || y == 4) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (y == 0) {
                                gen.setBlockState(checkPos, TombGenBase.redSandDry);
                                continue;
                            }
                            if (y == 3) {
                                if (x == -1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.WEST, true, rand, wet ? 1 : 0));
                                    continue;
                                }
                                if (x == 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.EAST, true, rand, wet ? 1 : 0));
                                    continue;
                                }
                                if (z == 5) {
                                    gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                                    continue;
                                }
                                TombGenBase.placeWeb(gen, checkPos, rand, true);
                                continue;
                            }
                            if (y == 2) {
                                if (!(x != -1 && x != 1 || z != 2 && z != 6)) {
                                    TombGenBase.placeWeb(gen, checkPos, rand, true);
                                    continue;
                                }
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                gen.setBlockState(center.func_177982_a(0, 0, 1), MistBlocks.STONE.func_176223_P());
                gen.setBlockState(center.func_177982_a(-1, 2, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(-1, 3, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(1, 2, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(1, 3, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(-3, 2, 3), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(3, 2, 3), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                TombGenBase.placeUrn(gen, center.func_177982_a(-2, 2, 3), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(2, 2, 3), biomeType, loc, rand, true);
                int i = rand.nextInt(5);
                if (i == 0) {
                    gen.setBlockState(center.func_177982_a(-1, 2, 7), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                    TombGenBase.placeUrn(gen, center.func_177982_a(-1, 2, 6), biomeType, loc, rand, true);
                    TropicTomb.generateGrave(gen, center.func_177982_a(1, 1, 5), Rotation.COUNTERCLOCKWISE_90, rand, wet, false);
                } else if (i == 1) {
                    gen.setBlockState(center.func_177982_a(1, 2, 7), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                    TombGenBase.placeUrn(gen, center.func_177982_a(1, 2, 6), biomeType, loc, rand, true);
                    TropicTomb.generateGrave(gen, center.func_177982_a(-1, 1, 5), Rotation.CLOCKWISE_90, rand, wet, true);
                } else {
                    gen.setBlockState(center.func_177982_a(0, 2, 7), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                    TombGenBase.placeUrn(gen, center.func_177982_a(0, 2, 6), biomeType, loc, rand, true);
                    TropicTomb.generateGrave(gen, center.func_177982_a(-1, 1, 5), Rotation.NONE, rand, wet, false);
                    TropicTomb.generateGrave(gen, center.func_177982_a(1, 1, 5), Rotation.NONE, rand, wet, true);
                }
            } else {
                TropicTomb.generateEnd(gen, biome, rand, wet);
            }
        }

        private static void generateRoom(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            if (TombGenBase.roomCheck(gen, -5, 5, 0, 5, 1, 8, false)) {
                for (int x = -4; x <= 4; ++x) {
                    for (int z = 1; z <= 7; ++z) {
                        for (int y = 0; y <= 4; ++y) {
                            TombGenBase.Type type = y >= 3 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE;
                            BlockPos checkPos = center.func_177982_a(x, y, z);
                            if (!(z != 1 || y != 1 && y != 2 || x != -1 && x != 1)) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.BRICK, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (!(z != 1 || y != 1 && y != 2 || x != -2 && x != 2)) {
                                gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (x == -4 || x == 4 || z == 1 || z == 7 || y == 4) {
                                if (y == 4 && (x < -2 || x > 2)) continue;
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (y == 0) {
                                if (z == 4 && (x == 2 || x == -2)) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.redSandDry);
                                continue;
                            }
                            if (y == 3) {
                                if (z == 6) {
                                    if (x >= -1 && x <= 1) {
                                        gen.setBlockState(checkPos, TombGenBase.getStairs(type, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                                        continue;
                                    }
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                    continue;
                                }
                                if (x == -1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStep(type, EnumFacing.WEST, true, rand, wet ? 1 : 0));
                                    continue;
                                }
                                if (x == 1) {
                                    gen.setBlockState(checkPos, TombGenBase.getStep(type, EnumFacing.EAST, true, rand, wet ? 1 : 0));
                                    continue;
                                }
                                if (x == 0) {
                                    TombGenBase.placeWeb(gen, checkPos, rand, true);
                                    continue;
                                }
                                gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                continue;
                            }
                            if (z == 4) {
                                if (x == -3 || x == 3) {
                                    TombGenBase.placeWeb(gen, checkPos, rand, true);
                                    continue;
                                }
                                if (x == -2 || x == 2) {
                                    gen.setBlockState(checkPos, TombGenBase.getBlock(type, rand, wet ? 1 : 0));
                                    continue;
                                }
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            if (y == 2) {
                                if (!(x != -3 && x != 3 || z != 2 && z != 7)) {
                                    TombGenBase.placeWeb(gen, checkPos, rand, true);
                                    continue;
                                }
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                gen.setBlockState(center.func_177982_a(0, 0, 1), MistBlocks.STONE.func_176223_P());
                gen.setBlockState(center.func_177982_a(-1, 2, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(-1, 3, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(1, 2, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(1, 3, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(-5, 2, 3), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(5, 2, 3), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                TombGenBase.placeUrn(gen, center.func_177982_a(-4, 2, 3), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(4, 2, 3), biomeType, loc, rand, true);
                gen.setBlockState(center.func_177982_a(-5, 2, 5), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(5, 2, 5), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                TombGenBase.placeUrn(gen, center.func_177982_a(-4, 2, 5), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(4, 2, 5), biomeType, loc, rand, true);
                gen.setBlockState(center.func_177982_a(-1, 2, 8), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                gen.setBlockState(center.func_177982_a(1, 2, 8), TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                TombGenBase.placeUrn(gen, center.func_177982_a(-1, 2, 7), biomeType, loc, rand, true);
                TombGenBase.placeUrn(gen, center.func_177982_a(1, 2, 7), biomeType, loc, rand, true);
                TropicTomb.generateGrave(gen, center.func_177982_a(-3, 1, 2), Rotation.CLOCKWISE_90, rand, wet, false);
                TropicTomb.generateGrave(gen, center.func_177982_a(3, 1, 2), Rotation.COUNTERCLOCKWISE_90, rand, wet, true);
                TropicTomb.generateGrave(gen, center.func_177982_a(-3, 1, 6), Rotation.CLOCKWISE_90, rand, wet, true);
                TropicTomb.generateGrave(gen, center.func_177982_a(3, 1, 6), Rotation.COUNTERCLOCKWISE_90, rand, wet, false);
                TropicTomb.generateGrave(gen, center.func_177982_a(0, 1, 6), Rotation.NONE, rand, wet, rand.nextBoolean());
            } else {
                TropicTomb.generateMiniRoomPart(gen, biome, rand, wet);
            }
        }

        private static void generateEnd(GenUtil gen, BiomeMist biome, Random rand, boolean wet) {
            BlockPos center = gen.set.center;
            for (int x = -1; x <= 1; ++x) {
                for (int z = 1; z <= 2; ++z) {
                    for (int y = 0; y <= 3; ++y) {
                        BlockPos checkPos = center.func_177982_a(x, y, z);
                        if (x == -1 || x == 1 || y == 3) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.BRICK, rand, wet ? 1 : 0));
                            continue;
                        }
                        if (z == 2) {
                            gen.setBlockState(checkPos, TombGenBase.getBlock(TombGenBase.Type.COBBLE, rand, wet ? 1 : 0));
                            continue;
                        }
                        if (y == 0) {
                            gen.setBlockState(checkPos, MistBlocks.STONE.func_176223_P());
                            continue;
                        }
                        if (y == 2) {
                            TombGenBase.placeUrn(gen, checkPos, biomeType, loc, rand, true, 8);
                            continue;
                        }
                        gen.setBlockState(checkPos, TombGenBase.getStairs(TombGenBase.Type.BRICK, EnumFacing.SOUTH, true, rand, wet ? 1 : 0));
                    }
                }
            }
            gen.setBlockState(center.func_177982_a(-1, 2, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
            gen.setBlockState(center.func_177982_a(-1, 3, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
            gen.setBlockState(center.func_177982_a(1, 2, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
            gen.setBlockState(center.func_177982_a(1, 3, 0), TombGenBase.getBlock(TombGenBase.Type.MASONRY, rand, wet ? 1 : 0));
        }

        private static void generateGrave(GenUtil gen, BlockPos center, Rotation rotation, Random rand, boolean wet, boolean mirror) {
            TombGenBase.Type type;
            GenUtil genRot = gen.add(center, rotation, Mirror.NONE);
            center = genRot.set.center;
            TombGenBase.Type type2 = type = rand.nextBoolean() ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE;
            IBlockState state = rand.nextInt(8) == 0 ? TombGenBase.getSlab(type, false, rand, wet ? 1 : 0) : TombGenBase.getStairs(type, EnumFacing.SOUTH, false, rand, wet ? 1 : 0);
            genRot.setBlockState(center, state);
            int i = rand.nextInt(12);
            state = i == 0 ? Blocks.field_150350_a.func_176223_P() : (i == 1 ? TombGenBase.getStep(type, EnumFacing.SOUTH, false, rand, wet ? 1 : 0) : (i == 2 ? TombGenBase.getStep(type, mirror ? EnumFacing.EAST : EnumFacing.WEST, false, rand, wet ? 1 : 0) : TombGenBase.getSlab(type, false, rand, wet ? 1 : 0)));
            genRot.setBlockState(center.func_177978_c(), state);
            int size = rand.nextInt(3) + 4;
            genRot.setBlockState(center.func_177977_b(), MistBlocks.REMAINS.func_176223_P().func_177226_a((IProperty)Remains.LAYERS, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)Remains.OLD, (Comparable)Boolean.valueOf(true)));
            genRot.setBlockState(center.func_177978_c().func_177977_b(), MistBlocks.REMAINS.func_176223_P().func_177226_a((IProperty)Remains.LAYERS, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)Remains.OLD, (Comparable)Boolean.valueOf(true)));
            ((TileEntityRemains)genRot.getTileEntity(center.func_177977_b())).func_189404_a(LootTables.REMAINS_LOOT, rand.nextLong());
            ((TileEntityRemains)genRot.getTileEntity(center.func_177978_c().func_177977_b())).func_189404_a(LootTables.REMAINS_LOOT, rand.nextLong());
        }
    }
}

