/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.upperplant.MistNightberry;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class DecorateLakesGenerator
implements IWorldGenerator {
    private final int H = 112;
    private final IBlockState grass = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
    private final IBlockState fern = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN);
    private final IBlockState grassDown = Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.GRASS);
    private final IBlockState grassUp = Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.GRASS).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER);
    private final IBlockState nightberry = MistBlocks.NIGHTBERRY.func_176223_P().func_177226_a(MistNightberry.AGE, (Comparable)((Object)MistNightberry.EnumAge.POTENTIAL));

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == Mist.getID()) {
            this.findLakes(world, chunkX * 16, chunkZ * 16, rand);
        }
    }

    public void findLakes(World world, int chunkX, int chunkZ, Random rand) {
        if (!world.field_72995_K) {
            List<BlockPos> emptyPoses = new ArrayList<BlockPos>();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos pos = new BlockPos(chunkX + x, 125, chunkZ + z);
                    if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150359_w || world.func_180495_p(pos).func_177230_c() == Blocks.field_150399_cn) {
                        emptyPoses = this.setWater(world, pos, rand, emptyPoses);
                    }
                    if (emptyPoses.isEmpty()) continue;
                    this.removeWater(world, rand, emptyPoses);
                }
            }
        }
    }

    private List<BlockPos> setWater(World world, BlockPos pos, Random rand, List<BlockPos> emptyPoses) {
        boolean check = true;
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        while (true) {
            if (check) {
                if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150359_w) {
                    if (world.func_180494_b(pos).func_180626_a(pos) < 0.25f) {
                        world.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 18);
                        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 18);
                        }
                    } else {
                        world.func_180501_a(pos, MistWorld.waterBlockUpper, 18);
                    }
                } else if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150399_cn) {
                    world.func_180501_a(pos, MistBlocks.FLOATING_MAT.func_176223_P(), 18);
                    this.placePlantOnFloatingMat(world, pos.func_177984_a(), rand);
                }
                poses.add(pos);
            }
            check = false;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                BlockPos facePos = pos.func_177972_a(face);
                if (world.func_180495_p(facePos).func_177230_c() == Blocks.field_150359_w || world.func_180495_p(facePos).func_177230_c() == Blocks.field_150399_cn) {
                    pos = facePos;
                    check = true;
                    break;
                }
                if (!this.isNotFull(world, facePos) || emptyPoses.contains(facePos)) continue;
                emptyPoses.add(facePos);
            }
            if (check) continue;
            poses.remove(poses.size() - 1);
            if (poses.isEmpty()) break;
            pos = (BlockPos)poses.get(poses.size() - 1);
        }
        return emptyPoses;
    }

    private void removeWater(World world, Random rand, List<BlockPos> emptyPoses) {
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        do {
            BlockPos hightPos = emptyPoses.get(emptyPoses.size() - 1);
            while (hightPos.func_177956_o() > this.H && this.isNotFull(world, hightPos)) {
                BlockPos pos = hightPos;
                boolean check = true;
                while (true) {
                    if (check) {
                        if (!world.func_175623_d(pos.func_177984_a()) && this.isNotFull(world, pos.func_177984_a())) {
                            if (world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof BlockDoublePlant) {
                                world.func_180501_a(pos.func_177981_b(2), Blocks.field_150350_a.func_176223_P(), 2);
                            }
                            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 18);
                        }
                        if (this.isWater(world, pos) || world.func_180495_p(pos).func_177230_c() == MistBlocks.FLOATING_MAT) {
                            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 18);
                        }
                        this.setTopBlock(world, pos.func_177977_b(), rand);
                        poses.add(pos);
                    }
                    check = false;
                    for (EnumFacing face : EnumFacing.field_176754_o) {
                        BlockPos facePos = pos.func_177972_a(face);
                        if (!this.isWater(world, facePos) && world.func_180495_p(facePos).func_177230_c() != MistBlocks.FLOATING_MAT) continue;
                        pos = facePos;
                        check = true;
                        break;
                    }
                    if (check) continue;
                    poses.remove(poses.size() - 1);
                    if (poses.isEmpty()) break;
                    pos = (BlockPos)poses.get(poses.size() - 1);
                }
                hightPos = hightPos.func_177977_b();
            }
            emptyPoses.remove(emptyPoses.size() - 1);
        } while (!emptyPoses.isEmpty());
    }

    private void setTopBlock(World world, BlockPos pos, Random rand) {
        Biome biome = world.func_180494_b(pos);
        if (this.isWater(world, pos)) {
            if (biome.func_180626_a(pos) < 0.25f) {
                world.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 18);
            } else {
                boolean swamp;
                boolean bl = swamp = biome == MistBiomes.upSwamp;
                if (swamp || biome == MistBiomes.upMarsh) {
                    if (!this.isWater(world, pos.func_177977_b())) {
                        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != MistBlocks.CLAY) {
                            world.func_180501_a(pos, MistBlocks.FLOATING_MAT.func_176223_P(), 18);
                            if (swamp) {
                                world.func_180501_a(pos.func_177977_b(), MistBlocks.PEAT.func_176223_P(), 18);
                            }
                            this.placePlantOnFloatingMat(world, pos.func_177984_a(), rand);
                        }
                    } else if (!this.isWater(world, pos.func_177979_c(2)) && world.func_180495_p(pos.func_177979_c(2)).func_177230_c() != MistBlocks.CLAY && ((BiomeMist)biome).getNoises(pos.func_177958_n(), pos.func_177952_p()).get(3) > 0.0) {
                        world.func_180501_a(pos, MistBlocks.FLOATING_MAT.func_176223_P(), 18);
                        if (swamp) {
                            world.func_180501_a(pos.func_177979_c(2), MistBlocks.PEAT.func_176223_P(), 18);
                        }
                        this.placePlantOnFloatingMat(world, pos.func_177984_a(), rand);
                    }
                }
            }
        } else if (!this.isNotFull(world, pos) && biome instanceof BiomeMistUp && world.func_180495_p(pos).func_177230_c() != MistBlocks.FLOATING_MAT) {
            if (world.func_180495_p(pos) != MistWorld.stoneBlockUpper) {
                world.func_180501_a(pos, ((BiomeMist)biome).getTopBlock(rand, ((BiomeMist)biome).getNoises(pos.func_177958_n(), pos.func_177952_p())), 18);
            }
            ((BiomeMist)biome).placePlant(world, pos.func_177984_a(), rand);
        }
    }

    private boolean isNotFull(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185917_h() && !(world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid);
    }

    private boolean isWater(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos).func_177230_c() == Blocks.field_150432_aD;
    }

    private boolean placePlantOnFloatingMat(World world, BlockPos pos, Random rand) {
        if (world.func_175623_d(pos)) {
            int i = rand.nextInt(16);
            if (i < 4) {
                return world.func_180501_a(pos, this.grass, 18);
            }
            if (i == 4) {
                return world.func_180501_a(pos, this.fern, 18);
            }
            if (i == 5 && world.func_175623_d(pos.func_177984_a())) {
                return world.func_180501_a(pos, this.grassDown, 2) && world.func_180501_a(pos.func_177984_a(), this.grassUp, 2);
            }
            if (rand.nextInt(48) == 0 && this.isWater(world, pos.func_177979_c(2))) {
                return world.func_180501_a(pos, this.nightberry, 2);
            }
        }
        return false;
    }
}

