/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.tileentity.TileEntityUrn;
import ru.liahim.mist.util.GenUtil;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.generators.TombGen;
import ru.liahim.mist.world.generators.TombGenBase;

public class CliffTombGen
extends TombGenBase {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        BlockPos center = pos.func_177982_a(16, 116 - pos.func_177956_o(), 16);
        if (!world.func_175623_d(center) || !world.func_175678_i(center)) {
            return false;
        }
        if ((double)rand.nextFloat() >= ModConfig.generation.cliffTombGenerationChance) {
            return false;
        }
        Biome biome = world.func_180494_b(center);
        if (!(biome instanceof BiomeMist) || !((BiomeMist)biome).isUpBiome()) {
            return false;
        }
        return this.generateTomb(world, center, rand);
    }

    private boolean generateTomb(World world, BlockPos pos, Random rand) {
        BlockPos findCenter = null;
        EnumFacing findFace = null;
        block0: for (EnumFacing face : EnumFacing.field_176754_o) {
            for (int i = 1; i < 8; ++i) {
                if (!world.func_180495_p(pos.func_177967_a(face, i)).func_185917_h()) continue;
                findCenter = pos.func_177967_a(face, i);
                findFace = face;
                continue block0;
            }
        }
        if (findCenter != null) {
            BlockPos center;
            GenUtil gen;
            Biome biome = world.func_180494_b(findCenter);
            EnumBiomeType type = ((BiomeMist)biome).getBiomeType();
            if (type == EnumBiomeType.Desert || type == EnumBiomeType.Jungle || biome == MistBiomes.borderUpDesert || biome == MistBiomes.borderUpJungle) {
                int wet = type == EnumBiomeType.Desert || biome == MistBiomes.borderUpDesert ? -1 : 0;
                boolean check = false;
                EnumBiomeType biomeType = type == EnumBiomeType.Border ? (biome == MistBiomes.borderUpDesert ? EnumBiomeType.Desert : EnumBiomeType.Jungle) : type;
                for (int i = 1; i < 64; ++i) {
                    int k;
                    BlockPos center2 = findCenter.func_177982_a(rand.nextInt(8) - 4, rand.nextInt(4) - 2, rand.nextInt(8) - 4);
                    if (!world.func_175623_d(center2) || !world.func_175678_i(center2)) continue;
                    findFace = null;
                    for (EnumFacing face : EnumFacing.field_176754_o) {
                        if (world.func_180495_p(center2.func_177972_a(face)).func_177230_c() != MistWorld.stoneBlockUpper.func_177230_c()) continue;
                        findFace = face;
                        break;
                    }
                    if (findFace == null || !world.func_180495_p(center2.func_177972_a(findFace).func_177979_c(2)).func_185917_h() || !world.func_180495_p(center2.func_177967_a(findFace, 2).func_177984_a()).func_185917_h()) continue;
                    center2 = center2.func_177967_a(findFace, 2);
                    world.func_175656_a(center2.func_177977_b(), CliffTombGen.getBlock(TombGenBase.Type.COBBLE, rand, wet));
                    if (rand.nextInt(3) != 0) {
                        world.func_175656_a(center2, MistBlocks.URN.func_176223_P());
                        TileEntityUrn.UrnLootType.initializeType(world.func_175625_s(center2), biomeType, TileEntityUrn.UrnLocation.CLIFF, rand);
                    } else {
                        world.func_175698_g(center2);
                    }
                    findFace = findFace.func_176734_d();
                    for (k = 1; k < 4 && world.func_180495_p(center2.func_177967_a(findFace, k)).func_185917_h(); ++k) {
                        world.func_175698_g(center2.func_177967_a(findFace, k));
                    }
                    for (k = 1; k < 4 && world.func_180495_p(center2.func_177967_a(findFace, k).func_177977_b()).func_185917_h(); ++k) {
                        world.func_175698_g(center2.func_177967_a(findFace, k).func_177977_b());
                    }
                    check = true;
                }
                return check;
            }
            if (type == EnumBiomeType.Forest || biome == MistBiomes.borderUpPlains) {
                BlockPos center3 = findCenter.func_177967_a(findFace, 4);
                gen = new GenUtil(world, new GenUtil.GenSet(center3, findFace == EnumFacing.SOUTH ? Rotation.NONE : (findFace == EnumFacing.NORTH ? Rotation.CLOCKWISE_180 : (findFace == EnumFacing.WEST ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90)), Mirror.NONE));
                if (CliffTombGen.roomCheck(gen, -4, 4, 0, 4, 0, 0, false) && TombGen.ForestTomb.generateMiniRoom(gen, (BiomeMist)biome, EnumBiomeType.Forest, TileEntityUrn.UrnLocation.CLIFF, rand, true, true)) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = 1; z >= -5; --z) {
                            for (int y = 1; y <= 3; ++y) {
                                BlockPos checkPos = center3.func_177982_a(x, y, z);
                                if (x == -1 || x == 1 || y == 3) {
                                    if (y == 3 && x != 0 || !gen.getBlockState(checkPos).func_185917_h()) continue;
                                    gen.setBlockState(checkPos, CliffTombGen.getBlock(TombGenBase.Type.BRICK, rand, 0));
                                    continue;
                                }
                                if (z == 1 && gen.getBlockState(checkPos).func_185917_h()) {
                                    gen.setBlockState(checkPos, CliffTombGen.getBlock(TombGenBase.Type.COBBLE, rand, 0));
                                    continue;
                                }
                                gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                            }
                        }
                    }
                    return true;
                }
            } else if ((type == EnumBiomeType.Swamp || biome == MistBiomes.borderUpSwamp) && CliffTombGen.roomCheck(gen = new GenUtil(world, new GenUtil.GenSet(center = findCenter.func_177967_a(findFace, 2).func_177981_b(4), findFace == EnumFacing.SOUTH ? Rotation.NONE : (findFace == EnumFacing.NORTH ? Rotation.CLOCKWISE_180 : (findFace == EnumFacing.WEST ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90)), Mirror.NONE)), -3, 3, -7, -1, 0, 7, false)) {
                TombGen.SwampTomb.generateMiniRoom(gen, (BiomeMist)biome, EnumBiomeType.Swamp, TileEntityUrn.UrnLocation.CLIFF, rand, true, true);
                center = center.func_177979_c(6);
                for (int x = -1; x <= 1; ++x) {
                    for (int z = 0; z >= -5; --z) {
                        for (int y = 1; y <= 3; ++y) {
                            BlockPos checkPos = center.func_177982_a(x, y, z);
                            if (x == -1 || x == 1 || y == 3) {
                                if (y == 3 && x != 0 || !gen.getBlockState(checkPos).func_185917_h()) continue;
                                gen.setBlockState(checkPos, CliffTombGen.getBlock(TombGenBase.Type.COBBLE, rand, 0));
                                continue;
                            }
                            gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

