/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockWettable;
import ru.liahim.mist.block.MistClay;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.world.biome.BiomeMistUpSavanna;

public class ClayLakesGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ArrayList<BlockPos> clayPoses;
        BlockPos center;
        if (!world.field_72995_K && world.field_73011_w.getDimension() == Mist.getID() && world.func_180494_b(center = world.func_175645_m(BlockPos.field_177992_a.func_177982_a(chunkX * 16 + 8, 0, chunkZ * 16 + 8))) == MistBiomes.upSavanna && (clayPoses = this.checkSpace(world, center)) != null && !clayPoses.isEmpty() && clayPoses.size() >= 150 && clayPoses.size() < 1000) {
            for (BlockPos pos : clayPoses) {
                double i = ((BiomeMistUpSavanna)MistBiomes.upSavanna).getClayNoise(pos);
                if (i > (double)0.45f && world.func_175699_k(pos.func_177984_a()) > 12) {
                    if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockBush) {
                        int j = 1;
                        while (true) {
                            world.func_180501_a(pos.func_177981_b(j), Blocks.field_150350_a.func_176223_P(), 18);
                            if (!(world.func_180495_p(pos.func_177981_b(j + 1)).func_177230_c() instanceof BlockBush)) break;
                            ++j;
                        }
                    }
                    world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 18);
                    if (world.func_180495_p(pos).func_177230_c() instanceof MistBlockWettable) {
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 18);
                        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistBlockWettable || world.func_180495_p(pos.func_177977_b()).func_177230_c() == MistBlocks.GRAVEL) {
                            world.func_180501_a(pos.func_177977_b(), MistBlocks.CLAY.func_176223_P().func_177226_a(MistClay.TYPE, (Comparable)((Object)MistClay.EnumBlockType.CRACKED)).func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)), 18);
                            for (EnumFacing face : EnumFacing.field_176754_o) {
                                center = pos.func_177984_a().func_177972_a(face);
                                if (!world.func_180495_p(center).func_185913_b() || world.func_180495_p(center.func_177984_a()).func_177230_c() instanceof MistTreeTrunk) continue;
                                world.func_180501_a(center.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 18);
                                world.func_180501_a(center, Blocks.field_150350_a.func_176223_P(), 18);
                                if (!(world.func_180495_p(center.func_177977_b()).func_177230_c() instanceof MistDirt)) continue;
                                world.func_180501_a(center.func_177977_b(), MistBlocks.GRASS_C.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)), 18);
                            }
                        }
                    }
                } else if (i > (double)0.425f) {
                    if (world.func_180495_p(pos).func_177230_c() instanceof MistDirt) {
                        world.func_180501_a(pos, MistBlocks.GRASS_C.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)), 18);
                    }
                    if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistBlockWettable) {
                        world.func_180501_a(pos.func_177977_b(), MistBlocks.CLAY.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)), 18);
                    }
                } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistDirt) {
                    world.func_180501_a(pos.func_177977_b(), MistBlocks.DIRT_C.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)), 18);
                }
                boolean checkFish = false;
                BlockPos posDown = pos.func_177979_c(2);
                while (posDown.func_177956_o() > 108 && world.func_180495_p(posDown).func_177230_c() instanceof MistBlockWettable) {
                    if (!checkFish && (double)random.nextFloat() < ModConfig.generation.desertFishGenRarity) {
                        world.func_180501_a(posDown, MistBlocks.CLAY.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)).func_177226_a(MistClay.TYPE, (Comparable)((Object)MistClay.EnumBlockType.CONTAINER)), 18);
                    } else {
                        world.func_180501_a(posDown, MistBlocks.CLAY.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)), 18);
                    }
                    checkFish = true;
                    posDown = posDown.func_177977_b();
                }
            }
        }
    }

    private ArrayList<BlockPos> checkSpace(World world, BlockPos center) {
        while (center.func_177956_o() > 125 && world.func_180495_p(center) != MistBiomes.upSavanna.field_76752_A) {
            center = center.func_177977_b();
        }
        if (center.func_177956_o() <= 130 && world.func_180495_p(center) == MistBiomes.upSavanna.field_76752_A && ((BiomeMistUpSavanna)MistBiomes.upSavanna).getClayNoise(center) > (double)0.4f) {
            LinkedList<BlockPos> poses = new LinkedList<BlockPos>();
            ArrayList<BlockPos> clayPoses = new ArrayList<BlockPos>();
            poses.addLast(center);
            clayPoses.add(center);
            BlockPos pos = center;
            while (!poses.isEmpty()) {
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    BlockPos facePos = pos.func_177972_a(face);
                    if (poses.contains(facePos) || clayPoses.contains(facePos)) continue;
                    IBlockState state = world.func_180495_p(facePos);
                    IBlockState upState = world.func_180495_p(facePos.func_177984_a());
                    if (!state.func_185913_b() || world.func_180495_p(facePos.func_177981_b(2)).func_185913_b()) {
                        return null;
                    }
                    if (state != MistBiomes.upSavanna.field_76752_A && state != MistBiomes.upDesert.field_76752_A && upState != MistBiomes.upSavanna.field_76752_A && upState != MistBiomes.upDesert.field_76752_A || !(((BiomeMistUpSavanna)MistBiomes.upSavanna).getClayNoise(facePos) > (double)0.4f)) continue;
                    poses.addLast(facePos);
                    clayPoses.add(facePos);
                }
                poses.removeFirstOccurrence(pos);
                if (poses.isEmpty()) continue;
                pos = (BlockPos)poses.getFirst();
            }
            return clayPoses;
        }
        return null;
    }
}

