/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.common.Mist;

public class BigRockGenerator
extends WorldGenerator {
    private final int size;

    public BigRockGenerator(int size) {
        this.size = MathHelper.func_76125_a((int)size, (int)0, (int)2);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!world.field_72995_K) {
            boolean snow = world.func_180494_b(pos).func_150559_j();
            if (this.size == 2) {
                return this.bigRockGen(world, rand, pos, snow);
            }
            if (this.size == 1) {
                return this.medRockGen(world, rand, pos, snow);
            }
            return this.minRockGen(world, rand, pos, snow);
        }
        return false;
    }

    public boolean bigRockGen(World world, Random rand, BlockPos pos, boolean snow) {
        if (world.field_73011_w.getDimension() == Mist.getID() && pos.func_177956_o() < 135 && pos.func_177956_o() > 115 && rand.nextInt(4) == 0 && world.func_180495_p(pos = pos.func_177979_c(rand.nextInt(3))).func_177230_c() instanceof MistSoil) {
            int radius = rand.nextInt(2) + 2;
            List<BlockPos> poses = new ArrayList<BlockPos>();
            if ((poses = this.checkBigArea(world, pos, radius, poses)) != null) {
                int dx = rand.nextInt(radius * 2 - 1) - radius + 1;
                int dz = rand.nextInt(radius * 2 - 1) - radius + 1;
                if (dx != 0 || dz != 0) {
                    int oldRadius = radius;
                    if ((radius = Math.min(radius, rand.nextInt(2) + 2)) == 3) {
                        if (dx * dz == 4) {
                            dx /= 2;
                            dz /= 2;
                        }
                    } else if (oldRadius == 3 && dx * dx < 4 && dz * dz < 4) {
                        dx = dx > 0 ? 2 : -2;
                        dz = dz > 0 ? 2 : -2;
                    }
                    if ((poses = this.checkBigArea(world, pos = pos.func_177982_a(dx, radius == oldRadius ? -1 : rand.nextInt(2) - 1, dz), radius, poses)) != null) {
                        for (BlockPos checkPos : poses) {
                            if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() instanceof BlockBush) {
                                world.func_175698_g(checkPos.func_177984_a());
                            }
                            world.func_180501_a(checkPos, MistBlocks.STONE.func_176223_P(), 18);
                            if (!snow || !world.func_175678_i(checkPos.func_177984_a())) continue;
                            world.func_180501_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P(), 18);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean medRockGen(World world, Random rand, BlockPos pos, boolean snow) {
        if (world.field_73011_w.getDimension() == Mist.getID() && pos.func_177956_o() < 135 && pos.func_177956_o() > 115 && rand.nextInt(4) == 0 && world.func_180495_p(pos = pos.func_177979_c(rand.nextInt(3))).func_177230_c() instanceof MistSoil) {
            List<BlockPos> poses = new ArrayList<BlockPos>();
            if ((poses = this.checkMedArea(world, pos, poses)) != null) {
                int dx = rand.nextInt(3) - 1;
                int dz = rand.nextInt(3) - 1;
                if ((dx != 0 || dz != 0) && (poses = this.checkMedArea(world, pos = pos.func_177982_a(dx, -1, dz), poses)) != null) {
                    for (BlockPos checkPos : poses) {
                        if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() instanceof BlockBush) {
                            world.func_175698_g(checkPos.func_177984_a());
                        }
                        world.func_180501_a(checkPos, MistBlocks.STONE.func_176223_P(), 18);
                        if (!snow || !world.func_175678_i(checkPos.func_177984_a())) continue;
                        world.func_180501_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P(), 18);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean minRockGen(World world, Random rand, BlockPos pos, boolean snow) {
        if (world.field_73011_w.getDimension() == Mist.getID() && pos.func_177956_o() < 135 && pos.func_177956_o() > 115 && rand.nextInt(4) == 0 && world.func_180495_p(pos = pos.func_177979_c(rand.nextInt(rand.nextInt(2) + 1))).func_177230_c() instanceof MistSoil) {
            List<BlockPos> poses = new ArrayList<BlockPos>();
            if ((poses = this.checkMinArea(world, pos, poses, rand)) != null) {
                for (BlockPos checkPos : poses) {
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() instanceof BlockBush) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.STONE.func_176223_P(), 18);
                    if (!snow || !world.func_175678_i(checkPos.func_177984_a())) continue;
                    world.func_180501_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P(), 18);
                }
                return true;
            }
        }
        return false;
    }

    private List<BlockPos> checkBigArea(World world, BlockPos pos, int radius, List<BlockPos> poses) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    if (!(checkPos.func_177951_i((Vec3i)pos) <= (double)(radius * (radius + 1)))) continue;
                    if (world.func_180495_p(checkPos).func_177230_c() instanceof MistTreeTrunk) {
                        return null;
                    }
                    if (poses.contains(checkPos)) continue;
                    poses.add(checkPos);
                }
            }
        }
        return poses;
    }

    private List<BlockPos> checkMedArea(World world, BlockPos pos, List<BlockPos> poses) {
        for (int x = -1; x <= 2; ++x) {
            for (int y = -1; y <= 2; ++y) {
                for (int z = -1; z <= 2; ++z) {
                    if (!(((double)x - 0.5) * ((double)x - 0.5) + ((double)y - 0.5) * ((double)y - 0.5) + ((double)z - 0.5) * ((double)z - 0.5) < 4.0)) continue;
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    if (world.func_180495_p(checkPos).func_177230_c() instanceof MistTreeTrunk) {
                        return null;
                    }
                    if (poses.contains(checkPos)) continue;
                    poses.add(checkPos);
                }
            }
        }
        return poses;
    }

    private List<BlockPos> checkMinArea(World world, BlockPos pos, List<BlockPos> poses, Random rand) {
        int i = rand.nextInt(4);
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    if ((x << 1 | z) == (y == 0 ? i : 3 - i)) continue;
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    if (world.func_180495_p(checkPos).func_177230_c() instanceof MistTreeTrunk) {
                        return null;
                    }
                    if (poses.contains(checkPos)) continue;
                    poses.add(checkPos);
                }
            }
        }
        return poses;
    }
}

