/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.Random;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.tileentity.TileEntityMistChest;
import ru.liahim.mist.tileentity.TileEntityMistFurnace;
import ru.liahim.mist.tileentity.TileEntityUrn;
import ru.liahim.mist.util.GenUtil;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.biome.BiomeMistBorder;
import ru.liahim.mist.world.biome.BiomeMistUpDesert;
import ru.liahim.mist.world.biome.BiomeMistUpMarsh;
import ru.liahim.mist.world.biome.MistBiomeDecorator;
import ru.liahim.mist.world.generators.AltarsGen;
import ru.liahim.mist.world.generators.TombGenBase;
import ru.liahim.mist.world.generators.WellGen;

public class BasementsGen
extends TombGenBase {
    public static final NoiseGeneratorPerlin BASE_NOISE = new NoiseGeneratorPerlin(new Random(54321L), 1);

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        float f = (float)ModConfig.generation.basementGenerationChance;
        double d = BASE_NOISE.func_151601_a((double)pos.func_177958_n() * 0.01 * (double)f, (double)pos.func_177952_p() * 0.01 * (double)f);
        if (d <= 1.0 - 0.65 * (double)f) {
            return false;
        }
        BlockPos center = world.func_175645_m(pos.func_177982_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8));
        if (world.func_180495_p(center.func_177977_b()).func_185904_a().func_76222_j()) {
            center = center.func_177977_b();
        }
        if (center.func_177956_o() <= 125) {
            return false;
        }
        Biome biome = world.func_180494_b(center);
        if (!(biome instanceof BiomeMist) || !((BiomeMist)biome).isUpBiome() || biome instanceof BiomeMistBorder || biome instanceof BiomeMistUpMarsh || biome instanceof BiomeMistUpDesert || !(world.func_180495_p(center.func_177977_b()).func_177230_c() instanceof MistSoil)) {
            return false;
        }
        int l = rand.nextInt(3) + 5;
        int b = MathHelper.func_76125_a((int)(l - rand.nextInt(4)), (int)5, (int)7);
        int h = ((BiomeMist)biome).getBiomeType() == EnumBiomeType.Cold ? rand.nextInt(2) : 0;
        int deep = -3 - rand.nextInt(2);
        boolean corner = rand.nextBoolean();
        boolean columnar = false;
        EnumBiomeType type = ((BiomeMist)biome).getBiomeType();
        TombGenBase.Type[] bType = new TombGenBase.Type[]{TombGenBase.Type.COBBLE};
        if (type == EnumBiomeType.Jungle) {
            l = b;
            corner = false;
            columnar = rand.nextInt(4) == 0;
        } else if (type == EnumBiomeType.Desert) {
            corner = false;
            columnar = rand.nextInt(5) > 1;
        } else {
            boolean bl = columnar = rand.nextInt(4) == 0;
            if (type == EnumBiomeType.Cold) {
                if (rand.nextBoolean()) {
                    bType = new TombGenBase.Type[]{TombGenBase.Type.BRICK};
                } else if (rand.nextInt(4) > 0) {
                    bType = new TombGenBase.Type[]{TombGenBase.Type.BRICK, TombGenBase.Type.COBBLE, TombGenBase.Type.COBBLE};
                }
            } else if (type == EnumBiomeType.Forest && rand.nextBoolean()) {
                bType = new TombGenBase.Type[]{TombGenBase.Type.BRICK, TombGenBase.Type.COBBLE, TombGenBase.Type.COBBLE};
            }
        }
        if (columnar) {
            boolean big = rand.nextBoolean();
            if (l % 2 == 1) {
                l = big ? ++l : --l;
            }
            if (b % 2 == 1) {
                b = big ? ++b : --b;
            }
        }
        for (int i = 0; i < 5; ++i) {
            GenUtil gen = new GenUtil(world, new GenUtil.GenSet(center.func_177982_a(-b / 2, 0, -l / 2), Rotation.values()[rand.nextInt(4)], Mirror.values()[rand.nextInt(2)]));
            if (BasementsGen.roomCheck(gen, 0, b, deep, -1, 0, l, true)) {
                if (columnar) {
                    this.generateColumnar(gen, (BiomeMist)biome, 0, b, 0, l, rand, 1, (type == EnumBiomeType.Forest || type == EnumBiomeType.Cold) && rand.nextInt(3) > 0 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE);
                    continue;
                }
                this.generateRoom(gen, (BiomeMist)biome, 0, b, deep, h, 0, l, rand, 1, false, bType);
                if (corner && BasementsGen.roomCheck(gen, -3, -1, deep, -1, 0, 4, true)) {
                    this.generateRoom(gen, (BiomeMist)biome, -3, 0, deep, h, 0, 4, rand, 1, true, bType);
                }
                BiomeMist.looseRockGen.func_180709_b(world, rand, gen.set.center);
                return true;
            }
            if (rand.nextInt(8) == 0 && ((WellGen)MistBiomeDecorator.wellGen).generate(world, rand, pos, true)) {
                return true;
            }
            center = world.func_175645_m(pos.func_177982_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8));
        }
        return false;
    }

    private void generateRoom(GenUtil gen, BiomeMist biome, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Random rand, int wet, boolean neighbor, TombGenBase.Type ... type) {
        BlockPos center = gen.set.center;
        EnumBiomeType biomeType = biome.getBiomeType();
        boolean snow = biomeType == EnumBiomeType.Cold;
        int chance = (maxX - minX + maxZ - minZ) * 2;
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                IBlockState floor = MistBlocks.GRAVEL.func_176223_P();
                IBlockState top = biome.field_76752_A;
                IBlockState second = biome.secondTopBlock;
                IBlockState fill = biome.field_76753_B;
                if (biomeType == EnumBiomeType.Desert) {
                    wet = -1;
                    floor = sand;
                } else if (biomeType == EnumBiomeType.Jungle) {
                    floor = redSandWet;
                }
                if (((BiomeMist)gen.world.func_180494_b(gen.getPos(center.func_177982_a(x, 0, z)))).getBiomeType() == EnumBiomeType.Border) {
                    floor = fill = MistBlocks.STONE.func_176223_P();
                    second = top = MistBlocks.GRAVEL.func_176223_P();
                }
                for (int y = minY; y <= maxY; ++y) {
                    int i;
                    BlockPos checkPos = center.func_177982_a(x, y, z);
                    if (x == minX || x == maxX && !neighbor || z == minZ || z == maxZ) {
                        if (y < -1) {
                            if (y == minY + 1 && x == maxX && z == (maxZ + minZ) / 2 && rand.nextBoolean()) {
                                gen.setBlockState(checkPos, MistBlocks.FURNACE.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST));
                                TileEntityMistFurnace.initializeLoot(gen.getTileEntity(checkPos), rand);
                                continue;
                            }
                            gen.setBlockState(checkPos, BasementsGen.getBlock(type[rand.nextInt(type.length)], rand, -1));
                            continue;
                        }
                        if (y == -1) {
                            if (rand.nextInt(3) != 0) {
                                gen.setBlockState(checkPos, BasementsGen.getBlock(type[rand.nextInt(type.length)], rand, wet));
                                continue;
                            }
                            if (rand.nextInt(3) > 0 || (x == minX || x == maxX) && (z == minZ || z == maxZ)) {
                                gen.setBlockState(checkPos, BasementsGen.getBlock(type[rand.nextInt(type.length)], rand, wet));
                                if (!snow || !gen.world.func_175678_i(gen.getPos(checkPos.func_177984_a()))) continue block1;
                                gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                                continue block1;
                            }
                            if (x == minX) {
                                gen.setBlockState(checkPos, BasementsGen.getStairs(type[rand.nextInt(type.length)], EnumFacing.WEST, false, rand, wet));
                            } else if (x == maxX) {
                                gen.setBlockState(checkPos, BasementsGen.getStairs(type[rand.nextInt(type.length)], EnumFacing.EAST, false, rand, wet));
                            } else if (z == minZ) {
                                gen.setBlockState(checkPos, BasementsGen.getStairs(type[rand.nextInt(type.length)], EnumFacing.NORTH, false, rand, wet));
                            } else if (z == maxZ) {
                                gen.setBlockState(checkPos, BasementsGen.getStairs(type[rand.nextInt(type.length)], EnumFacing.SOUTH, false, rand, wet));
                            }
                            gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                            continue block1;
                        }
                        if (y != maxY && rand.nextInt(3) == 0) {
                            gen.setBlockState(checkPos, BasementsGen.getBlock(type[rand.nextInt(type.length)], rand, wet));
                            continue;
                        }
                        i = rand.nextInt(7);
                        if (i < 2) {
                            gen.setBlockState(checkPos, BasementsGen.getBlock(type[rand.nextInt(type.length)], rand, wet));
                            if (snow && gen.world.func_175678_i(gen.getPos(checkPos.func_177984_a()))) {
                                gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                            }
                        } else if (i < 5) {
                            gen.setBlockState(checkPos, BasementsGen.getSlab(type[rand.nextInt(type.length)], false, rand, wet));
                        } else if (i == 5) {
                            gen.setBlockState(checkPos, BasementsGen.getStairs(type[rand.nextInt(type.length)], EnumFacing.field_176754_o[rand.nextInt(4)], false, rand, wet));
                        } else if (i == 6) {
                            gen.setBlockState(checkPos, BasementsGen.getStep(type[rand.nextInt(type.length)], EnumFacing.field_176754_o[rand.nextInt(4)], false, rand, wet));
                        }
                        if (i < 2) continue block1;
                        gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                        continue block1;
                    }
                    if (y == minY) {
                        gen.setBlockState(checkPos, rand.nextBoolean() ? floor : (y == -3 ? second : fill));
                        continue;
                    }
                    if (y == -2) {
                        gen.setBlockState(checkPos, top);
                        if (!snow) continue;
                        if (gen.world.func_175678_i(gen.getPos(center.func_177982_a(x, maxY + 1, z)))) {
                            gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P(), 2);
                            continue;
                        }
                        gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    if (y == -3) {
                        if ((x == minX + 1 && neighbor || x == maxX - 1 && !neighbor || z == minZ + 1 || z == maxZ - 1) && rand.nextInt(chance) == 0) {
                            i = rand.nextInt(5);
                            if (i == 0) {
                                gen.setBlockState(checkPos, Blocks.field_150467_bQ.func_176223_P().func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)BlockAnvil.field_176506_a, (Comparable)(x == minX + 1 || x == maxX - 1 ? EnumFacing.NORTH : EnumFacing.EAST)));
                                continue;
                            }
                            if (i == 1) {
                                gen.setBlockState(checkPos, Blocks.field_150383_bp.func_176223_P());
                                continue;
                            }
                            if (rand.nextInt(5) > 1) {
                                this.placeUrn(gen, checkPos, biomeType, rand);
                                continue;
                            }
                            this.placeChest(gen, checkPos, x == minX + 1 ? EnumFacing.EAST : (x == maxX - 1 ? EnumFacing.WEST : (z == minZ + 1 ? EnumFacing.SOUTH : EnumFacing.NORTH)), biomeType, rand);
                            continue;
                        }
                        gen.setBlockState(checkPos, second);
                        continue;
                    }
                    if (snow && y < 0) continue;
                    gen.setBlockState(checkPos, Blocks.field_150350_a.func_176223_P());
                    if (gen.getBlockState(checkPos.func_177984_a()).func_177230_c() != Blocks.field_150431_aC) continue;
                    gen.setBlockState(checkPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private void generateColumnar(GenUtil gen, BiomeMist biome, int minX, int maxX, int minZ, int maxZ, Random rand, int wet, TombGenBase.Type type) {
        BlockPos center = gen.set.center;
        if (biome.getBiomeType() == EnumBiomeType.Desert) {
            wet = -1;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                BlockPos checkPos;
                if (x == minX || x == maxX || z == minZ || z == maxZ) {
                    if ((x - minX) % 2 != 0 || (z - minZ) % 2 != 0) continue;
                    checkPos = center.func_177982_a(x, -1, z);
                    gen.setBlockState(checkPos.func_177977_b(), BasementsGen.getBlock(type, rand, -1));
                    AltarsGen.generateColumn(gen.world, gen.getPos(checkPos), rand, 1, wet, type);
                    continue;
                }
                if (x != minX + 1 && x != maxX - 1 && z != minZ + 1 && z != maxZ - 1 || rand.nextInt((maxX - minX + maxZ - minZ) * 2) != 0 || !(gen.getBlockState(checkPos = center.func_177982_a(x, -2, z)).func_177230_c() instanceof IWettable)) continue;
                if (rand.nextInt(5) > 1) {
                    this.placeUrn(gen, checkPos, biome.getBiomeType(), rand);
                    continue;
                }
                this.placeChest(gen, checkPos, x == minX + 1 ? EnumFacing.EAST : (x == maxX - 1 ? EnumFacing.WEST : (z == minZ + 1 ? EnumFacing.SOUTH : EnumFacing.NORTH)), biome.getBiomeType(), rand);
            }
        }
    }

    private void placeChest(GenUtil gen, BlockPos pos, EnumFacing face, EnumBiomeType biomeType, Random rand) {
        gen.setBlockState(pos, MistBlocks.NIOBIUM_CHEST.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)face));
        TileEntityMistChest.initializeType(gen.getTileEntity(pos), biomeType, rand);
    }

    private void placeUrn(GenUtil gen, BlockPos pos, EnumBiomeType biomeType, Random rand) {
        gen.setBlockState(pos, MistBlocks.URN.func_176223_P());
        TileEntityUrn.UrnLootType.initializeType(gen.getTileEntity(pos), biomeType, TileEntityUrn.UrnLocation.BASEMENTS, rand);
    }
}

