/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.generators;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.tileentity.TileEntityUrn;
import ru.liahim.mist.util.GenUtil;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.biome.BiomeMistBorder;
import ru.liahim.mist.world.biome.BiomeMistUpDesert;
import ru.liahim.mist.world.biome.BiomeMistUpMarsh;
import ru.liahim.mist.world.generators.TombGenBase;

public class AltarsGen
extends TombGenBase {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if ((double)rand.nextFloat() >= ModConfig.generation.altarGenerationChance) {
            return false;
        }
        BlockPos center = world.func_175645_m(pos.func_177982_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8));
        if (world.func_180495_p(center.func_177977_b()).func_185904_a().func_76222_j()) {
            center = center.func_177977_b();
        }
        if (center.func_177956_o() <= 125) {
            return false;
        }
        Biome biome = world.func_180494_b(center);
        if (!(biome instanceof BiomeMist) || !((BiomeMist)biome).isUpBiome() || biome instanceof BiomeMistBorder || biome instanceof BiomeMistUpMarsh || biome instanceof BiomeMistUpDesert || !(world.func_180495_p(center.func_177977_b()).func_177230_c() instanceof MistSoil)) {
            return false;
        }
        EnumBiomeType type = ((BiomeMist)biome).getBiomeType();
        if (type == EnumBiomeType.Forest) {
            TombGenBase.Type bType = TombGenBase.Type.BRICK;
            if (AltarsGen.roomCheck(world, center, -3, 3, -1, -1, -3, 3, true)) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos checkPos = center.func_177982_a(x, -1, z);
                        if (x == -2 || x == 2 || z == -2 || z == 2) {
                            if (Math.abs(x * z) != 4 && rand.nextInt(32) == 0) continue;
                            world.func_180501_a(checkPos, AltarsGen.getBlock(TombGenBase.Type.COBBLE, rand, 1), 18);
                            continue;
                        }
                        if (x == 0 && z == 0) {
                            world.func_180501_a(checkPos, AltarsGen.getSlab(bType, false, rand, 1), 18);
                            continue;
                        }
                        if (rand.nextInt(32) == 0) {
                            world.func_180501_a(checkPos, AltarsGen.getSlab(bType, false, rand, 1), 18);
                            continue;
                        }
                        if (x == -1) {
                            world.func_180501_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.WEST, false, rand, 1), 18);
                            continue;
                        }
                        if (x == 1) {
                            world.func_180501_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.EAST, false, rand, 1), 18);
                            continue;
                        }
                        if (z == -1) {
                            world.func_180501_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.NORTH, false, rand, 1), 18);
                            continue;
                        }
                        world.func_180501_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.SOUTH, false, rand, 1), 18);
                    }
                }
                world.func_180501_a(center.func_177982_a(-2, 0, -2), AltarsGen.getSlab(bType, false, rand, 1), 18);
                world.func_180501_a(center.func_177982_a(-2, 0, 2), AltarsGen.getSlab(bType, false, rand, 1), 18);
                world.func_180501_a(center.func_177982_a(2, 0, -2), AltarsGen.getSlab(bType, false, rand, 1), 18);
                world.func_180501_a(center.func_177982_a(2, 0, 2), AltarsGen.getSlab(bType, false, rand, 1), 18);
                BiomeMist.looseRockGen.func_180709_b(world, rand, center);
                return true;
            }
        } else if (type == EnumBiomeType.Swamp) {
            TombGenBase.Type bType = TombGenBase.Type.COBBLE;
            for (int i = 0; i < 5; ++i) {
                if (AltarsGen.roomCheck(world, center, -6, 6, -1, -1, -6, 6, true)) {
                    int wet = 1;
                    int innerHight = 4;
                    int outerHight = 2;
                    AltarsGen.generateColumn(world, center.func_177982_a(-1, -1, -3), rand, innerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(1, -1, -3), rand, innerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(-3, -1, -1), rand, innerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(-3, -1, 1), rand, innerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(-1, -1, 3), rand, innerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(1, -1, 3), rand, innerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(3, -1, -1), rand, innerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(3, -1, 1), rand, innerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(0, -1, 6), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(3, -1, 5), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(5, -1, 3), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(6, -1, 0), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(5, -1, -3), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(3, -1, -5), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(0, -1, -6), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(-3, -1, -5), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(-5, -1, -3), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(-6, -1, 0), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(-5, -1, 3), rand, outerHight, wet, bType);
                    AltarsGen.generateColumn(world, center.func_177982_a(-3, -1, 5), rand, outerHight, wet, bType);
                    BiomeMist.looseRockGen.func_180709_b(world, rand, center);
                    return true;
                }
                center = world.func_175645_m(pos.func_177982_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8));
            }
        } else if (type == EnumBiomeType.Cold) {
            if (biome != MistBiomes.upSnowfields || rand.nextBoolean()) {
                TombGenBase.Type bType = TombGenBase.Type.COBBLE;
                for (int i = 0; i < 1; ++i) {
                    if (AltarsGen.roomCheck(world, center, -5, 5, -1, -1, -5, 5, true)) {
                        int wet = 1;
                        for (EnumFacing face : EnumFacing.field_176754_o) {
                            GenUtil gen = new GenUtil(world, new GenUtil.GenSet(center, face, Mirror.NONE));
                            if (rand.nextInt(8) == 0) {
                                AltarsGen.generateColumn(world, gen.getPos(center.func_177982_a(-1, -1, 5)), rand, rand.nextInt(3) + 1, wet, bType);
                                AltarsGen.generateColumn(world, gen.getPos(center.func_177982_a(1, -1, 5)), rand, rand.nextInt(3) + 1, wet, bType);
                            } else {
                                for (int j = -1; j < 3; ++j) {
                                    gen.setBlockState(center.func_177982_a(-1, j, 5), AltarsGen.getBlock(bType, rand, wet));
                                    gen.setBlockState(center.func_177982_a(1, j, 5), AltarsGen.getBlock(bType, rand, wet));
                                }
                                gen.setBlockState(center.func_177982_a(-1, 3, 5), AltarsGen.getStairs(bType, EnumFacing.EAST, false, rand, wet));
                                gen.setBlockState(center.func_177982_a(1, 3, 5), AltarsGen.getStairs(bType, EnumFacing.WEST, false, rand, wet));
                                gen.setBlockState(center.func_177982_a(0, 3, 5), AltarsGen.getBlock(bType, rand, wet));
                                if (world.func_175678_i(gen.getPos(center.func_177982_a(0, 4, 5)))) {
                                    gen.setBlockState(center.func_177982_a(0, 4, 5), Blocks.field_150431_aC.func_176223_P());
                                }
                                if (gen.getBlockState(center.func_177982_a(0, 0, 5)).func_177230_c() == Blocks.field_150431_aC) {
                                    gen.setBlockState(center.func_177982_a(0, 0, 5), Blocks.field_150350_a.func_176223_P());
                                }
                            }
                            BiomeMist.looseRockGen.func_180709_b(world, rand, center.func_177981_b(3));
                        }
                        return true;
                    }
                    center = world.func_175645_m(pos.func_177982_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8));
                }
            }
        } else if (type == EnumBiomeType.Desert) {
            if (AltarsGen.roomCheck(world, center, -1, 1, -1, -1, -1, 1, true)) {
                TombGenBase.Type bType = TombGenBase.Type.COBBLE;
                int wet = -1;
                int h = rand.nextInt(4) + 1;
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int y = -1; y < h; ++y) {
                            BlockPos checkPos = center.func_177982_a(x, y, z);
                            if (x != 0 && z != 0) {
                                if (y == -1) {
                                    world.func_175656_a(checkPos, AltarsGen.getBlock(bType, rand, wet));
                                    continue;
                                }
                                if (x == -1) {
                                    world.func_175656_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.EAST, false, rand, wet));
                                    continue;
                                }
                                world.func_175656_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.WEST, false, rand, wet));
                                continue;
                            }
                            if (x != 0 || z != 0) {
                                if (y == -1) {
                                    if (x == -1) {
                                        world.func_175656_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.WEST, false, rand, wet));
                                        continue;
                                    }
                                    if (x == 1) {
                                        world.func_175656_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.EAST, false, rand, wet));
                                        continue;
                                    }
                                    if (z == -1) {
                                        world.func_175656_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.NORTH, false, rand, wet));
                                        continue;
                                    }
                                    world.func_175656_a(checkPos, AltarsGen.getStairs(bType, EnumFacing.SOUTH, false, rand, wet));
                                    continue;
                                }
                                if (x == -1) {
                                    world.func_175656_a(checkPos, AltarsGen.getStep(bType, EnumFacing.EAST, true, rand, wet));
                                    continue;
                                }
                                if (x == 1) {
                                    world.func_175656_a(checkPos, AltarsGen.getStep(bType, EnumFacing.WEST, true, rand, wet));
                                    continue;
                                }
                                if (z == -1) {
                                    world.func_175656_a(checkPos, AltarsGen.getStep(bType, EnumFacing.SOUTH, true, rand, wet));
                                    continue;
                                }
                                world.func_175656_a(checkPos, AltarsGen.getStep(bType, EnumFacing.NORTH, true, rand, wet));
                                continue;
                            }
                            world.func_175656_a(checkPos, Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                world.func_175656_a(center.func_177981_b(h), AltarsGen.getSlab(bType, false, rand, wet));
                world.func_175656_a(center.func_177979_c(2), AltarsGen.getBlock(bType, rand, wet));
                if (rand.nextBoolean()) {
                    world.func_175656_a(center.func_177977_b(), MistBlocks.URN.func_176223_P());
                    TileEntityUrn.UrnLootType.initializeType(world.func_175625_s(center.func_177977_b()), EnumBiomeType.Desert, TileEntityUrn.UrnLocation.ALTARS, rand);
                }
                BiomeMist.looseRockGen.func_180709_b(world, rand, center.func_177981_b(3));
                return true;
            }
        } else if (type == EnumBiomeType.Jungle && AltarsGen.roomCheck(world, center, -2, 2, -1, -1, -2, 2, true) && world.func_175678_i(center.func_177968_d()) && world.func_175678_i(center.func_177978_c())) {
            this.generatePillar(world, center.func_177978_c(), EnumFacing.NORTH, rand, 6, 0, TombGenBase.Type.COBBLE);
            this.generatePillar(world, center.func_177968_d(), EnumFacing.SOUTH, rand, 8, 0, TombGenBase.Type.COBBLE);
            BiomeMist.looseRockGen.func_180709_b(world, rand, center.func_177981_b(3));
            return true;
        }
        return false;
    }

    public static int generateColumn(World world, BlockPos pos, Random rand, int hight, int wet, TombGenBase.Type ... type) {
        hight -= rand.nextInt(rand.nextInt(rand.nextInt(hight) + 1) + 1);
        for (int i = 0; i < hight; ++i) {
            world.func_180501_a(pos.func_177981_b(i), AltarsGen.getBlock(type[rand.nextInt(type.length)], rand, wet), 18);
        }
        int j = rand.nextInt(5);
        if (j == 0) {
            world.func_180501_a(pos.func_177981_b(hight), AltarsGen.getSlab(type[rand.nextInt(type.length)], false, rand, wet), 18);
        } else if (j == 1) {
            world.func_180501_a(pos.func_177981_b(hight), AltarsGen.getStep(type[rand.nextInt(type.length)], EnumFacing.func_176731_b((int)rand.nextInt(4)), false, rand, wet), 18);
        } else if (j == 2) {
            world.func_180501_a(pos.func_177981_b(hight), AltarsGen.getStairs(type[rand.nextInt(type.length)], EnumFacing.func_176731_b((int)rand.nextInt(4)), false, rand, wet), 18);
        } else {
            world.func_180501_a(pos.func_177981_b(hight), AltarsGen.getBlock(type[rand.nextInt(type.length)], rand, wet), 18);
            pos = pos.func_177981_b(hight + 1);
            if (world.func_180494_b(pos).func_150559_j() && world.func_175678_i(pos)) {
                world.func_180501_a(pos, Blocks.field_150431_aC.func_176223_P(), 18);
            }
        }
        return hight;
    }

    private void generatePillar(World world, BlockPos pos, EnumFacing side, Random rand, int hight, int wet, TombGenBase.Type type) {
        if (rand.nextInt(6) > 0) {
            for (int i = -1; i <= hight; ++i) {
                world.func_175656_a(pos.func_177981_b(i), AltarsGen.getBlock(i < hight && rand.nextInt(4) == 0 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE, rand, i < 1 ? 1 : wet));
            }
            world.func_175656_a(pos.func_177981_b(hight + 1), AltarsGen.getStep(type, side.func_176734_d(), false, rand, wet));
            world.func_175656_a(pos.func_177972_a(side.func_176734_d()).func_177981_b(hight + 1), AltarsGen.getStep(type, side, false, rand, wet));
            world.func_175656_a(pos.func_177972_a(side.func_176734_d()).func_177981_b(hight), AltarsGen.getStep(type, side, true, rand, wet));
        } else {
            int h = hight + 2 - AltarsGen.generateColumn(world, pos.func_177977_b(), rand, hight - 3, wet, TombGenBase.Type.COBBLE, TombGenBase.Type.COBBLE, TombGenBase.Type.COBBLE, TombGenBase.Type.BRICK);
            for (EnumFacing face : EnumFacing.field_176754_o) {
                if (face == side.func_176734_d() || !rand.nextBoolean()) continue;
                for (int i = 2; i <= h; ++i) {
                    if (i > 2 && i < h && world.isSideSolid(pos.func_177967_a(face, i).func_177977_b(), EnumFacing.UP)) {
                        world.func_175656_a(pos.func_177967_a(face, i), AltarsGen.getBlock(rand.nextInt(4) == 0 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE, rand, wet));
                        continue;
                    }
                    int f = rand.nextInt(6);
                    if (i == 2) {
                        if (f < 5) {
                            world.func_175656_a(pos.func_177967_a(face, i), AltarsGen.getStairs(rand.nextInt(4) == 0 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE, face, f < 3, rand, wet));
                            continue;
                        }
                        world.func_175656_a(pos.func_177967_a(face, i), AltarsGen.getBlock(rand.nextInt(4) == 0 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE, rand, wet));
                        continue;
                    }
                    if (i != h) continue;
                    if (f < 5) {
                        world.func_175656_a(pos.func_177967_a(face, i), AltarsGen.getStairs(rand.nextInt(4) == 0 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE, face.func_176734_d(), f < 2, rand, wet));
                        continue;
                    }
                    world.func_175656_a(pos.func_177967_a(face, i), AltarsGen.getBlock(rand.nextInt(4) == 0 ? TombGenBase.Type.BRICK : TombGenBase.Type.COBBLE, rand, wet));
                }
                break;
            }
        }
    }
}

