/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.downplant.MistSponge;
import ru.liahim.mist.world.biome.BiomeMist;
import ru.liahim.mist.world.biome.BiomeMistBorderDown;
import ru.liahim.mist.world.biome.BiomeMistBorderUp;
import ru.liahim.mist.world.generators.AltarsGen;
import ru.liahim.mist.world.generators.BasementsGen;
import ru.liahim.mist.world.generators.BioShaleAndSulfurGenerator;
import ru.liahim.mist.world.generators.CliffTombGen;
import ru.liahim.mist.world.generators.LapisGenerator;
import ru.liahim.mist.world.generators.SaltGenerator;
import ru.liahim.mist.world.generators.SingleBlockGenerator;
import ru.liahim.mist.world.generators.TombGen;
import ru.liahim.mist.world.generators.WellGen;

public class MistBiomeDecorator
extends BiomeDecorator {
    public WorldGenerator filterCoalGen;
    public WorldGenerator field_76818_l;
    public WorldGenerator field_76819_m;
    public WorldGenerator mistGravelGen;
    public WorldGenerator niobiumGen;
    public WorldGenerator bioShaleGen;
    public WorldGenerator saltpeterGen;
    public WorldGenerator saltGen;
    public WorldGenerator field_76831_p;
    public WorldGenerator acidPocket;
    public static WorldGenerator wellGen = new WellGen();
    public static WorldGenerator tombGen = new TombGen();
    public static WorldGenerator cliffTombGen = new CliffTombGen();
    public static WorldGenerator altarsGen = new AltarsGen();
    public static WorldGenerator basementsGen = new BasementsGen();

    public void func_180292_a(World world, Random rand, Biome biome, BlockPos pos) {
        if (this.field_185425_a) {
            throw new RuntimeException("Already decorating");
        }
        this.field_180294_c = pos;
        this.filterCoalGen = new SingleBlockGenerator(MistBlocks.FILTER_COAL_ORE.func_176223_P(), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)MistBlocks.STONE));
        this.field_76818_l = new WorldGenMinable(MistBlocks.IRON_ORE.func_176223_P(), 9, (Predicate)BlockMatcher.func_177642_a((Block)MistBlocks.STONE));
        this.mistGravelGen = new WorldGenMinable(MistBlocks.GRAVEL.func_176223_P(), 30, (Predicate)BlockMatcher.func_177642_a((Block)MistBlocks.STONE_POROUS));
        this.field_76819_m = new WorldGenMinable(MistBlocks.GOLD_ORE.func_176223_P(), 9, (Predicate)BlockMatcher.func_177642_a((Block)MistBlocks.STONE_POROUS));
        this.niobiumGen = new WorldGenMinable(MistBlocks.NIOBIUM_ORE.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)MistBlocks.STONE_POROUS));
        this.bioShaleGen = new BioShaleAndSulfurGenerator(12, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)MistBlocks.STONE_POROUS));
        this.saltpeterGen = new WorldGenMinable(MistBlocks.SALTPETER_ORE.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)MistBlocks.STONE_POROUS));
        this.saltGen = new SaltGenerator();
        this.field_76831_p = new LapisGenerator();
        this.acidPocket = new SingleBlockGenerator(MistBlocks.ACID_BLOCK.func_176223_P(), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)MistBlocks.STONE_POROUS));
        this.genDecorations((BiomeMist)biome, world, rand);
        this.field_185425_a = false;
    }

    protected void genDecorations(BiomeMist biome, World world, Random rand) {
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, rand, forgeChunkPos));
        this.generateStructures(biome, world, rand);
        this.func_76797_b(world, rand);
        EnumBiomeType biomeType = biome.getBiomeType();
        if (biomeType == EnumBiomeType.Down && biome != MistBiomes.downCenter && rand.nextFloat() < 0.05f) {
            int rx = rand.nextInt(16) + 8;
            int rz = rand.nextInt(16) + 8;
            BlockPos pos = world.func_175645_m(this.field_180294_c.func_177982_a(rx, 0, rz));
            ((MistSponge)MistBlocks.SPONGE).generateSponge(world, pos, rand);
        }
        if (biomeType != EnumBiomeType.Down && biomeType != EnumBiomeType.Border) {
            for (int i3 = 0; i3 < this.field_76803_B; ++i3) {
                int rz;
                int rx = rand.nextInt(16) + 8;
                int h = world.func_175645_m(this.field_180294_c.func_177982_a(rx, 0, rz = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (h <= 0) continue;
                int ry = rand.nextInt(h);
                biome.func_76730_b(rand).func_180709_b(world, rand, this.field_180294_c.func_177982_a(rx, ry, rz));
            }
        }
        if (biomeType != EnumBiomeType.Down && biome != MistBiomes.upDesert && biome != MistBiomes.upDunes) {
            int i = biome instanceof BiomeMistBorderDown ? 4 : (biome instanceof BiomeMistBorderUp ? (rand.nextInt(4) == 0 ? 1 : 0) : rand.nextInt(2));
            for (int i4 = 0; i4 < i; ++i4) {
                int rz;
                int rx = rand.nextInt(16) + 8;
                int h = world.func_175645_m(this.field_180294_c.func_177982_a(rx, 0, rz = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (h <= 0) continue;
                int ry = rand.nextInt(h);
                BiomeMist.looseRockGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(rx, ry, rz));
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, rand, forgeChunkPos));
    }

    protected void generateStructures(BiomeMist biome, World world, Random rand) {
        boolean check = basementsGen.func_180709_b(world, rand, this.field_180294_c);
        if (!check) {
            check = wellGen.func_180709_b(world, rand, this.field_180294_c);
        }
        if (!check) {
            check = tombGen.func_180709_b(world, rand, this.field_180294_c);
        }
        if (!check) {
            check = cliffTombGen.func_180709_b(world, rand, this.field_180294_c);
        }
        if (!check) {
            check = altarsGen.func_180709_b(world, rand, this.field_180294_c);
        }
    }

    protected void func_76797_b(World world, Random rand) {
        this.func_76795_a(world, rand, 2, this.filterCoalGen, 112, 130);
        this.func_76795_a(world, rand, 3, this.field_76818_l, 108, 145);
        this.func_76795_a(world, rand, 8, this.mistGravelGen, 26, 112);
        this.func_76793_b(world, rand, 5, this.field_76819_m, 26, 86);
        this.func_76793_b(world, rand, 50, this.niobiumGen, 112, 86);
        this.func_76793_b(world, rand, 15, this.bioShaleGen, 26, 86);
        this.func_76793_b(world, rand, 8, this.saltpeterGen, 112, 50);
        this.saltGen.func_180709_b(world, rand, this.field_180294_c);
        this.func_76793_b(world, rand, 3, this.field_76831_p, 112, 15);
        this.func_76793_b(world, rand, 10, this.acidPocket, 26, 50);
    }
}

