/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.upperplant.MistMushroom;
import ru.liahim.mist.block.upperplant.MistMycelium;
import ru.liahim.mist.entity.EntityGalaga;
import ru.liahim.mist.entity.EntityMossling;
import ru.liahim.mist.entity.EntitySwampCrab;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class BiomeMistUpSwampBase
extends BiomeMistUp {
    protected final int mistPoplarPerChunk;
    protected final boolean genWillowTree;

    public BiomeMistUpSwampBase(Biome.BiomeProperties properties, int mistPoplarPerChunk, boolean genWillowTree) {
        super(properties);
        this.field_76752_A = MistBlocks.GRASS_C.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2));
        this.secondTopBlock = MistBlocks.DIRT_C.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1));
        this.field_76753_B = MistBlocks.DIRT_C.func_176223_P();
        this.mistPoplarPerChunk = mistPoplarPerChunk;
        this.genWillowTree = genWillowTree;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityMossling.class, 15, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityGalaga.class, 5, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySwampCrab.class, 20, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 0, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        double d0 = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.1, (double)pos.func_177952_p() * 0.1);
        return d0 < -0.1 ? 8961127 : 8369246;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 7247677;
    }

    @Override
    public EnumBiomeType getBiomeType() {
        return EnumBiomeType.Swamp;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int rz;
        int i;
        BlockPos randPos;
        int rz2;
        int rx;
        if (this.mistPoplarPerChunk > 0 && rand.nextFloat() < 0.04f) {
            rx = rand.nextInt(16) + 8;
            rz2 = rand.nextInt(16) + 8;
            randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz2));
            if (rand.nextBoolean()) {
                ((MistTreeTrunk)MistBlocks.ASPEN_TRUNK).generateTrunk(world, randPos, rand);
            } else {
                ((MistTreeTrunk)MistBlocks.POPLAR_TRUNK).generateTrunk(world, randPos, rand);
            }
        }
        if (this.genWillowTree && rand.nextFloat() < 0.01f) {
            rx = rand.nextInt(16) + 8;
            rz2 = rand.nextInt(16) + 8;
            randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz2));
            ((MistTreeTrunk)MistBlocks.WILLOW_TRUNK).generateTrunk(world, randPos, rand);
        }
        super.func_180624_a(world, rand, pos);
        int j = this.mistPoplarPerChunk;
        if (rand.nextFloat() < this.getMistBiomeDecorator().field_189870_A) {
            ++j;
        }
        for (i = 0; i < j; ++i) {
            if (rand.nextInt(3) > 0) {
                int rx2 = rand.nextInt(16) + 8;
                rz = rand.nextInt(16) + 8;
                BlockPos randPos2 = world.func_175645_m(pos.func_177982_a(rx2, 0, rz));
                ((MistTreeTrunk)MistBlocks.ASPEN_TRUNK).generateTree(world, randPos2, rand);
                continue;
            }
            int k = rand.nextInt(rand.nextInt(3) + 1) + 1;
            for (int i1 = 0; i1 < k; ++i1) {
                int rx1 = rand.nextInt(16) + 8;
                int rz1 = rand.nextInt(16) + 8;
                BlockPos randPos3 = world.func_175645_m(pos.func_177982_a(rx1, 0, rz1));
                ((MistTreeTrunk)MistBlocks.POPLAR_TRUNK).generateTree(world, randPos3, rand);
            }
        }
        if (this.genWillowTree && rand.nextFloat() < 0.7f) {
            int k = rand.nextInt(rand.nextInt(3) + 1) + 1;
            for (int i2 = 0; i2 < k; ++i2) {
                int rx3 = rand.nextInt(16) + 8;
                int rz3 = rand.nextInt(16) + 8;
                BlockPos randPos4 = world.func_175645_m(pos.func_177982_a(rx3, 0, rz3));
                ((MistTreeTrunk)MistBlocks.WILLOW_TRUNK).generateTree(world, randPos4, rand);
            }
        }
        if (this.genWillowTree) {
            if (rand.nextInt(16) == 0) {
                if (rand.nextInt(3) == 0) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.WHITE)), rand);
                } else {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.GREEN)), rand);
                }
            }
            if (rand.nextInt(16) == 0) {
                i = rand.nextInt(6);
                if (i < 3) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.MARSH)), rand);
                } else if (i < 5) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PINK)), rand);
                } else {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PUFF)), rand);
                }
            }
        } else if (this.mistPoplarPerChunk > 0) {
            int i3;
            double mushroomNoise = TREE_NOISE.func_151601_a((double)pos.func_177958_n() * 0.003, (double)pos.func_177952_p() * 0.003);
            if (rand.nextInt(16) == 0) {
                i3 = rand.nextInt(3);
                if (i3 == 0) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.WHITE)), rand);
                } else if (i3 == 1) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.GREEN)), rand);
                } else if (mushroomNoise > 0.2) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.VIOLET)), rand);
                }
            }
            if (rand.nextInt(24) == 0) {
                if (mushroomNoise > 0.2) {
                    if (rand.nextBoolean()) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PUFF)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.GRAY)), rand);
                    }
                } else {
                    i3 = rand.nextInt(5);
                    if (i3 < 2) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PUFF)), rand);
                    } else if (i3 < 4) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PINK)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.YELLOW)), rand);
                    }
                }
            }
        }
        if (this != MistBiomes.upSwampyForest) {
            field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.GRASS);
            for (int k = 0; k < 20; ++k) {
                int rx4 = rand.nextInt(16) + 8;
                rz = rand.nextInt(16) + 8;
                int ry = rand.nextInt(world.func_175645_m(pos.func_177982_a(rx4, 0, rz)).func_177956_o() + 32);
                if (field_180280_ag.func_180709_b(world, rand, new BlockPos(pos.func_177958_n() + rx4, ry, pos.func_177952_p() + rz))) break;
            }
        }
    }

    @Override
    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        ArrayList<Double> noises = new ArrayList<Double>();
        double clayNoise = CLAY_NOISE.func_151601_a((double)x * 0.01, (double)z * 0.01);
        noises.add(clayNoise + CLAY_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3) * 0.02);
        double gravelNoise = GRAVEL_NOISE.func_151601_a((double)x * 0.05, (double)z * 0.05);
        noises.add(gravelNoise += GRAVEL_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3) * 0.3);
        double sapropelNoise = SAPROPEL_NOISE.func_151601_a((double)x * 0.02, (double)z * 0.02);
        noises.add(sapropelNoise += SAPROPEL_NOISE.func_151601_a((double)x * 0.1, (double)z * 0.1) * 0.3);
        return noises;
    }

    @Override
    public IBlockState getSecondTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return noises.get(0) > 0.7 ? MistBlocks.CLAY.func_176223_P() : this.secondTopBlock;
    }

    @Override
    public IBlockState getFillerBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return noises.get(0) > 0.6 ? MistBlocks.CLAY.func_176223_P() : this.field_76753_B;
    }

    @Override
    protected IBlockState getSecondBottom(Random rand, ArrayList<Double> noises) {
        return noises.get(0) > 0.65 ? MistBlocks.CLAY.func_176223_P() : this.secondTopBlock;
    }

    @Override
    protected void placeTopBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        if (y < 124 && noises.get(2) > 1.0 - (double)(125 - y) / 10.0 && state.func_177230_c() != MistBlocks.CLAY) {
            chunkPrimer.func_177855_a(x, y, z, MistBlocks.SAPROPEL.func_176223_P());
        } else {
            chunkPrimer.func_177855_a(x, y, z, state);
        }
    }

    @Override
    protected void placeSecondTopBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        if (y < 123 && state.func_177230_c() == MistBlocks.DIRT_C) {
            if (chunkPrimer.func_177856_a(x, y + 1, z).func_177230_c() == MistBlocks.SAPROPEL) {
                chunkPrimer.func_177855_a(x, y, z, state.func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2)));
            } else {
                chunkPrimer.func_177855_a(x, y, z, state);
            }
        } else {
            chunkPrimer.func_177855_a(x, y, z, state);
        }
    }

    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenTallGrass(rand.nextInt(4) == 0 ? BlockTallGrass.EnumType.FERN : BlockTallGrass.EnumType.GRASS);
    }

    @Override
    public void addDefaultFlowers() {
        this.addFlower(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN), 80);
    }
}

