/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.upperplant.MistMushroom;
import ru.liahim.mist.block.upperplant.MistMycelium;
import ru.liahim.mist.entity.EntityBarvog;
import ru.liahim.mist.entity.EntityCaravan;
import ru.liahim.mist.entity.EntityCyclops;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;
import ru.liahim.mist.world.generators.DesertCottonGenerator;

public class BiomeMistUpSavanna
extends BiomeMistUp {
    private final IBlockState sand = MistBlocks.SAND.func_176223_P();

    public BiomeMistUpSavanna(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76752_A = MistBlocks.GRASS_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false));
        this.secondTopBlock = MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false));
        this.field_76753_B = MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false));
        this.getMistBiomeDecorator().field_76803_B = 5;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityCaravan.class, 5, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityBarvog.class, 20, 1, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityCyclops.class, 20, 2, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 0, 1));
    }

    @Override
    public EnumBiomeType getBiomeType() {
        return EnumBiomeType.Desert;
    }

    @Override
    public float func_76741_f() {
        return 0.01f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        double grassNoise = Biome.field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.02, (double)pos.func_177952_p() * 0.05);
        return (grassNoise += Biome.field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.2, (double)pos.func_177952_p() * 0.5)) > (double)0.6f ? -5679071 : -5850290;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        BlockPos randPos;
        int rz;
        int rx;
        if (rand.nextFloat() < 0.03f) {
            rx = rand.nextInt(16) + 8;
            rz = rand.nextInt(16) + 8;
            randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
            ((MistTreeTrunk)MistBlocks.ACACIA_TRUNK).generateTrunk(world, randPos, rand);
        }
        if (rand.nextFloat() < 0.02f) {
            rx = rand.nextInt(16) + 8;
            rz = rand.nextInt(16) + 8;
            randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
            ((MistTreeTrunk)MistBlocks.A_TREE_TRUNK).generateTrunk(world, randPos, rand);
        }
        super.func_180624_a(world, rand, pos);
        if (rand.nextFloat() < 0.7f) {
            rx = rand.nextInt(16) + 8;
            rz = rand.nextInt(16) + 8;
            randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
            ((MistTreeTrunk)MistBlocks.ACACIA_TRUNK).generateTree(world, randPos, rand);
        }
        if (rand.nextFloat() < 0.2f) {
            int k = rand.nextInt(6);
            for (int i = 0; i < k; ++i) {
                int rx2 = rand.nextInt(16) + 8;
                int rz2 = rand.nextInt(16) + 8;
                BlockPos randPos2 = world.func_175645_m(pos.func_177982_a(rx2, 0, rz2));
                ((MistTreeTrunk)MistBlocks.A_TREE_TRUNK).generateTree(world, randPos2, rand);
            }
        }
        if (rand.nextInt(16) == 0) {
            MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.TAN)), rand);
        }
        if (rand.nextInt(24) == 0) {
            MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.SAND)), rand);
        }
    }

    @Override
    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        ArrayList<Double> noises = new ArrayList<Double>();
        double sandNoise = SAND_NOISE.func_151601_a((double)x * 0.02, (double)z * 0.02);
        noises.add(sandNoise + SAND_NOISE.func_151601_a((double)x * 0.1, (double)z * 0.1) * 0.2);
        noises.add(SAND_NOISE.func_151601_a((double)x * 0.2, (double)z * 0.2) + sandNoise * 0.4);
        return noises;
    }

    @Override
    public IBlockState getTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return noises.get(0) > 0.5 ? MistBlocks.GRASS_S.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1)) : this.field_76752_A;
    }

    @Override
    public IBlockState getSecondTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        double sandNoise = noises.get(0);
        return sandNoise > 0.5 ? this.sand : (sandNoise > 0.4 ? MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false)) : this.secondTopBlock);
    }

    @Override
    public IBlockState getFillerBlock(Random rand, @Nullable ArrayList<Double> noises) {
        double sandNoise = noises.get(0);
        return sandNoise > 0.4 ? this.sand : this.field_76753_B;
    }

    @Override
    protected IBlockState getBottom(Random rand, @Nullable ArrayList<Double> noises) {
        return noises.get(0) > 0.5 || noises.get(1) > 0.4 ? this.sand.func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true)) : MistBlocks.DIRT_S.func_176223_P();
    }

    @Override
    protected IBlockState getSecondBottom(Random rand, ArrayList<Double> noises) {
        double sandNoise = noises.get(0);
        return sandNoise > 0.4 ? this.sand : (sandNoise > 0.3 ? MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true)) : this.secondTopBlock.func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected IBlockState getZeroBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return noises.get(0) < -0.5 ? MistWorld.gravelBlock : null;
    }

    public double getClayNoise(BlockPos pos) {
        double clayNoise = CLAY_NOISE.func_151601_a((double)pos.func_177958_n() * 0.02, (double)pos.func_177952_p() * 0.02);
        return clayNoise += CLAY_NOISE.func_151601_a((double)pos.func_177958_n() * 0.1, (double)pos.func_177952_p() * 0.1) * 0.1;
    }

    public WorldGenerator func_76730_b(Random rand) {
        return rand.nextInt(16) == 0 ? new DesertCottonGenerator() : super.func_76730_b(rand);
    }
}

