/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.world.biome.Biome;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.entity.EntityForestRunner;
import ru.liahim.mist.entity.EntityForestSpider;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class BiomeMistUpMeadow
extends BiomeMistUp {
    private IBlockState sand = MistBlocks.SAND.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true));

    public BiomeMistUpMeadow(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76752_A = MistBlocks.GRASS_F.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2));
        this.secondTopBlock = MistBlocks.DIRT_F.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1));
        this.field_76753_B = MistBlocks.DIRT_F.func_176223_P();
        this.getMistBiomeDecorator().field_76803_B = 10;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityForestRunner.class, 20, 1, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityForestSpider.class, 20, 2, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 0, 1));
    }

    @Override
    public EnumBiomeType getBiomeType() {
        return EnumBiomeType.Forest;
    }

    @Override
    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        ArrayList<Double> noises = new ArrayList<Double>();
        double sandNoise = SAND_NOISE.func_151601_a((double)x * 0.02, (double)z * 0.02);
        double minorSandNoise = SAND_NOISE.func_151601_a((double)x * 0.2, (double)z * 0.2);
        double clayNoise = CLAY_NOISE.func_151601_a((double)x * 0.01, (double)z * 0.01);
        noises.add(sandNoise + minorSandNoise * 0.2);
        noises.add(sandNoise + minorSandNoise * 0.1);
        noises.add(clayNoise);
        double gravelNoise = GRAVEL_NOISE.func_151601_a((double)x * 0.05, (double)z * 0.05);
        noises.add(gravelNoise += GRAVEL_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3) * 0.3);
        return noises;
    }

    @Override
    public IBlockState getTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        if (noises.get(2) > 0.7) {
            return this.field_76752_A;
        }
        double sandNoise = noises.get(1);
        if (sandNoise > 0.5) {
            return this.sand.func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false));
        }
        if (sandNoise > 0.4) {
            return MistBlocks.GRASS_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0));
        }
        if (sandNoise > 0.3) {
            return MistBlocks.GRASS_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1));
        }
        return this.field_76752_A;
    }

    @Override
    public IBlockState getSecondTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        double sandNoise = noises.get(0);
        double clayNoise = noises.get(2);
        if (noises.get(3) > 0.7 && sandNoise <= 0.4) {
            return MistWorld.gravelBlock;
        }
        if (clayNoise > 0.7) {
            return sandNoise < 0.4 ? MistBlocks.DIRT_C.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1)) : this.secondTopBlock;
        }
        return sandNoise > 0.4 ? this.sand : (sandNoise > 0.3 ? MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)) : this.secondTopBlock);
    }

    @Override
    public IBlockState getFillerBlock(Random rand, @Nullable ArrayList<Double> noises) {
        double sandNoise = noises.get(0);
        double clayNoise = noises.get(2);
        if (noises.get(3) > 0.5 && sandNoise <= 0.3) {
            return MistWorld.gravelBlock;
        }
        if (clayNoise > 0.7) {
            return MistBlocks.CLAY.func_176223_P();
        }
        if (clayNoise > 0.6) {
            return clayNoise > 0.65 || sandNoise < 0.3 ? MistBlocks.DIRT_C.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)) : this.field_76753_B;
        }
        return sandNoise > 0.3 ? this.sand : (sandNoise > 0.2 ? MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)) : this.field_76753_B);
    }

    @Override
    protected IBlockState getBottom(Random rand, @Nullable ArrayList<Double> noises) {
        IBlockState state = super.getBottom(rand, noises);
        return noises.get(3) > 0.5 && state.func_177230_c() != MistBlocks.SAND ? MistWorld.gravelBlock : state;
    }

    @Override
    protected IBlockState getSecondBottom(Random rand, @Nullable ArrayList<Double> noises) {
        IBlockState state = super.getBottom(rand, noises);
        return noises.get(3) > 0.4 && state.func_177230_c() != MistBlocks.SAND ? MistWorld.gravelBlock : state;
    }
}

