/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.world.biome.BiomeMistUpSwampBase;

public class BiomeMistUpMarsh
extends BiomeMistUpSwampBase {
    private final boolean floatingMat;

    public BiomeMistUpMarsh(Biome.BiomeProperties properties, boolean floatingMat) {
        super(properties, -999, false);
        this.getMistBiomeDecorator().field_76803_B = 10;
        this.floatingMat = floatingMat;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 8040520;
    }

    @Override
    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        ArrayList<Double> noises = super.getNoises(x, z);
        noises.add(FLOATING_MAT_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3));
        return noises;
    }

    @Override
    protected void placeTopBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        if (this.floatingMat && y < 125 && state.func_177230_c() != MistBlocks.CLAY) {
            if (chunkPrimer.func_177856_a(x, y + 2, z).func_177230_c() == Blocks.field_150350_a) {
                chunkPrimer.func_177855_a(x, y + 1, z, Blocks.field_150399_cn.func_176223_P());
            } else if (noises.get(3) > 0.0 && chunkPrimer.func_177856_a(x, y + 3, z).func_177230_c() == Blocks.field_150350_a) {
                chunkPrimer.func_177855_a(x, y + 2, z, Blocks.field_150399_cn.func_176223_P());
            }
            if (y < 124 && noises.get(2) > 1.0 - (double)(125 - y) / 10.0) {
                chunkPrimer.func_177855_a(x, y, z, MistBlocks.SAPROPEL.func_176223_P());
            } else {
                chunkPrimer.func_177855_a(x, y, z, state);
            }
        } else {
            chunkPrimer.func_177855_a(x, y, z, state);
        }
    }

    @Override
    public boolean placePlant(World world, BlockPos pos, Random rand) {
        if (world.func_175623_d(pos)) {
            int i = rand.nextInt(4);
            if (i == 0) {
                if (Blocks.field_150329_H.func_180671_f(world, pos, this.grass)) {
                    return world.func_180501_a(pos, this.grass, 2);
                }
            } else if (i == 1 && Blocks.field_150329_H.func_180671_f(world, pos, this.grass)) {
                return world.func_180501_a(pos, this.grassDown, 2) && world.func_180501_a(pos.func_177984_a(), this.grassUp, 2);
            }
        }
        return false;
    }
}

